/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.instructions;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.interpreter.ConstantTable;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.IExpression;
import edu.mit.lcs.haystack.adenine.interpreter.IInstructionHandler;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.VariableFrame;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.Utilities;

public class LibraryInstruction
implements IInstructionHandler {
    IRDFContainer m_source;
    Interpreter m_interpreter;

    public void initialize(Interpreter interpreter) {
        this.m_interpreter = interpreter;
        this.m_source = interpreter.getRootRDFContainer();
    }

    public boolean isConstantExpression() {
        return false;
    }

    public Object evaluate(Resource res, Environment env, DynamicEnvironment denv) throws AdenineException {
        Resource resStart = Utilities.getResourceProperty(res, AdenineConstants.start, this.m_source);
        Resource resName = (Resource)this.m_interpreter.runInstruction(Utilities.getResourceProperty(res, AdenineConstants.name, this.m_source), env, denv);
        IRDFContainer target = denv.getTarget();
        try {
            target.add(new Statement(resName, Constants.s_rdf_type, AdenineConstants.LIBRARY));
            target.add(new Statement(resName, AdenineConstants.start, (Resource)this.m_interpreter.runInstruction(resStart, env, denv)));
        }
        catch (RDFException rdfe) {
            throw new AdenineException("RDF error", rdfe);
        }
        return resName;
    }

    public IExpression generateExpression(Resource res) throws AdenineException {
        return new IExpression(){
            Resource m_res;

            IExpression init(Resource res2) {
                this.m_res = res2;
                return this;
            }

            public void generateJava(String targetVar, StringBuffer buffer, VariableFrame frame, ConstantTable ct) throws AdenineException {
                throw new UnsupportedOperationException("library not supported with Java compilation");
            }

            public Object evaluate(Environment env, DynamicEnvironment denv) throws AdenineException {
                return LibraryInstruction.this.evaluate(this.m_res, env, denv);
            }
        }.init(res);
    }
}

