/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.instructions;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.SyntaxException;
import edu.mit.lcs.haystack.adenine.interpreter.ConstantTable;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.IExpression;
import edu.mit.lcs.haystack.adenine.interpreter.IInstructionHandler;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.VariableFrame;
import edu.mit.lcs.haystack.adenine.query.ConditionSet;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Utilities;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public class IndexInstruction
implements IInstructionHandler {
    IRDFContainer m_source;
    Interpreter m_interpreter;

    public void initialize(Interpreter interpreter) {
        this.m_interpreter = interpreter;
        this.m_source = interpreter.getRootRDFContainer();
    }

    public boolean isConstantExpression() {
        return false;
    }

    public static Object doIndex(Object base, Object index) throws AdenineException {
        if (base == null) {
            throw new AdenineException("Base is null");
        }
        if (base instanceof Collection) {
            Collection c = (Collection)base;
            if (index instanceof Number) {
                int i = ((Number)index).intValue();
                if (i < 0) {
                    throw new SyntaxException("Index out of bounds: " + index);
                }
                Object[] o = c.toArray();
                if (i > o.length - 1) {
                    throw new SyntaxException("Index out of bounds: " + index);
                }
                return o[i];
            }
        } else {
            if (base instanceof Map) {
                Map m = (Map)base;
                return m.get(index);
            }
            if (base.getClass().isArray()) {
                if (index instanceof Number) {
                    int i = ((Number)index).intValue();
                    if (i < 0) {
                        throw new SyntaxException("Index out of bounds: " + index);
                    }
                    if (i > Array.getLength(base) - 1) {
                        throw new SyntaxException("Index out of bounds: " + index);
                    }
                    return Array.get(base, i);
                }
            } else if (base instanceof ConditionSet) {
                ConditionSet cs = (ConditionSet)base;
                if (index instanceof Number) {
                    int i = ((Number)index).intValue();
                    if (i < 0) {
                        throw new SyntaxException("Index out of bounds: " + index);
                    }
                    if (i > cs.count() - 1) {
                        throw new SyntaxException("Index out of bounds: " + index);
                    }
                    return cs.get(i);
                }
            }
        }
        throw new SyntaxException("Invalid index " + index + " on collection " + base);
    }

    public Object evaluate(Resource res, Environment env, DynamicEnvironment denv) throws AdenineException {
        Resource resBase = Utilities.getResourceProperty(res, AdenineConstants.base, this.m_source);
        Resource resIndex = Utilities.getResourceProperty(res, AdenineConstants.index, this.m_source);
        Object base = this.m_interpreter.runInstruction(resBase, env, denv);
        Object index = this.m_interpreter.runInstruction(resIndex, env, denv);
        return IndexInstruction.doIndex(base, index);
    }

    public IExpression generateExpression(Resource res) throws AdenineException {
        return new IExpression(){
            IExpression m_base;
            IExpression m_index;

            IExpression init(Resource res2) throws AdenineException {
                Resource resBase = Utilities.getResourceProperty(res2, AdenineConstants.base, IndexInstruction.this.m_source);
                Resource resIndex = Utilities.getResourceProperty(res2, AdenineConstants.index, IndexInstruction.this.m_source);
                this.m_base = IndexInstruction.this.m_interpreter.compileInstruction(resBase);
                this.m_index = IndexInstruction.this.m_interpreter.compileInstruction(resIndex);
                return this;
            }

            public void generateJava(String targetVar, StringBuffer buffer, VariableFrame frame, ConstantTable ct) throws AdenineException {
                String index = Interpreter.generateIdentifier();
                buffer.append("Object ");
                buffer.append(index);
                buffer.append(";\n");
                this.m_index.generateJava(index, buffer, frame, ct);
                this.m_base.generateJava(targetVar, buffer, frame, ct);
                buffer.append(targetVar);
                buffer.append(" = IndexInstruction.doIndex(");
                buffer.append(targetVar);
                buffer.append(",");
                buffer.append(index);
                buffer.append(");");
            }

            public Object evaluate(Environment env, DynamicEnvironment denv) throws AdenineException {
                Object base = this.m_base.evaluate(env, denv);
                Object index = this.m_index.evaluate(env, denv);
                return IndexInstruction.doIndex(base, index);
            }
        }.init(res);
    }
}

