/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.instructions;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.interpreter.ConstantTable;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.IExpression;
import edu.mit.lcs.haystack.adenine.interpreter.IInstructionHandler;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.VariableFrame;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Literal;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.Utilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class ImportJavaInstruction
implements IInstructionHandler {
    IRDFContainer m_source;
    Interpreter m_interpreter;

    public void initialize(Interpreter interpreter) {
        this.m_interpreter = interpreter;
        this.m_source = interpreter.getRootRDFContainer();
    }

    public boolean isConstantExpression() {
        return false;
    }

    public Object evaluate(Resource res, Environment env, DynamicEnvironment denv) throws AdenineException {
        try {
            String packageName = Utilities.getLiteralProperty(res, AdenineConstants.PACKAGE, this.m_source);
            Set s = this.m_source.query(new Statement[]{new Statement(res, AdenineConstants.name, Utilities.generateWildcardResource(1))}, Utilities.generateWildcardResourceArray(1), Utilities.generateWildcardResourceArray(1));
            Iterator i = s.iterator();
            while (i.hasNext()) {
                Literal l = (Literal)((RDFNode[])i.next())[0];
                String className = l.getContent();
                try {
                    Class<?> c = Class.forName(String.valueOf(packageName) + "." + className.replace('-', '$'));
                    env.setValue(l.getContent(), c);
                }
                catch (Exception e) {
                    throw new AdenineException("Class could not be loaded", e);
                }
            }
        }
        catch (RDFException rdfe) {
            throw new AdenineException("Unknown error", rdfe);
        }
        return null;
    }

    public IExpression generateExpression(Resource res) throws AdenineException {
        return new IExpression(){
            Resource m_res;
            String m_packageName;
            ArrayList m_classes = new ArrayList();

            IExpression init(Resource res2) throws AdenineException {
                Set s;
                this.m_res = res2;
                this.m_packageName = Utilities.getLiteralProperty(res2, AdenineConstants.PACKAGE, ImportJavaInstruction.this.m_source);
                try {
                    s = ImportJavaInstruction.this.m_source.query(new Statement[]{new Statement(res2, AdenineConstants.name, Utilities.generateWildcardResource(1))}, Utilities.generateWildcardResourceArray(1), Utilities.generateWildcardResourceArray(1));
                }
                catch (RDFException e) {
                    throw new AdenineException("Unknown error", e);
                }
                Iterator i = s.iterator();
                while (i.hasNext()) {
                    Literal l = (Literal)((RDFNode[])i.next())[0];
                    this.m_classes.add(l.getContent());
                }
                return this;
            }

            public void generateJava(String targetVar, StringBuffer buffer, VariableFrame frame, ConstantTable ct) throws AdenineException {
                frame.m_variables.addAll(this.m_classes);
                buffer.append(targetVar);
                buffer.append(" = null;\n");
                buffer.append("try {\n");
                Iterator i = this.m_classes.iterator();
                while (i.hasNext()) {
                    String s = (String)i.next();
                    buffer.append(frame.generateVariableName(s));
                    buffer.append(" = Class.forName(\"");
                    buffer.append(this.m_packageName);
                    buffer.append(".");
                    buffer.append(s);
                    buffer.append("\");\n");
                }
                buffer.append("} catch (ClassNotFoundException cnfe) {\n");
                buffer.append("throw new AdenineException(\"\", cnfe);\n");
                buffer.append("}\n");
            }

            public Object evaluate(Environment env, DynamicEnvironment denv) throws AdenineException {
                Iterator i = this.m_classes.iterator();
                while (i.hasNext()) {
                    String s = (String)i.next();
                    try {
                        Class<?> c = Class.forName(String.valueOf(this.m_packageName) + "." + s);
                        env.setValue(s, c);
                    }
                    catch (Exception e) {
                        throw new AdenineException("Class " + this.m_packageName + "." + s + " could not be loaded", e);
                    }
                }
                return null;
            }
        }.init(res);
    }
}

