/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.instructions;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.interpreter.ConstantTable;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.IExpression;
import edu.mit.lcs.haystack.adenine.interpreter.IInstructionHandler;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.VariableFrame;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Utilities;

public class ImportInstruction
implements IInstructionHandler {
    IRDFContainer m_source;
    Interpreter m_interpreter;

    public void initialize(Interpreter interpreter) {
        this.m_interpreter = interpreter;
        this.m_source = interpreter.getRootRDFContainer();
    }

    public boolean isConstantExpression() {
        return false;
    }

    public Object evaluate(Resource res, Environment env, DynamicEnvironment denv) throws AdenineException {
        try {
            Resource resLibrary = Utilities.getResourceProperty(res, AdenineConstants.LIBRARY_, this.m_source);
            Resource resBody = Utilities.getResourceProperty(resLibrary, AdenineConstants.start, this.m_source);
            this.m_interpreter.runInstruction(resBody, env, denv);
        }
        catch (NullPointerException rdfe) {
            throw new AdenineException("Unknown error", rdfe);
        }
        return null;
    }

    public IExpression generateExpression(Resource res) throws AdenineException {
        return new IExpression(){
            Resource m_res;

            IExpression init(Resource res2) {
                this.m_res = res2;
                return this;
            }

            public void generateJava(String targetVar, StringBuffer buffer, VariableFrame frame, ConstantTable ct) throws AdenineException {
                throw new UnsupportedOperationException("import not supported with Java compilation");
            }

            public Object evaluate(Environment env, DynamicEnvironment denv) throws AdenineException {
                return ImportInstruction.this.evaluate(this.m_res, env, denv);
            }
        }.init(res);
    }
}

