/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.instructions;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.instructions.BreakException;
import edu.mit.lcs.haystack.adenine.instructions.ContinueException;
import edu.mit.lcs.haystack.adenine.interpreter.ConstantTable;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.IExpression;
import edu.mit.lcs.haystack.adenine.interpreter.IInstructionHandler;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.VariableFrame;
import edu.mit.lcs.haystack.adenine.query.ConditionSet;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.ListUtilities;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Utilities;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class ForInInstruction
implements IInstructionHandler {
    IRDFContainer m_source;
    Interpreter m_interpreter;
    static /* synthetic */ Class class$0;

    public void initialize(Interpreter interpreter) {
        this.m_interpreter = interpreter;
        this.m_source = interpreter.getRootRDFContainer();
    }

    public boolean isConstantExpression() {
        return false;
    }

    public static final Iterator getIterator(Object o, DynamicEnvironment denv) {
        if (o.getClass().isArray()) {
            return Arrays.asList((Object[])o).iterator();
        }
        if (o instanceof Collection) {
            return ((Collection)o).iterator();
        }
        if (o instanceof IRDFContainer) {
            try {
                return ((IRDFContainer)o).iterator();
            }
            catch (RDFException rdfe) {
                rdfe.printStackTrace();
                return null;
            }
        }
        if (o instanceof Iterator) {
            return (Iterator)o;
        }
        if (o instanceof ConditionSet) {
            return ((ConditionSet)o).iterator();
        }
        if (o instanceof Resource) {
            return ListUtilities.accessDAMLList((Resource)o, denv.getSource());
        }
        return null;
    }

    public Object evaluate(Resource res, Environment env, DynamicEnvironment denv) throws AdenineException {
        Resource resVariable = Utilities.getResourceProperty(res, AdenineConstants.var, this.m_source);
        Resource resCollection = Utilities.getResourceProperty(res, AdenineConstants.COLLECTION, this.m_source);
        Resource resBody = Utilities.getResourceProperty(res, AdenineConstants.body, this.m_source);
        String var = Utilities.getLiteralProperty(resVariable, AdenineConstants.name, this.m_source);
        Object c = this.m_interpreter.runInstruction(resCollection, env, denv);
        Iterator i = ForInInstruction.getIterator(c, denv);
        while (i.hasNext()) {
            Environment env2 = (Environment)env.clone();
            env2.allocateCell(var);
            env2.setValue(var, i.next());
            try {
                this.m_interpreter.runInstruction(resBody, env2, denv);
            }
            catch (ContinueException continueException) {
            }
            catch (BreakException be) {
                return null;
            }
        }
        return null;
    }

    public IExpression generateExpression(Resource res) throws AdenineException {
        return new IExpression(){
            IExpression m_body;
            IExpression m_collection;
            String m_var;

            IExpression init(Resource res2) throws AdenineException {
                Resource resVariable = Utilities.getResourceProperty(res2, AdenineConstants.var, ForInInstruction.this.m_source);
                Resource resCollection = Utilities.getResourceProperty(res2, AdenineConstants.COLLECTION, ForInInstruction.this.m_source);
                Resource resBody = Utilities.getResourceProperty(res2, AdenineConstants.body, ForInInstruction.this.m_source);
                this.m_var = Utilities.getLiteralProperty(resVariable, AdenineConstants.name, ForInInstruction.this.m_source);
                this.m_body = ForInInstruction.this.m_interpreter.compileInstruction(resBody);
                this.m_collection = ForInInstruction.this.m_interpreter.compileInstruction(resCollection);
                return this;
            }

            public void generateJava(String targetVar, StringBuffer buffer, VariableFrame frame, ConstantTable ct) throws AdenineException {
                this.m_collection.generateJava(targetVar, buffer, frame, ct);
                String ident = Interpreter.generateIdentifier();
                buffer.append("Iterator ");
                buffer.append(ident);
                buffer.append(" = ");
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("[Ledu.mit.lcs.haystack.adenine.instructions.ForInInstruction;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                buffer.append(clazz.getName());
                buffer.append(".getIterator(");
                buffer.append(targetVar);
                buffer.append(", __dynamicenvironment__);\nwhile (");
                buffer.append(ident);
                buffer.append(".hasNext()) {\n");
                StringBuffer sb = new StringBuffer();
                VariableFrame vf = Interpreter.generateJavaBlock(null, this.m_body, sb, frame, this.m_var, ct, true);
                buffer.append("Object ");
                buffer.append(vf.resolveVariableName(this.m_var));
                buffer.append(" = ");
                buffer.append(ident);
                buffer.append(".next();\n");
                buffer.append(sb);
                buffer.append("}\n");
                buffer.append(targetVar);
                buffer.append(" = null;\n");
            }

            public Object evaluate(Environment env, DynamicEnvironment denv) throws AdenineException {
                Object c = this.m_collection.evaluate(env, denv);
                Iterator i = ForInInstruction.getIterator(c, denv);
                while (i.hasNext()) {
                    Environment env2 = (Environment)env.clone();
                    env2.allocateCell(this.m_var);
                    env2.setValue(this.m_var, i.next());
                    try {
                        this.m_body.evaluate(env2, denv);
                    }
                    catch (ContinueException continueException) {
                    }
                    catch (BreakException be) {
                        return null;
                    }
                }
                return null;
            }
        }.init(res);
    }
}

