/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.instructions;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.interpreter.ConstantTable;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.IDereferenceable;
import edu.mit.lcs.haystack.adenine.interpreter.IExpression;
import edu.mit.lcs.haystack.adenine.interpreter.IInstructionHandler;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.InvalidMemberException;
import edu.mit.lcs.haystack.adenine.interpreter.JavaMethodWrapper;
import edu.mit.lcs.haystack.adenine.interpreter.VariableFrame;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Utilities;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class DereferencementInstruction
implements IInstructionHandler {
    IRDFContainer m_source;
    Interpreter m_interpreter;

    public void initialize(Interpreter interpreter) {
        this.m_interpreter = interpreter;
        this.m_source = interpreter.getRootRDFContainer();
    }

    public boolean isConstantExpression() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Object evaluate(Resource res, Environment env, DynamicEnvironment denv) throws AdenineException {
        void var6_6;
        Object member;
        Resource resBase = Utilities.getResourceProperty(res, AdenineConstants.base, this.m_source);
        Resource resMember = Utilities.getResourceProperty(res, AdenineConstants.member, this.m_source);
        if (Utilities.isType(resMember, AdenineConstants.Identifier, this.m_source)) {
            member = Utilities.getLiteralProperty(resMember, AdenineConstants.name, this.m_source);
        } else if (Utilities.isType(resMember, AdenineConstants.Resource, this.m_source)) {
            member = Utilities.getResourceProperty(resMember, AdenineConstants.resource, this.m_source);
        } else {
            throw new InvalidMemberException(resMember);
        }
        Object base = this.m_interpreter.runInstruction(resBase, env, denv);
        return DereferencementInstruction.doDereferencement(base, var6_6);
    }

    public static final Object doDereferencement(Object base, Object member) throws AdenineException {
        Object o;
        if (base == null) {
            throw new AdenineException("Attempt to dereference " + member + " from null");
        }
        if (base instanceof IDereferenceable) {
            return ((IDereferenceable)base).getMember(member);
        }
        if (base instanceof Class && (o = DereferencementInstruction.findMember((Class)base, (String)member, base)) != null) {
            return o;
        }
        return DereferencementInstruction.findMember(base.getClass(), (String)member, base);
    }

    static final Object findMember(Class c, String member, Object base) throws AdenineException {
        Method[] m = c.getMethods();
        ArrayList<Method> methods = new ArrayList<Method>();
        int i = 0;
        while (i < m.length) {
            if (m[i].getName().equals(member)) {
                methods.add(m[i]);
            }
            ++i;
        }
        if (methods.size() > 0) {
            return new JavaMethodWrapper(base, member, methods);
        }
        Field[] f = c.getFields();
        int i2 = 0;
        while (i2 < f.length) {
            if (f[i2].getName().equals(member)) {
                try {
                    return f[i2].get(base);
                }
                catch (IllegalAccessException iae) {
                    throw new AdenineException("Cannot access field " + member, iae);
                }
            }
            ++i2;
        }
        return null;
    }

    public IExpression generateExpression(Resource res) throws AdenineException {
        return new IExpression(){
            Object m_member;
            IExpression m_base;
            boolean m_identifierBase;

            public void generateJava(String targetVar, StringBuffer buffer, VariableFrame frame, ConstantTable ct) throws AdenineException {
                String ident = Interpreter.generateIdentifier();
                buffer.append("Object ");
                buffer.append(ident);
                buffer.append(";\n");
                this.m_base.generateJava(ident, buffer, frame, ct);
                buffer.append(targetVar);
                buffer.append(" = DereferencementInstruction.doDereferencement(");
                buffer.append(ident);
                if (this.m_identifierBase) {
                    buffer.append(",\"");
                    buffer.append(this.m_member);
                    buffer.append("\");\n");
                } else {
                    buffer.append(",new Resource(\"");
                    buffer.append(Interpreter.escapeString(((Resource)this.m_member).getURI()));
                    buffer.append("\"));\n");
                }
            }

            IExpression init(Resource res2) throws AdenineException {
                Resource resBase = Utilities.getResourceProperty(res2, AdenineConstants.base, DereferencementInstruction.this.m_source);
                Resource resMember = Utilities.getResourceProperty(res2, AdenineConstants.member, DereferencementInstruction.this.m_source);
                if (Utilities.isType(resMember, AdenineConstants.Identifier, DereferencementInstruction.this.m_source)) {
                    this.m_member = Utilities.getLiteralProperty(resMember, AdenineConstants.name, DereferencementInstruction.this.m_source);
                    this.m_identifierBase = true;
                } else if (Utilities.isType(resMember, AdenineConstants.Resource, DereferencementInstruction.this.m_source)) {
                    this.m_member = Utilities.getResourceProperty(resMember, AdenineConstants.resource, DereferencementInstruction.this.m_source);
                    this.m_identifierBase = false;
                } else {
                    throw new InvalidMemberException(resMember);
                }
                this.m_base = DereferencementInstruction.this.m_interpreter.compileInstruction(resBase);
                return this;
            }

            public Object evaluate(Environment env, DynamicEnvironment denv) throws AdenineException {
                Object base = this.m_base.evaluate(env, denv);
                return DereferencementInstruction.doDereferencement(base, this.m_member);
            }
        }.init(res);
    }
}

