/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.utils;

import edu.mit.lcs.haystack.adenine.compilers.utils.ParserVisitorBase;
import edu.mit.lcs.haystack.adenine.compilers.utils.TopLevelAnonymousModelVisitor;
import edu.mit.lcs.haystack.adenine.compilers.utils.TopLevelListVisitor;
import edu.mit.lcs.haystack.adenine.compilers.utils.TopLevelModelVisitor;
import edu.mit.lcs.haystack.adenine.compilers.utils.TopLevelSubExpressionVisitor;
import edu.mit.lcs.haystack.adenine.compilers.utils.TopLevelVisitorBase;
import edu.mit.lcs.haystack.adenine.parser2.IAnonymousModelVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IApplyVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IAskModelVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IExpressionVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IListVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IModelVisitor;
import edu.mit.lcs.haystack.adenine.parser2.ISubExpressionVisitor;
import edu.mit.lcs.haystack.adenine.parser2.NullApplyVisitor;
import edu.mit.lcs.haystack.adenine.parser2.NullAskModelVisitor;
import edu.mit.lcs.haystack.adenine.parser2.NullExpressionVisitor;
import edu.mit.lcs.haystack.adenine.parser2.NullSubExpressionVisitor;
import edu.mit.lcs.haystack.adenine.parser2.SyntaxException;
import edu.mit.lcs.haystack.adenine.tokenizer.FloatToken;
import edu.mit.lcs.haystack.adenine.tokenizer.IntegerToken;
import edu.mit.lcs.haystack.adenine.tokenizer.LiteralToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.adenine.tokenizer.StringToken;
import edu.mit.lcs.haystack.adenine.tokenizer.SymbolToken;
import edu.mit.lcs.haystack.rdf.Literal;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;

public class TopLevelExpressionVisitor
extends ParserVisitorBase
implements IExpressionVisitor {
    TopLevelVisitorBase m_topLevelVisitor;
    boolean m_expectsResource;
    TopLevelSubExpressionVisitor m_subExpressionVisitor;
    TopLevelListVisitor m_listVisitor;
    TopLevelModelVisitor m_modelVisitor;
    TopLevelAnonymousModelVisitor m_anonymousModelVisitor;
    RDFNode m_result;

    public TopLevelExpressionVisitor(TopLevelVisitorBase topLevelVisitor, boolean expectsResource) {
        super(topLevelVisitor.getChainedVisitor());
        this.m_topLevelVisitor = topLevelVisitor;
        this.m_expectsResource = expectsResource;
    }

    public TopLevelExpressionVisitor(TopLevelVisitorBase topLevelVisitor) {
        this(topLevelVisitor, false);
    }

    public ISubExpressionVisitor onDereference(SymbolToken periodT) {
        this.onException(new SyntaxException("No dereferencement allowed at top level", periodT.getSpan()));
        return new NullSubExpressionVisitor(this.m_visitor);
    }

    public IExpressionVisitor onLeftBracket(SymbolToken leftBracketT) {
        this.onException(new SyntaxException("No index allowed at top level", leftBracketT.getSpan()));
        return new NullExpressionVisitor(this.m_visitor);
    }

    public void onRightBracket(SymbolToken rightBracketT) {
    }

    public ISubExpressionVisitor onSubExpression(Location location) {
        this.m_subExpressionVisitor = new TopLevelSubExpressionVisitor(this.m_topLevelVisitor);
        return this.m_subExpressionVisitor;
    }

    public IAnonymousModelVisitor onAnonymousModel(Location location) {
        this.m_anonymousModelVisitor = new TopLevelAnonymousModelVisitor(this.m_topLevelVisitor);
        return this.m_anonymousModelVisitor;
    }

    public IApplyVisitor onApply(Location location) {
        return new NullApplyVisitor(this.m_visitor){

            public void onLeftParenthesis(SymbolToken leftParenthesisT) {
                this.onException(new SyntaxException("Method application not allowed in top level model", leftParenthesisT.getSpan()));
            }
        };
    }

    public IAskModelVisitor onAskModel(Location location) {
        return new NullAskModelVisitor(this.m_visitor){

            public void onModelStart(SymbolToken percentT, SymbolToken leftBraceT) {
                this.onException(new SyntaxException("Ask model not allowed in top level model", percentT.getSpan()));
            }
        };
    }

    public void onFloat(FloatToken floatToken) {
        this.m_result = new Literal(floatToken.getContent());
    }

    public void onInteger(IntegerToken integerToken) {
        this.m_result = new Literal(integerToken.getContent());
    }

    public IListVisitor onList(Location location) {
        this.m_listVisitor = new TopLevelListVisitor(this.m_topLevelVisitor);
        return this.m_listVisitor;
    }

    public void onLiteral(LiteralToken literalToken) {
        this.m_result = new Literal(literalToken.getContent());
    }

    public IModelVisitor onModel(Location location) {
        this.m_modelVisitor = new TopLevelModelVisitor(this.m_topLevelVisitor);
        return this.m_modelVisitor;
    }

    public void onString(StringToken stringToken) {
        this.m_result = new Literal(stringToken.getContent());
    }

    public RDFNode getRDFNode() {
        if (this.m_result != null) {
            return this.m_result;
        }
        if (this.m_listVisitor != null) {
            return this.m_listVisitor.getListResource();
        }
        if (this.m_anonymousModelVisitor != null) {
            return this.m_anonymousModelVisitor.getAnonymousResource();
        }
        if (this.m_modelVisitor != null) {
            return this.m_modelVisitor.getLastResource();
        }
        try {
            return this.m_subExpressionVisitor.getRDFNode();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Resource getResource() {
        return (Resource)this.getRDFNode();
    }
}

