/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.rdfCode;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.ConstructVisitorBase;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.ExpressionVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.InnerCodeBlockVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.TopLevelVisitor;
import edu.mit.lcs.haystack.adenine.constructs.IWhileVisitor;
import edu.mit.lcs.haystack.adenine.parser2.ICodeBlockVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IExpressionVisitor;
import edu.mit.lcs.haystack.adenine.tokenizer.GenericToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import java.util.List;

public class WhileVisitor
extends ConstructVisitorBase
implements IWhileVisitor {
    protected ExpressionVisitor m_condition;
    protected InnerCodeBlockVisitor m_block;
    protected Location m_startLocation;

    public WhileVisitor(TopLevelVisitor visitor, List instructionList) {
        super(visitor, instructionList);
    }

    public void end(Location endLocation) {
        Resource condition;
        if (this.m_condition != null && (condition = this.m_condition.getInstructionResource()) != null) {
            IRDFContainer target = this.m_topLevelVisitor.getTarget();
            this.m_topLevelVisitor.makeInstruction(this.m_instructionResource, AdenineConstants.While, this.m_startLocation);
            try {
                target.add(new Statement(this.m_instructionResource, AdenineConstants.CONDITION, condition));
                if (this.m_block != null) {
                    Resource block = this.m_block.getFirstInstruction();
                    target.add(new Statement(this.m_instructionResource, AdenineConstants.body, block));
                }
                super.end(endLocation);
                return;
            }
            catch (RDFException e) {
                this.onException(e);
            }
        }
        this.m_instructionResource = null;
        super.end(endLocation);
    }

    public ICodeBlockVisitor onBody() {
        this.m_block = new InnerCodeBlockVisitor(this.m_topLevelVisitor);
        return this.m_block;
    }

    public IExpressionVisitor onWhile(GenericToken whileKeyword) {
        this.m_condition = new ExpressionVisitor(this.m_topLevelVisitor);
        this.m_startLocation = whileKeyword.getSpan().getStart();
        return this.m_condition;
    }
}

