/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.rdfCode;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.AttributeVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.ExpressionVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.Section;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.TopLevelVisitor;
import edu.mit.lcs.haystack.adenine.compilers.utils.ParserVisitorBase;
import edu.mit.lcs.haystack.adenine.parser2.IAttributeVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IExpressionVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IModelVisitor;
import edu.mit.lcs.haystack.adenine.parser2.NullAttributeVisitor;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.adenine.tokenizer.SymbolToken;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import java.util.Iterator;
import java.util.LinkedList;

public class ModelVisitor
extends ParserVisitorBase
implements IModelVisitor {
    protected TopLevelVisitor m_topLevelVisitor;
    protected LinkedList m_sections = new LinkedList();
    protected Section m_section;
    protected Resource m_instructionResource;

    public ModelVisitor(TopLevelVisitor topLevelVisitor) {
        super(topLevelVisitor);
        this.m_topLevelVisitor = topLevelVisitor;
    }

    public IExpressionVisitor onSubject(Location location) {
        this.m_section = new Section();
        this.m_section.m_subjectVisitor = new ExpressionVisitor(this.m_topLevelVisitor);
        this.m_sections.add(0, this.m_section);
        return this.m_section.m_subjectVisitor;
    }

    public IAttributeVisitor onAttribute(SymbolToken semicolonT) {
        if (this.m_section != null && this.m_section.m_subjectVisitor != null && this.m_section.m_subjectVisitor.getInstructionResource() instanceof Resource) {
            AttributeVisitor av = new AttributeVisitor(this.m_topLevelVisitor);
            this.m_section.m_attributeVisitors.add(av);
            return av;
        }
        return new NullAttributeVisitor(this.m_visitor);
    }

    public void onModelEnd(SymbolToken rightBraceT) {
    }

    public void onModelStart(SymbolToken leftBraceT) {
    }

    public void end(Location endLocation) {
        IRDFContainer target = this.m_topLevelVisitor.getTarget();
        this.m_instructionResource = this.m_topLevelVisitor.generateInstruction(AdenineConstants.Model, this.m_startLocation);
        Iterator s = this.m_sections.iterator();
        while (s.hasNext()) {
            Section section = (Section)s.next();
            Resource subjectInstruction = section.m_subjectVisitor.getInstructionResource();
            if (subjectInstruction == null) continue;
            Iterator v = section.m_attributeVisitors.iterator();
            while (v.hasNext()) {
                AttributeVisitor visitor = (AttributeVisitor)v.next();
                Resource predicateInstruction = visitor.getPredicateInstruction();
                Resource objectInstruction = visitor.getObjectInstruction();
                Resource statement = this.m_topLevelVisitor.getURIGenerator().generateAnonymousResource();
                try {
                    target.add(new Statement(statement, Constants.s_rdf_type, AdenineConstants.Statement));
                    target.add(new Statement(statement, AdenineConstants.subject, subjectInstruction));
                    target.add(new Statement(statement, AdenineConstants.predicate, predicateInstruction));
                    target.add(new Statement(statement, AdenineConstants.object, objectInstruction));
                    target.add(new Statement(this.m_instructionResource, AdenineConstants.statement, statement));
                }
                catch (RDFException e) {
                    this.onException(e);
                }
            }
        }
    }
}

