/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.rdfCode;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.ConstructVisitorBase;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.InnerCodeBlockVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.TopLevelVisitor;
import edu.mit.lcs.haystack.adenine.compilers.utils.TopLevelExpressionVisitor;
import edu.mit.lcs.haystack.adenine.constructs.IMethodVisitor;
import edu.mit.lcs.haystack.adenine.parser2.ICodeBlockVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IExpressionVisitor;
import edu.mit.lcs.haystack.adenine.tokenizer.GenericToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.adenine.tokenizer.ResourceToken;
import edu.mit.lcs.haystack.adenine.tokenizer.SymbolToken;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.ListUtilities;
import edu.mit.lcs.haystack.rdf.Literal;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class MethodVisitor
extends ConstructVisitorBase
implements IMethodVisitor {
    List m_parameters = new LinkedList();
    InnerCodeBlockVisitor m_innerBlockVisitor;
    TopLevelExpressionVisitor m_methodResourceVisitor;

    public MethodVisitor(TopLevelVisitor visitor, List instructionList) {
        super(visitor, instructionList);
    }

    public IExpressionVisitor onMethod(GenericToken methodKeyword) {
        return null;
    }

    public void onParameter(GenericToken parameter) {
        if (this.m_instructionResource != null) {
            this.m_parameters.add(this.m_topLevelVisitor.generateIdentifierInstruction(parameter));
        }
    }

    public void onNamedParameter(ResourceToken name, SymbolToken equalT, GenericToken parameter) {
        IRDFContainer target = this.m_topLevelVisitor.getTarget();
        Resource param = this.m_topLevelVisitor.getURIGenerator().generateAnonymousResource();
        try {
            target.add(new Statement(param, AdenineConstants.parameterName, this.m_topLevelVisitor.resolveURI(name)));
            target.add(new Statement(param, AdenineConstants.parameterVariable, this.m_topLevelVisitor.generateIdentifierInstruction(parameter)));
            target.add(new Statement(this.getMethodResource(), AdenineConstants.namedParameter, param));
        }
        catch (RDFException e) {
            this.onException(e);
        }
    }

    public ICodeBlockVisitor onBlock() {
        this.m_innerBlockVisitor = new InnerCodeBlockVisitor(this.m_topLevelVisitor);
        return this.m_innerBlockVisitor;
    }

    public boolean canBeAnonymous() {
        return true;
    }

    public void start(Location startLocation) {
        super.start(startLocation);
        this.m_topLevelVisitor.pushMethod();
    }

    public void end(Location endLocation) {
        Set backquotedIdentifiers = this.m_topLevelVisitor.popMethod();
        if (this.m_instructionResource != null) {
            IRDFContainer target = this.m_topLevelVisitor.getTarget();
            ArrayList orderedBackquotedIdentifiers = new ArrayList(backquotedIdentifiers);
            ArrayList<Literal> orderedBackquotedIdentifiersAsLiterals = new ArrayList<Literal>();
            try {
                Resource firstInstruction;
                int i = orderedBackquotedIdentifiers.size() - 1;
                while (i >= 0) {
                    Resource p = this.m_topLevelVisitor.generateInstruction(AdenineConstants.Identifier, this.m_startLocation);
                    Literal identifier = new Literal((String)orderedBackquotedIdentifiers.get(i));
                    target.add(new Statement(p, AdenineConstants.name, identifier));
                    this.m_parameters.add(0, p);
                    orderedBackquotedIdentifiersAsLiterals.add(0, identifier);
                    --i;
                }
                target.add(new Statement(this.getMethodResource(), AdenineConstants.PARAMETERS, ListUtilities.createDAMLList(this.m_parameters.iterator(), target)));
                target.add(new Statement(this.m_instructionResource, AdenineConstants.BACKQUOTED_PARAMETERS, ListUtilities.createDAMLList(orderedBackquotedIdentifiersAsLiterals.iterator(), target)));
                Resource resource = firstInstruction = this.m_innerBlockVisitor != null ? this.m_innerBlockVisitor.getFirstInstruction() : null;
                if (firstInstruction != null) {
                    target.add(new Statement(this.getMethodResource(), AdenineConstants.start, firstInstruction));
                }
            }
            catch (RDFException e) {
                this.onException(e);
            }
        }
        super.end(endLocation);
    }

    Resource getMethodResource() {
        return this.m_methodResourceVisitor.getResource();
    }
}

