/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.rdfCode;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.ConstructVisitorBase;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.ExpressionVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.TopLevelVisitor;
import edu.mit.lcs.haystack.adenine.constructs.ICallVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IExpressionVisitor;
import edu.mit.lcs.haystack.adenine.tokenizer.GenericToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.adenine.tokenizer.ResourceToken;
import edu.mit.lcs.haystack.adenine.tokenizer.SymbolToken;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.ListUtilities;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import java.util.ArrayList;
import java.util.List;

public class CallVisitor
extends ConstructVisitorBase
implements ICallVisitor {
    protected List m_arguments = new ArrayList();
    protected List m_argumentNames = new ArrayList();
    protected List m_namedArguments = new ArrayList();
    protected List m_results = new ArrayList();
    protected List m_resultNames = new ArrayList();
    protected List m_namedResults = new ArrayList();
    protected ExpressionVisitor m_callable;
    protected Location m_startLocation;

    public CallVisitor(TopLevelVisitor visitor, List instructionList) {
        super(visitor, instructionList);
    }

    public void start(Location startLocation) {
        this.m_startLocation = startLocation;
    }

    public IExpressionVisitor onArgument(Location location) {
        ExpressionVisitor ev = new ExpressionVisitor(this.m_topLevelVisitor);
        this.m_arguments.add(ev);
        return ev;
    }

    public void onCall(GenericToken callKeyword) {
    }

    public IExpressionVisitor onCallable(Location location) {
        this.m_callable = new ExpressionVisitor(this.m_topLevelVisitor);
        return this.m_callable;
    }

    public void onComma(SymbolToken commaT) {
    }

    public IExpressionVisitor onNamedArgument(ResourceToken name, SymbolToken equalT) {
        ExpressionVisitor ev = new ExpressionVisitor(this.m_topLevelVisitor);
        this.m_namedArguments.add(ev);
        this.m_argumentNames.add(name);
        return ev;
    }

    public void onResult(GenericToken variable) {
        this.m_results.add(variable);
    }

    public void onNamedResult(ResourceToken name, SymbolToken equalT, GenericToken variable) {
        this.m_namedResults.add(variable);
        this.m_resultNames.add(name);
    }

    public void end(Location endLocation) {
        Resource callable;
        if (this.m_callable != null && (callable = this.m_callable.getInstructionResource()) != null) {
            IRDFContainer target = this.m_topLevelVisitor.getTarget();
            this.m_topLevelVisitor.makeInstruction(this.m_instructionResource, AdenineConstants.Call, this.m_startLocation);
            ArrayList<Resource> arguments = new ArrayList<Resource>();
            int i = 0;
            while (i < this.m_arguments.size()) {
                Resource r = ((ExpressionVisitor)this.m_arguments.get(i)).getInstructionResource();
                if (r != null) {
                    arguments.add(r);
                }
                ++i;
            }
            i = 0;
            while (i < this.m_namedArguments.size()) {
                Resource a = ((ExpressionVisitor)this.m_namedArguments.get(i)).getInstructionResource();
                Resource n = this.m_topLevelVisitor.resolveURI((ResourceToken)this.m_argumentNames.get(i));
                if (a != null && n != null) {
                    Resource r = this.m_topLevelVisitor.getURIGenerator().generateAnonymousResource();
                    try {
                        target.add(new Statement(r, AdenineConstants.parameterName, n));
                        target.add(new Statement(r, AdenineConstants.parameterVariable, a));
                        target.add(new Statement(this.m_instructionResource, AdenineConstants.namedParameter, r));
                    }
                    catch (RDFException e) {
                        this.onException(e);
                    }
                }
                ++i;
            }
            ArrayList<Resource> results = new ArrayList<Resource>();
            int i2 = 0;
            while (i2 < this.m_results.size()) {
                Resource r = this.m_topLevelVisitor.generateIdentifierInstruction((GenericToken)this.m_results.get(i2));
                if (r != null) {
                    results.add(r);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.m_namedResults.size()) {
                Resource a = ((ExpressionVisitor)this.m_namedResults.get(i2)).getInstructionResource();
                Resource n = this.m_topLevelVisitor.resolveURI((ResourceToken)this.m_resultNames.get(i2));
                if (a != null && n != null) {
                    Resource r = this.m_topLevelVisitor.getURIGenerator().generateAnonymousResource();
                    try {
                        target.add(new Statement(r, AdenineConstants.parameterName, n));
                        target.add(new Statement(r, AdenineConstants.parameterVariable, a));
                        target.add(new Statement(this.m_instructionResource, AdenineConstants.NAMED_RETURN_PARAMETER, r));
                    }
                    catch (RDFException e) {
                        this.onException(e);
                    }
                }
                ++i2;
            }
            try {
                target.add(new Statement(this.m_instructionResource, AdenineConstants.function, this.m_callable.getInstructionResource()));
                target.add(new Statement(this.m_instructionResource, AdenineConstants.PARAMETERS, ListUtilities.createDAMLList(arguments.iterator(), target)));
                target.add(new Statement(this.m_instructionResource, AdenineConstants.RETURN_PARAMETERS, ListUtilities.createDAMLList(results.iterator(), target)));
            }
            catch (RDFException e) {
                this.onException(e);
            }
            super.end(endLocation);
            return;
        }
        this.m_instructionResource = null;
        super.end(endLocation);
    }
}

