/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.rdfCode;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.ConstructVisitorBase;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.ExpressionVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.TopLevelVisitor;
import edu.mit.lcs.haystack.adenine.constructs.IAssignmentVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IExpressionVisitor;
import edu.mit.lcs.haystack.adenine.tokenizer.GenericToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.adenine.tokenizer.SymbolToken;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import java.util.List;

public class AssignmentVisitor
extends ConstructVisitorBase
implements IAssignmentVisitor {
    protected Resource m_lhs;
    protected ExpressionVisitor m_rhs;

    public AssignmentVisitor(TopLevelVisitor visitor, List instructionList) {
        super(visitor, instructionList);
    }

    public void onLHS(SymbolToken equalT, GenericToken identifier) {
        this.m_lhs = this.m_topLevelVisitor.generateIdentifierInstruction(identifier);
    }

    public IExpressionVisitor onRHS(Location location) {
        this.m_rhs = new ExpressionVisitor(this.m_topLevelVisitor);
        return this.m_rhs;
    }

    public void end(Location endLocation) {
        if (this.m_lhs != null && this.m_rhs != null) {
            Resource lhs = this.m_lhs;
            Resource rhs = this.m_rhs.getInstructionResource();
            if (lhs != null && rhs != null) {
                IRDFContainer target = this.m_topLevelVisitor.getTarget();
                try {
                    this.m_topLevelVisitor.makeInstruction(this.m_instructionResource, AdenineConstants.Assignment, endLocation);
                    target.add(new Statement(this.m_instructionResource, AdenineConstants.LHS, lhs));
                    target.add(new Statement(this.m_instructionResource, AdenineConstants.RHS, rhs));
                    super.end(endLocation);
                    return;
                }
                catch (RDFException e) {
                    this.onException(e);
                }
            }
        }
        this.m_instructionResource = null;
        super.end(endLocation);
    }
}

