/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.rdfCode;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.AttributeVisitor;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.TopLevelVisitor;
import edu.mit.lcs.haystack.adenine.compilers.utils.ParserVisitorBase;
import edu.mit.lcs.haystack.adenine.parser2.IAnonymousModelVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IAttributeVisitor;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.adenine.tokenizer.SymbolToken;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import java.util.Iterator;
import java.util.LinkedList;

public class AnonymousModelVisitor
extends ParserVisitorBase
implements IAnonymousModelVisitor {
    protected TopLevelVisitor m_topLevelVisitor;
    protected LinkedList m_attributeVisitors = new LinkedList();
    protected Resource m_instructionResource;

    public AnonymousModelVisitor(TopLevelVisitor topLevelVisitor) {
        super(topLevelVisitor);
        this.m_topLevelVisitor = topLevelVisitor;
    }

    public IAttributeVisitor onAttribute(SymbolToken semicolonT) {
        AttributeVisitor av = new AttributeVisitor(this.m_topLevelVisitor);
        this.m_attributeVisitors.add(av);
        return av;
    }

    public void onModelEnd(SymbolToken rightBraceT) {
    }

    public void onModelStart(SymbolToken dollarSignT, SymbolToken leftBraceT) {
    }

    public void end(Location endLocation) {
        IRDFContainer target = this.m_topLevelVisitor.getTarget();
        this.m_instructionResource = this.m_topLevelVisitor.generateInstruction(AdenineConstants.BNode, this.m_startLocation);
        Iterator v = this.m_attributeVisitors.iterator();
        while (v.hasNext()) {
            AttributeVisitor visitor = (AttributeVisitor)v.next();
            Resource predicateInstruction = visitor.getPredicateInstruction();
            Resource objectInstruction = visitor.getObjectInstruction();
            if (predicateInstruction == null || objectInstruction == null) continue;
            Resource statement = this.m_topLevelVisitor.getURIGenerator().generateAnonymousResource();
            try {
                target.add(new Statement(statement, Constants.s_rdf_type, AdenineConstants.Statement));
                target.add(new Statement(statement, AdenineConstants.predicate, predicateInstruction));
                target.add(new Statement(statement, AdenineConstants.object, objectInstruction));
                target.add(new Statement(this.m_instructionResource, AdenineConstants.statement, statement));
            }
            catch (RDFException e) {
                this.onException(e);
            }
        }
    }
}

