/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.javaByteCode;

import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.CodeFrame;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.CodeFrameWithMethodGen;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.CodeGenerator;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.JavaByteCodeCompiler;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.TopLevelVisitor;
import edu.mit.lcs.haystack.adenine.interpreter.AdenineClassLoaderManager;
import edu.mit.lcs.haystack.adenine.tokenizer.GenericToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.rdf.Resource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.generic.AALOAD;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.ARRAYLENGTH;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.IF_ICMPGE;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.JSR;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.RETURN;
import org.apache.bcel.generic.Type;

public class JavaByteCodeUtilities {
    public static ObjectType s_typeClass = new ObjectType("java.lang.Class");
    public static ObjectType s_typeMessage = new ObjectType("edu.mit.lcs.haystack.adenine.interpreter.Message");
    public static ObjectType s_typeEnvironment = new ObjectType("edu.mit.lcs.haystack.adenine.interpreter.Environment");
    public static ObjectType s_typeDynamicEnvironment = new ObjectType("edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment");
    public static ObjectType s_typeInterpreter = new ObjectType("edu.mit.lcs.haystack.adenine.interpreter.Interpreter");
    public static ObjectType s_typeCallable = new ObjectType("edu.mit.lcs.haystack.adenine.interpreter.ICallable");
    public static ObjectType s_typeRDFNode = new ObjectType("edu.mit.lcs.haystack.rdf.RDFNode");
    public static ObjectType s_typeResource = new ObjectType("edu.mit.lcs.haystack.rdf.Resource");
    public static ObjectType s_typeLiteral = new ObjectType("edu.mit.lcs.haystack.rdf.Literal");
    public static ObjectType s_typeStatement = new ObjectType("edu.mit.lcs.haystack.rdf.Statement");
    public static ObjectType s_typeIRDFContainer = new ObjectType("edu.mit.lcs.haystack.rdf.IRDFContainer");
    public static ObjectType s_typeLocalRDFContainer = new ObjectType("edu.mit.lcs.haystack.rdf.LocalRDFContainer");
    public static ObjectType s_typeDouble = new ObjectType("java.lang.Double");
    public static ObjectType s_typeInteger = new ObjectType("java.lang.Integer");
    public static ObjectType s_typeBoolean = new ObjectType("java.lang.Boolean");
    public static ObjectType s_typeList = new ObjectType("java.util.List");
    public static ObjectType s_typeArrayList = new ObjectType("java.util.ArrayList");
    public static ObjectType s_typeLinkedList = new ObjectType("java.util.LinkedList");
    public static ObjectType s_typeIterator = new ObjectType("java.util.Iterator");
    public static ObjectType s_typeMap = new ObjectType("java.util.Map");
    public static ObjectType s_typeHashMap = new ObjectType("java.util.HashMap");
    public static ArrayType s_typeObjectArray = new ArrayType("java.lang.Object", 1);

    public static InstructionHandle[] generateTryFinally(ClassGen cg, MethodGen mg, InstructionList iList, ConstantPoolGen cpg, CodeGenerator generator, int line) {
        BranchHandle bhEndOfNormalCodeToFinally = iList.append((BranchInstruction)new JSR(null));
        mg.addLineNumber((InstructionHandle)bhEndOfNormalCodeToFinally, line);
        BranchHandle bhEndOfNormalCodeToAfterFinally = iList.append((BranchInstruction)new GOTO(null));
        mg.addLineNumber((InstructionHandle)bhEndOfNormalCodeToAfterFinally, line);
        LocalVariableGen lvg1 = mg.addLocalVariable("throwable", (Type)Type.THROWABLE, null, null);
        int throwableIndex = lvg1.getIndex();
        InstructionHandle ihStartOfCatchAll = iList.append((Instruction)new ASTORE(throwableIndex));
        mg.addLineNumber(ihStartOfCatchAll, line);
        BranchHandle bhCatchAllToFinally = iList.append((BranchInstruction)new JSR(null));
        mg.addLineNumber((InstructionHandle)bhCatchAllToFinally, line);
        InstructionHandle ihLoadThrowable = iList.append((Instruction)new ALOAD(throwableIndex));
        mg.addLineNumber(ihLoadThrowable, line);
        InstructionHandle ihThrow = iList.append((Instruction)new ATHROW());
        mg.addLineNumber(ihThrow, line);
        lvg1.setStart(ihStartOfCatchAll);
        lvg1.setEnd(ihThrow);
        LocalVariableGen lvg2 = mg.addLocalVariable("returnAddress", (Type)Type.THROWABLE, null, null);
        int returnAddressIndex = lvg2.getIndex();
        InstructionHandle ihStoreReturnAddress = iList.append((Instruction)new ASTORE(returnAddressIndex));
        mg.addLineNumber(ihStoreReturnAddress, line);
        generator.generate(cg, mg, iList, cpg);
        InstructionHandle ihReturn = iList.append((Instruction)new RET(returnAddressIndex));
        mg.addLineNumber(ihReturn, line);
        lvg2.setStart(ihStoreReturnAddress);
        lvg2.setEnd(ihReturn);
        InstructionHandle ihStartOfFinally = ihStoreReturnAddress;
        InstructionHandle ihAfterFinally = iList.append(InstructionConstants.NOP);
        mg.addLineNumber(ihAfterFinally, line);
        bhEndOfNormalCodeToFinally.setTarget(ihStartOfFinally);
        bhEndOfNormalCodeToAfterFinally.setTarget(ihAfterFinally);
        bhCatchAllToFinally.setTarget(ihStartOfFinally);
        return new InstructionHandle[]{ihStartOfCatchAll, ihStartOfFinally};
    }

    public static void setTargetOfBranches(List branchHandles, InstructionHandle target) {
        Iterator i = branchHandles.iterator();
        while (i.hasNext()) {
            BranchHandle bh = (BranchHandle)i.next();
            bh.setTarget(target);
        }
    }

    public static void writeClass(ClassGen cg, JavaByteCodeCompiler compiler) throws AdenineException {
        AdenineClassLoaderManager.getInstance().updateClass(cg.getJavaClass().getBytes(), cg.getClassName());
    }

    public static boolean precompileMethod(CodeFrameWithMethodGen methodCodeFrame, List positionalParameters, List namedParameters, List namedParameterURIs, TopLevelVisitor visitor, Location endLocation) {
        if (JavaByteCodeUtilities.insertMemberVariables(methodCodeFrame, visitor) && JavaByteCodeUtilities.insertInitializeParametersMethod(methodCodeFrame, positionalParameters, namedParameters, namedParameterURIs, visitor) && JavaByteCodeUtilities.insertDefaultEnvironmentMappings(methodCodeFrame, visitor)) {
            InstructionList iList = methodCodeFrame.getInstructionList();
            MethodGen mg = methodCodeFrame.getMethodGen();
            int line = endLocation.getTrueLine();
            mg.addLineNumber(iList.append((Instruction)methodCodeFrame.getInstructionFactory().createNew(s_typeMessage)), line);
            mg.addLineNumber(iList.append((Instruction)InstructionConstants.DUP), line);
            mg.addLineNumber(iList.append((Instruction)methodCodeFrame.getInstructionFactory().createInvoke(s_typeMessage.getClassName(), "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183)), line);
            mg.addLineNumber(iList.append((Instruction)new ARETURN()), line);
            methodCodeFrame.getMethodGen().setMaxStack();
            methodCodeFrame.getMethodGen().setMaxLocals();
            methodCodeFrame.getClassGen().addMethod(methodCodeFrame.getMethodGen().getMethod());
            methodCodeFrame.getClassGen().addEmptyConstructor(1);
            return true;
        }
        return false;
    }

    public static boolean insertMemberVariables(CodeFrame methodCodeFrame, TopLevelVisitor visitor) {
        ArrayList names = new ArrayList();
        ArrayList resolvedNames = new ArrayList();
        methodCodeFrame.resolveAllLocalVariables(names, resolvedNames);
        Iterator j = resolvedNames.iterator();
        while (j.hasNext()) {
            String resolvedName = (String)j.next();
            methodCodeFrame.getClassGen().addField(new FieldGen(2, (Type)Type.OBJECT, resolvedName, methodCodeFrame.getConstantPoolGen()).getField());
        }
        return true;
    }

    public static boolean insertInitializeParametersMethod(CodeFrame methodCodeFrame, List positionalParameters, List namedParameters, List namedParameterURIs, TopLevelVisitor visitor) {
        String varName;
        Object o;
        InstructionList iList = new InstructionList();
        MethodGen mg = new MethodGen(4, (Type)Type.VOID, new Type[]{s_typeMessage}, new String[]{"msg"}, "initializeParameters", methodCodeFrame.getClassGen().getClassName(), iList, methodCodeFrame.getConstantPoolGen());
        iList.append((Instruction)new ICONST(0));
        LocalVariableGen lg = mg.addLocalVariable("i", (Type)Type.INT, null, null);
        int iIndex = lg.getIndex();
        iList.append((Instruction)new ISTORE(iIndex));
        iList.append((Instruction)new ALOAD(1));
        iList.append((Instruction)methodCodeFrame.getInstructionFactory().createGetField(s_typeMessage.getClassName(), "m_values", (Type)s_typeObjectArray));
        lg = mg.addLocalVariable("parameters", (Type)s_typeObjectArray, null, null);
        int parametersIndex = lg.getIndex();
        iList.append((Instruction)new ASTORE(parametersIndex));
        Iterator i = positionalParameters.iterator();
        while (i.hasNext()) {
            o = i.next();
            varName = o instanceof GenericToken ? ((GenericToken)o).getContent() : (String)o;
            String resolvedVarName = methodCodeFrame.resolveVariableName(varName);
            if (resolvedVarName != null) {
                iList.append((Instruction)new ILOAD(iIndex));
                iList.append((Instruction)new ALOAD(parametersIndex));
                iList.append((Instruction)new ARRAYLENGTH());
                BranchHandle bh = iList.append((BranchInstruction)new IF_ICMPGE(null));
                iList.append((Instruction)new ALOAD(0));
                iList.append((Instruction)new ALOAD(parametersIndex));
                iList.append((Instruction)new ILOAD(iIndex));
                iList.append((Instruction)new IINC(iIndex, 1));
                iList.append((Instruction)new AALOAD());
                iList.append((Instruction)methodCodeFrame.getInstructionFactory().createPutField(methodCodeFrame.getClassGen().getClassName(), resolvedVarName, (Type)Type.OBJECT));
                bh.setTarget(iList.append((Instruction)new NOP()));
                continue;
            }
            visitor.onException(new AdenineException("Failed to resolve var name " + varName));
            return false;
        }
        if (namedParameters != null && namedParameterURIs != null) {
            i = namedParameters.iterator();
            Iterator j = namedParameterURIs.iterator();
            while (i.hasNext()) {
                o = i.next();
                varName = o instanceof GenericToken ? ((GenericToken)o).getContent() : (String)o;
                String varURI = ((Resource)j.next()).getURI();
                String resolvedVarName = methodCodeFrame.resolveVariableName(varName);
                if (resolvedVarName != null) {
                    iList.append((Instruction)new ALOAD(0));
                    iList.append((Instruction)new ALOAD(1));
                    iList.append((Instruction)methodCodeFrame.getInstructionFactory().createNew(s_typeResource.getClassName()));
                    iList.append((Instruction)InstructionConstants.DUP);
                    iList.append((CompoundInstruction)new PUSH(methodCodeFrame.getConstantPoolGen(), varURI));
                    iList.append((Instruction)methodCodeFrame.getInstructionFactory().createInvoke(s_typeResource.getClassName(), "<init>", (Type)Type.VOID, new Type[]{Type.STRING}, (short)183));
                    iList.append((Instruction)methodCodeFrame.getInstructionFactory().createInvoke(s_typeMessage.getClassName(), "getNamedValue", (Type)Type.OBJECT, new Type[]{s_typeResource}, (short)182));
                    iList.append((Instruction)methodCodeFrame.getInstructionFactory().createPutField(methodCodeFrame.getClassGen().getClassName(), resolvedVarName, (Type)Type.OBJECT));
                    continue;
                }
                visitor.onException(new AdenineException("Failed to resolve var name " + varName));
                return false;
            }
        }
        iList.append((Instruction)new RETURN());
        JavaByteCodeUtilities.setLineNumbersEqualIndices(iList, mg);
        mg.setMaxStack();
        mg.setMaxLocals();
        methodCodeFrame.getClassGen().addMethod(mg.getMethod());
        return true;
    }

    public static boolean insertDefaultEnvironmentMappings(CodeFrame methodCodeFrame, TopLevelVisitor visitor) {
        InstructionList iList = new InstructionList();
        MethodGen mg = new MethodGen(8, (Type)Type.VOID, Type.NO_ARGS, null, "<clinit>", methodCodeFrame.getClassGen().getClassName(), iList, methodCodeFrame.getConstantPoolGen());
        iList.append((Instruction)methodCodeFrame.getInstructionFactory().createGetStatic(s_typeInterpreter.getClassName(), "s_defaultEnvironment", (Type)s_typeEnvironment));
        LocalVariableGen lg = mg.addLocalVariable("defaultEnvironment", (Type)s_typeEnvironment, null, null);
        int defaultEnvironmentIndex = lg.getIndex();
        iList.append((Instruction)new ASTORE(defaultEnvironmentIndex));
        ArrayList names = new ArrayList();
        ArrayList resolvedNames = new ArrayList();
        methodCodeFrame.resolveAllDefaultEnvironmentVariables(names, resolvedNames);
        Iterator i = names.iterator();
        Iterator j = resolvedNames.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            String resolvedName = (String)j.next();
            methodCodeFrame.getClassGen().addField(new FieldGen(10, (Type)Type.OBJECT, resolvedName, methodCodeFrame.getConstantPoolGen()).getField());
            iList.append((Instruction)new ALOAD(defaultEnvironmentIndex));
            iList.append((CompoundInstruction)new PUSH(methodCodeFrame.getConstantPoolGen(), name));
            iList.append((Instruction)methodCodeFrame.getInstructionFactory().createInvoke(s_typeEnvironment.getClassName(), "getValue", (Type)Type.OBJECT, new Type[]{Type.STRING}, (short)182));
            iList.append((Instruction)methodCodeFrame.getInstructionFactory().createPutStatic(methodCodeFrame.getClassGen().getClassName(), resolvedName, (Type)Type.OBJECT));
        }
        iList.append((Instruction)new RETURN());
        JavaByteCodeUtilities.setLineNumbersEqualIndices(iList, mg);
        mg.setMaxStack();
        mg.setMaxLocals();
        methodCodeFrame.getClassGen().addMethod(mg.getMethod());
        return true;
    }

    protected static void setLineNumbersEqualIndices(InstructionList iList, MethodGen mg) {
        int l = 1;
        iList.setPositions();
        Iterator k = iList.iterator();
        while (k.hasNext()) {
            InstructionHandle ih = (InstructionHandle)k.next();
            mg.addLineNumber(ih, l++);
        }
    }
}

