/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.javaByteCode;

import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.CodeFrame;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.ConstructVisitorBase;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.JavaByteCodeUtilities;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.TopLevelVisitor;
import edu.mit.lcs.haystack.adenine.constructs.IImportJavaVisitor;
import edu.mit.lcs.haystack.adenine.tokenizer.GenericToken;
import edu.mit.lcs.haystack.adenine.tokenizer.LiteralToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.Type;

public class ImportJavaVisitor
extends ConstructVisitorBase
implements IImportJavaVisitor {
    public ImportJavaVisitor(TopLevelVisitor visitor, CodeFrame codeFrame) {
        super(visitor, codeFrame);
    }

    public void onClass(GenericToken klass) {
        InstructionList iList = this.m_codeFrame.getInstructionList();
        MethodGen mg = this.m_codeFrame.getMethodGen();
        int line = klass.getSpan().getStart().getTrueLine();
        mg.addLineNumber(iList.append((Instruction)InstructionConstants.DUP), line);
        mg.addLineNumber(iList.append((CompoundInstruction)new PUSH(this.m_codeFrame.getConstantPoolGen(), klass.getContent())), line);
        mg.addLineNumber(iList.append((Instruction)this.m_codeFrame.getInstructionFactory().createInvoke(this.getClass().getName(), "resolveClass", (Type)JavaByteCodeUtilities.s_typeClass, new Type[]{Type.STRING, Type.STRING}, (short)184)), line);
        this.m_codeFrame.generateNewVariablePut(klass.getContent(), iList, this.m_codeFrame.getMethodGen(), line);
    }

    public void onImportJava(GenericToken importjavaKeyword, LiteralToken pakkage) {
        InstructionList iList = this.m_codeFrame.getInstructionList();
        this.m_codeFrame.getMethodGen().addLineNumber(iList.append((CompoundInstruction)new PUSH(this.m_codeFrame.getConstantPoolGen(), pakkage.getContent())), pakkage.getSpan().getStart().getTrueLine());
    }

    public void end(Location endLocation) {
        super.end(endLocation);
        this.m_codeFrame.getMethodGen().addLineNumber(this.m_codeFrame.getInstructionList().append((Instruction)InstructionConstants.POP), endLocation.getTrueLine());
    }

    public static Class resolveClass(String pakkage, String klass) throws AdenineException {
        try {
            return Class.forName(String.valueOf(pakkage) + "." + klass);
        }
        catch (ClassNotFoundException cnfe) {
            throw new AdenineException("importjava specifies unknown class", cnfe);
        }
    }
}

