/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers.javaByteCode;

import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.CodeFrame;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.ConstructVisitorBase;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.ExpressionVisitor;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.JavaByteCodeUtilities;
import edu.mit.lcs.haystack.adenine.compilers.javaByteCode.TopLevelVisitor;
import edu.mit.lcs.haystack.adenine.constructs.ICallVisitor;
import edu.mit.lcs.haystack.adenine.instructions.FunctionCallInstruction;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.Message;
import edu.mit.lcs.haystack.adenine.parser2.IExpressionVisitor;
import edu.mit.lcs.haystack.adenine.tokenizer.GenericToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.adenine.tokenizer.ResourceToken;
import edu.mit.lcs.haystack.adenine.tokenizer.SymbolToken;
import edu.mit.lcs.haystack.rdf.Resource;
import java.util.List;
import java.util.Map;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.Type;

public class CallVisitor
extends ConstructVisitorBase
implements ICallVisitor {
    protected int m_argumentCount = 0;
    protected int m_namedArgumentCount = 0;
    protected int m_resultCount = 0;
    protected boolean m_generatedCall = false;

    public CallVisitor(TopLevelVisitor visitor, CodeFrame codeFrame) {
        super(visitor, codeFrame);
    }

    public void onCall(GenericToken callKeyword) {
    }

    public IExpressionVisitor onCallable(Location location) {
        return new ExpressionVisitor(this.m_topLevelVisitor, this.m_codeFrame);
    }

    public void onComma(SymbolToken commaT) {
    }

    public IExpressionVisitor onArgument(Location location) {
        InstructionList iList = this.m_codeFrame.getInstructionList();
        if (this.m_argumentCount == 0) {
            this.pushArgumentList(location);
        }
        ++this.m_argumentCount;
        this.m_codeFrame.getMethodGen().addLineNumber(iList.append((Instruction)InstructionConstants.DUP), location.getTrueLine());
        return new ExpressionVisitor(this.m_topLevelVisitor, this.m_codeFrame){

            public void end(Location endLocation) {
                CallVisitor.this.onDoneArgument(endLocation);
            }
        };
    }

    public IExpressionVisitor onNamedArgument(ResourceToken name, SymbolToken equalT) {
        InstructionList iList = this.m_codeFrame.getInstructionList();
        MethodGen mg = this.m_codeFrame.getMethodGen();
        Location location = name.getSpan().getStart();
        int line = location.getTrueLine();
        if (this.m_namedArgumentCount == 0) {
            if (this.m_argumentCount == 0) {
                this.pushArgumentList(location);
            }
            this.pushNamedArgumentMap(location);
        }
        ++this.m_namedArgumentCount;
        mg.addLineNumber(iList.append((Instruction)InstructionConstants.DUP), line);
        mg.addLineNumber(iList.append((Instruction)this.m_codeFrame.getInstructionFactory().createNew(JavaByteCodeUtilities.s_typeResource)), line);
        mg.addLineNumber(iList.append((Instruction)InstructionConstants.DUP), line);
        mg.addLineNumber(iList.append((CompoundInstruction)new PUSH(this.m_codeFrame.getConstantPoolGen(), this.m_topLevelVisitor.resolveURI(name).getURI())), line);
        mg.addLineNumber(iList.append((Instruction)this.m_codeFrame.getInstructionFactory().createInvoke(JavaByteCodeUtilities.s_typeResource.getClassName(), "<init>", (Type)Type.VOID, new Type[]{Type.STRING}, (short)183)), line);
        return new ExpressionVisitor(this.m_topLevelVisitor, this.m_codeFrame){

            public void end(Location endLocation) {
                CallVisitor.this.onDoneNamedArgument(endLocation);
            }
        };
    }

    public void onResult(GenericToken variable) {
        if (!this.m_generatedCall) {
            this.generateCall(variable.getSpan().getStart());
        }
        InstructionList iList = this.m_codeFrame.getInstructionList();
        MethodGen mg = this.m_codeFrame.getMethodGen();
        int line = variable.getSpan().getStart().getTrueLine();
        mg.addLineNumber(iList.append((Instruction)InstructionConstants.DUP), line);
        mg.addLineNumber(iList.append((CompoundInstruction)new PUSH(this.m_codeFrame.getConstantPoolGen(), variable.getContent())), line);
        mg.addLineNumber(iList.append((Instruction)InstructionConstants.ALOAD_0), line);
        mg.addLineNumber(iList.append((Instruction)this.m_codeFrame.getInstructionFactory().createGetField(this.m_codeFrame.getClassGen().getClassName(), "__dynamicenvironment__", (Type)JavaByteCodeUtilities.s_typeDynamicEnvironment)), line);
        mg.addLineNumber(iList.append((Instruction)InstructionConstants.ALOAD_0), line);
        mg.addLineNumber(iList.append((Instruction)this.m_codeFrame.getInstructionFactory().createGetField(this.m_codeFrame.getClassGen().getClassName(), "__interpreter__", (Type)JavaByteCodeUtilities.s_typeInterpreter)), line);
        mg.addLineNumber(iList.append((CompoundInstruction)new PUSH(this.m_codeFrame.getConstantPoolGen(), this.m_resultCount++)), line);
        mg.addLineNumber(iList.append((Instruction)this.m_codeFrame.getInstructionFactory().createInvoke(this.getClass().getName(), "setVariable", (Type)Type.VOID, new Type[]{JavaByteCodeUtilities.s_typeMessage, Type.STRING, JavaByteCodeUtilities.s_typeDynamicEnvironment, JavaByteCodeUtilities.s_typeInterpreter, Type.INT}, (short)184)), line);
    }

    public void onNamedResult(ResourceToken name, SymbolToken equalT, GenericToken variable) {
        if (!this.m_generatedCall) {
            this.generateCall(name.getSpan().getStart());
        }
        InstructionList iList = this.m_codeFrame.getInstructionList();
        MethodGen mg = this.m_codeFrame.getMethodGen();
        int line = variable.getSpan().getStart().getTrueLine();
        mg.addLineNumber(iList.append((Instruction)InstructionConstants.DUP), line);
        mg.addLineNumber(iList.append((CompoundInstruction)new PUSH(this.m_codeFrame.getConstantPoolGen(), variable.getContent())), line);
        mg.addLineNumber(iList.append((Instruction)InstructionConstants.ALOAD_0), line);
        mg.addLineNumber(iList.append((Instruction)this.m_codeFrame.getInstructionFactory().createGetField(this.m_codeFrame.getClassGen().getClassName(), "__dynamicenvironment__", (Type)JavaByteCodeUtilities.s_typeDynamicEnvironment)), line);
        mg.addLineNumber(iList.append((Instruction)InstructionConstants.ALOAD_0), line);
        mg.addLineNumber(iList.append((Instruction)this.m_codeFrame.getInstructionFactory().createGetField(this.m_codeFrame.getClassGen().getClassName(), "__interpreter__", (Type)JavaByteCodeUtilities.s_typeInterpreter)), line);
        mg.addLineNumber(iList.append((CompoundInstruction)new PUSH(this.m_codeFrame.getConstantPoolGen(), this.m_topLevelVisitor.resolveURI(name).getURI())), line);
        mg.addLineNumber(iList.append((Instruction)this.m_codeFrame.getInstructionFactory().createInvoke(this.getClass().getName(), "setVariableByURI", (Type)Type.VOID, new Type[]{JavaByteCodeUtilities.s_typeMessage, Type.STRING, JavaByteCodeUtilities.s_typeDynamicEnvironment, JavaByteCodeUtilities.s_typeInterpreter, Type.STRING}, (short)184)), line);
    }

    public void end(Location endLocation) {
        if (!this.m_generatedCall) {
            this.generateCall(endLocation);
        }
        this.m_codeFrame.getMethodGen().addLineNumber(this.m_codeFrame.getInstructionList().append((Instruction)InstructionConstants.POP), endLocation.getTrueLine());
    }

    public void onLeftParenthesis(SymbolToken leftParenthesisT) {
    }

    public void onRightParenthesis(SymbolToken rightParenthesisT) {
    }

    protected void onDoneArgument(Location location) {
        InstructionList iList = this.m_codeFrame.getInstructionList();
        MethodGen mg = this.m_codeFrame.getMethodGen();
        int line = location.getTrueLine();
        mg.addLineNumber(iList.append((Instruction)this.m_codeFrame.getInstructionFactory().createInvoke(JavaByteCodeUtilities.s_typeList.getClassName(), "add", (Type)Type.BOOLEAN, new Type[]{Type.OBJECT}, (short)185)), line);
        mg.addLineNumber(iList.append((Instruction)InstructionConstants.POP), line);
    }

    protected void onDoneNamedArgument(Location location) {
        InstructionList iList = this.m_codeFrame.getInstructionList();
        MethodGen mg = this.m_codeFrame.getMethodGen();
        int line = location.getTrueLine();
        mg.addLineNumber(iList.append((Instruction)this.m_codeFrame.getInstructionFactory().createInvoke(JavaByteCodeUtilities.s_typeMap.getClassName(), "put", (Type)Type.OBJECT, new Type[]{Type.OBJECT, Type.OBJECT}, (short)185)), line);
        mg.addLineNumber(iList.append((Instruction)InstructionConstants.POP), line);
    }

    protected void pushArgumentList(Location location) {
        InstructionList iList = this.m_codeFrame.getInstructionList();
        MethodGen mg = this.m_codeFrame.getMethodGen();
        int line = location.getTrueLine();
        mg.addLineNumber(iList.append((Instruction)this.m_codeFrame.getInstructionFactory().createNew(JavaByteCodeUtilities.s_typeArrayList)), line);
        mg.addLineNumber(iList.append((Instruction)InstructionConstants.DUP), line);
        mg.addLineNumber(iList.append((Instruction)this.m_codeFrame.getInstructionFactory().createInvoke(JavaByteCodeUtilities.s_typeArrayList.getClassName(), "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183)), line);
    }

    protected void pushNamedArgumentMap(Location location) {
        InstructionList iList = this.m_codeFrame.getInstructionList();
        MethodGen mg = this.m_codeFrame.getMethodGen();
        int line = location.getTrueLine();
        mg.addLineNumber(iList.append((Instruction)this.m_codeFrame.getInstructionFactory().createNew(JavaByteCodeUtilities.s_typeHashMap)), line);
        mg.addLineNumber(iList.append((Instruction)InstructionConstants.DUP), line);
        mg.addLineNumber(iList.append((Instruction)this.m_codeFrame.getInstructionFactory().createInvoke(JavaByteCodeUtilities.s_typeHashMap.getClassName(), "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183)), line);
    }

    protected void generateCall(Location location) {
        InstructionList iList = this.m_codeFrame.getInstructionList();
        MethodGen mg = this.m_codeFrame.getMethodGen();
        int line = location.getTrueLine();
        if (this.m_namedArgumentCount == 0) {
            if (this.m_argumentCount == 0) {
                this.pushArgumentList(location);
            }
            this.pushNamedArgumentMap(location);
        }
        mg.addLineNumber(iList.append((Instruction)InstructionConstants.THIS), line);
        mg.addLineNumber(iList.append((Instruction)this.m_codeFrame.getInstructionFactory().createGetField(this.m_codeFrame.getClassGen().getClassName(), "__dynamicenvironment__", (Type)JavaByteCodeUtilities.s_typeDynamicEnvironment)), line);
        mg.addLineNumber(iList.append((Instruction)InstructionConstants.THIS), line);
        mg.addLineNumber(iList.append((Instruction)this.m_codeFrame.getInstructionFactory().createGetField(this.m_codeFrame.getClassGen().getClassName(), "__interpreter__", (Type)JavaByteCodeUtilities.s_typeInterpreter)), line);
        mg.addLineNumber(iList.append((CompoundInstruction)new PUSH(this.m_codeFrame.getConstantPoolGen(), this.m_startLocation.getTrueLine())), line);
        mg.addLineNumber(iList.append((Instruction)this.m_codeFrame.getInstructionFactory().createInvoke(this.getClass().getName(), "doFunctionCall", (Type)JavaByteCodeUtilities.s_typeMessage, new Type[]{Type.OBJECT, JavaByteCodeUtilities.s_typeList, JavaByteCodeUtilities.s_typeMap, JavaByteCodeUtilities.s_typeDynamicEnvironment, JavaByteCodeUtilities.s_typeInterpreter, Type.INT}, (short)184)), line);
        this.m_generatedCall = true;
    }

    public static Message doFunctionCall(Object callable, List arguments, Map namedArguments, DynamicEnvironment dynamicEnvironment, Interpreter interpreter, int line) throws AdenineException {
        return FunctionCallInstruction.doFunctionCall(callable, arguments.toArray(), namedArguments, dynamicEnvironment, interpreter, line);
    }

    public static void setVariable(Message message, String name, DynamicEnvironment dynamicEnvironment, Interpreter interpreter, int index) throws AdenineException {
        if (index < message.m_values.length) {
            dynamicEnvironment.setValue(name, message.m_values[index]);
        } else {
            dynamicEnvironment.setValue(name, null);
        }
    }

    public static void setVariableByURI(Message message, String name, DynamicEnvironment dynamicEnvironment, Interpreter interpreter, String uri) throws AdenineException {
        Resource res = new Resource(uri);
        if (message.m_namedValues != null && res != null && message.m_namedValues.containsKey(res)) {
            dynamicEnvironment.setValue(name, message.m_namedValues.get(res));
        } else {
            dynamicEnvironment.setValue(name, null);
        }
    }
}

