/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compilers;

import edu.mit.lcs.haystack.adenine.compilers.ICompiler;
import edu.mit.lcs.haystack.adenine.compilers.NullMethodVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IConstructVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IParserVisitor;
import edu.mit.lcs.haystack.adenine.parser2.NullConstructVisitor;
import edu.mit.lcs.haystack.adenine.parser2.NullTopLevelVisitor;
import edu.mit.lcs.haystack.adenine.parser2.Parser;
import edu.mit.lcs.haystack.adenine.tokenizer.ErrorToken;
import edu.mit.lcs.haystack.adenine.tokenizer.IScannerVisitor;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.adenine.tokenizer.Token;
import edu.mit.lcs.haystack.content.ContentClient;
import edu.mit.lcs.haystack.proxy.IServiceAccessor;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Resource;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ErrorCheckingCompiler
implements ICompiler {
    public static void main(String[] args) {
        try {
            new ErrorCheckingCompiler().compile(null, new FileReader(args[0]), null, null, null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public List doCompile(Reader input) {
        ArrayList errors = new ArrayList();
        Parser.parse(new IScannerVisitor(){

            public void onToken(Token token) {
                if (token instanceof ErrorToken) {
                    System.err.println("+++ Found error token " + token.getSpan() + ": " + ((ErrorToken)token).getDescription());
                }
            }
        }, new NullTopLevelVisitor(new IParserVisitor(){
            List m_errors;
            int m_count;

            public void start(Location startLocation) {
            }

            public void end(Location endLocation) {
            }

            public void onException(Exception exception) {
                this.m_errors.add(exception);
                if (this.m_count < 5) {
                    System.err.println(exception);
                }
                ++this.m_count;
                throw new NullPointerException();
            }

            public IParserVisitor init(List errors) {
                this.m_errors = errors;
                return this;
            }
        }.init(errors), false){

            public IConstructVisitor onConstruct(String construct) {
                if (construct.equals("method")) {
                    return new NullMethodVisitor(this);
                }
                return new NullConstructVisitor(this.m_visitor);
            }
        }, input);
        return errors;
    }

    public List compile(Resource pakkage, Reader input, String sourceFile, IRDFContainer source, IServiceAccessor sa) {
        if (input == null) {
            String str;
            try {
                str = ContentClient.getContentClient((Resource)pakkage, (IRDFContainer)source, (IServiceAccessor)sa).getContentAsString();
            }
            catch (Exception e) {
                LinkedList<Exception> errors = new LinkedList<Exception>();
                errors.add(e);
                return errors;
            }
            input = new StringReader(str);
        }
        return this.doCompile(input);
    }
}

