/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compiler;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.SyntaxException;
import edu.mit.lcs.haystack.adenine.compiler.Compiler;
import edu.mit.lcs.haystack.adenine.compiler.ExistentialExpression;
import edu.mit.lcs.haystack.adenine.compiler.IInstructionGenerator;
import edu.mit.lcs.haystack.adenine.compiler.ITemplateExpression;
import edu.mit.lcs.haystack.adenine.compiler.LiteralExpression;
import edu.mit.lcs.haystack.adenine.parser.IdentifierToken;
import edu.mit.lcs.haystack.adenine.parser.LiteralToken;
import edu.mit.lcs.haystack.adenine.parser.SemicolonToken;
import edu.mit.lcs.haystack.adenine.parser.Token;
import edu.mit.lcs.haystack.rdf.RDFException;
import java.util.HashMap;
import java.util.ListIterator;

public class ImportJavaGenerator
implements IInstructionGenerator {
    public ExistentialExpression generateInstruction(Compiler compiler, Token token, HashMap prefixes, ListIterator i, ListIterator j) throws RDFException, AdenineException {
        ExistentialExpression res = compiler.generateInstruction(AdenineConstants.ImportJava, token.m_line);
        if (!j.hasNext()) {
            throw new SyntaxException("Expected package name after importjava", token.m_line);
        }
        Token t = (Token)j.next();
        if (!(t instanceof LiteralToken)) {
            throw new SyntaxException("Package name must be a literal", token.m_line);
        }
        res.add(AdenineConstants.PACKAGE, (ITemplateExpression)new LiteralExpression(t.m_token));
        while (j.hasNext()) {
            t = (Token)j.next();
            if (t instanceof SemicolonToken) {
                compiler.processAttributes(res, i, j, token.m_line, prefixes);
                break;
            }
            if (t instanceof IdentifierToken && !compiler.isURIIdentifier(t.m_token)) {
                res.add(AdenineConstants.name, (ITemplateExpression)new LiteralExpression(t.m_token));
                continue;
            }
            throw new SyntaxException("Invalid parameter to importjava", token.m_line);
        }
        return res;
    }
}

