/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compiler;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.SyntaxException;
import edu.mit.lcs.haystack.adenine.compiler.Compiler;
import edu.mit.lcs.haystack.adenine.compiler.ExistentialExpression;
import edu.mit.lcs.haystack.adenine.compiler.IInstructionGenerator;
import edu.mit.lcs.haystack.adenine.compiler.ITemplateExpression;
import edu.mit.lcs.haystack.adenine.compiler.ResourceExpression;
import edu.mit.lcs.haystack.adenine.parser.IdentifierToken;
import edu.mit.lcs.haystack.adenine.parser.SemicolonToken;
import edu.mit.lcs.haystack.adenine.parser.Token;
import edu.mit.lcs.haystack.adenine.parser.URIToken;
import edu.mit.lcs.haystack.rdf.RDFException;
import java.util.HashMap;
import java.util.ListIterator;

public class ImportGenerator
implements IInstructionGenerator {
    public ExistentialExpression generateInstruction(Compiler compiler, Token token, HashMap prefixes, ListIterator i, ListIterator j) throws RDFException, AdenineException {
        ResourceExpression resName;
        ExistentialExpression res = compiler.generateInstruction(AdenineConstants.IMPORT, token.m_line);
        if (!j.hasNext()) {
            throw new SyntaxException("Expected library name after import", token.m_line);
        }
        Token t = (Token)j.next();
        if (t instanceof IdentifierToken) {
            resName = new ResourceExpression(compiler.identifierToResource(t.m_line, t.m_token, prefixes));
        } else if (t instanceof URIToken) {
            resName = new ResourceExpression(t.m_token);
        } else {
            throw new SyntaxException("Token not appropriate in import specification: " + t, t.m_line);
        }
        res.add(AdenineConstants.LIBRARY_, (ITemplateExpression)resName);
        if (j.hasNext()) {
            t = (Token)j.next();
            if (t instanceof SemicolonToken) {
                compiler.processAttributes(res, i, j, token.m_line, prefixes);
            } else {
                throw new SyntaxException("import only takes one parameter", t.m_line);
            }
        }
        return res;
    }
}

