/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.compiler;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.HaystackException;
import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.SyntaxException;
import edu.mit.lcs.haystack.adenine.compiler.AssignmentGenerator;
import edu.mit.lcs.haystack.adenine.compiler.BackQuoteExpression;
import edu.mit.lcs.haystack.adenine.compiler.BreakGenerator;
import edu.mit.lcs.haystack.adenine.compiler.CallGenerator;
import edu.mit.lcs.haystack.adenine.compiler.ContinueGenerator;
import edu.mit.lcs.haystack.adenine.compiler.ExistentialExpression;
import edu.mit.lcs.haystack.adenine.compiler.ForGenerator;
import edu.mit.lcs.haystack.adenine.compiler.FunctionGenerator;
import edu.mit.lcs.haystack.adenine.compiler.IInstructionGenerator;
import edu.mit.lcs.haystack.adenine.compiler.ITemplateExpression;
import edu.mit.lcs.haystack.adenine.compiler.IfGenerator;
import edu.mit.lcs.haystack.adenine.compiler.ImportGenerator;
import edu.mit.lcs.haystack.adenine.compiler.ImportJavaGenerator;
import edu.mit.lcs.haystack.adenine.compiler.LiteralExpression;
import edu.mit.lcs.haystack.adenine.compiler.MethodGenerator;
import edu.mit.lcs.haystack.adenine.compiler.ResourceExpression;
import edu.mit.lcs.haystack.adenine.compiler.ReturnGenerator;
import edu.mit.lcs.haystack.adenine.compiler.VarGenerator;
import edu.mit.lcs.haystack.adenine.compiler.WhileGenerator;
import edu.mit.lcs.haystack.adenine.compiler.WithGenerator;
import edu.mit.lcs.haystack.adenine.compilers.ICompiler;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.parser.BackQuoteToken;
import edu.mit.lcs.haystack.adenine.parser.Block;
import edu.mit.lcs.haystack.adenine.parser.BracedToken;
import edu.mit.lcs.haystack.adenine.parser.DereferencementToken;
import edu.mit.lcs.haystack.adenine.parser.IdentifierToken;
import edu.mit.lcs.haystack.adenine.parser.IndexToken;
import edu.mit.lcs.haystack.adenine.parser.Line;
import edu.mit.lcs.haystack.adenine.parser.LiteralToken;
import edu.mit.lcs.haystack.adenine.parser.ParenthesizedToken;
import edu.mit.lcs.haystack.adenine.parser.Parser;
import edu.mit.lcs.haystack.adenine.parser.SemicolonToken;
import edu.mit.lcs.haystack.adenine.parser.StringToken;
import edu.mit.lcs.haystack.adenine.parser.Token;
import edu.mit.lcs.haystack.adenine.parser.URIToken;
import edu.mit.lcs.haystack.content.ContentClient;
import edu.mit.lcs.haystack.proxy.IServiceAccessor;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Literal;
import edu.mit.lcs.haystack.rdf.LocalRDFContainer;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.URIGenerator;
import edu.mit.lcs.haystack.rdf.Utilities;
import edu.mit.lcs.haystack.server.adenine.AdenineSourceAgent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Category;

public class Compiler
implements ICompiler {
    public IRDFContainer m_target;
    HashMap m_instructionGenerators = new HashMap();
    Resource m_sourceResource;
    boolean m_precompile = false;
    String m_outPath = "";
    Interpreter m_interpreter = null;
    public static final Category s_logCategory;
    LocalRDFContainer m_tempStorage;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Ledu.mit.lcs.haystack.adenine.compiler.Compiler;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logCategory = Category.getInstance((Class)clazz);
    }

    public Compiler(IRDFContainer target) {
        this.m_target = target;
        this.m_instructionGenerators.put("method", new MethodGenerator());
        this.m_instructionGenerators.put("uniqueMethod", new MethodGenerator());
        this.m_instructionGenerators.put("function", new FunctionGenerator());
        this.m_instructionGenerators.put("call", new CallGenerator());
        this.m_instructionGenerators.put("return", new ReturnGenerator());
        this.m_instructionGenerators.put("break", new BreakGenerator());
        this.m_instructionGenerators.put("continue", new ContinueGenerator());
        this.m_instructionGenerators.put("for", new ForGenerator());
        this.m_instructionGenerators.put("if", new IfGenerator());
        this.m_instructionGenerators.put("while", new WhileGenerator());
        this.m_instructionGenerators.put("var", new VarGenerator());
        this.m_instructionGenerators.put("with", new WithGenerator());
        this.m_instructionGenerators.put("import", new ImportGenerator());
        this.m_instructionGenerators.put("importjava", new ImportJavaGenerator());
        this.m_instructionGenerators.put("=", new AssignmentGenerator());
    }

    public Compiler(IRDFContainer target, boolean precompile, File outDir) throws AdenineException, RDFException {
        this(target);
        this.m_outPath = outDir.getAbsolutePath();
        if (precompile) {
            this.m_tempStorage = new LocalRDFContainer();
            this.m_target = this.m_tempStorage;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Ledu.mit.lcs.haystack.adenine.compiler.Compiler;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.compile(null, new InputStreamReader(clazz.getResourceAsStream("/schemata/adenine.ad")), null, null, null);
            this.m_precompile = true;
            this.m_target = target;
        }
    }

    public static void main(String[] args) {
        try {
            LocalRDFContainer rdfc = new LocalRDFContainer();
            new Compiler(rdfc).compile(null, new FileReader(args[0]), null, null, null);
            System.out.println(Utilities.generateN3(rdfc));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void processPrefix(int line, Iterator i, HashMap prefixes) throws AdenineException {
        try {
            IdentifierToken t2 = (IdentifierToken)i.next();
            URIToken t3 = (URIToken)i.next();
            if (t2.m_token.charAt(t2.m_token.length() - 1) != ':') {
                throw new SyntaxException("Prefix must end with :", line);
            }
            prefixes.put(t2.m_token.substring(0, t2.m_token.length() - 1), t3.m_token);
        }
        catch (Exception e) {
            throw new SyntaxException("Invalid @prefix", line);
        }
    }

    public List compile(Resource pakkage, Reader input, String sourceFile, IRDFContainer source, IServiceAccessor sa) {
        String str;
        LinkedList<HaystackException> errors = new LinkedList<HaystackException>();
        if (input == null) {
            this.m_sourceResource = pakkage;
            try {
                str = ContentClient.getContentClient((Resource)pakkage, (IRDFContainer)source, (IServiceAccessor)sa).getContentAsString();
            }
            catch (Exception e) {
                errors.add(new AdenineException("Failed to compile " + input, e));
                return errors;
            }
        }
        BufferedReader reader = new BufferedReader(input);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                pw.println(line);
            }
        }
        catch (IOException ioe) {
            errors.add(new AdenineException("Failed to read Adenine source file", ioe));
            return errors;
        }
        this.m_sourceResource = Utilities.generateUniqueResource();
        try {
            this.m_target.add(new Statement(this.m_sourceResource, Constants.s_content_content, new Literal(sw.getBuffer().toString())));
            this.m_target.add(new Statement(this.m_sourceResource, Constants.s_rdf_type, Constants.s_content_LiteralContent));
        }
        catch (RDFException e) {
            errors.add(e);
            return errors;
        }
        str = sw.getBuffer().toString();
        return this.doCompile(str, errors, pakkage);
    }

    protected List doCompile(String input, List errors, Resource pakkage) {
        try {
            Block b = Parser.blockify(Parser.tokenize(new StringReader(input)));
            HashMap<String, Object> prefixes = new HashMap<String, Object>();
            prefixes.put("random", String.valueOf(Utilities.generateUniqueResource().getURI()) + ":");
            prefixes.put("adenine", "http://haystack.lcs.mit.edu/schemata/adenine#");
            prefixes.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            prefixes.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
            prefixes.put("daml", "http://www.daml.org/2001/03/daml+oil#");
            prefixes.put("xsd", "http://www.w3.org/2001/XMLSchema#");
            prefixes.put("", String.valueOf(Utilities.generateUniqueResource().getURI()) + ":");
            prefixes.put("@urigenerator", new URIGenerator());
            Resource main = this.compileTopLevel(prefixes, b);
            String base = (String)prefixes.get("@base");
            if (base != null) {
                Resource resBase = new Resource(base);
                this.m_target.add(new Statement(resBase, AdenineConstants.compileTime, new Literal(new Date().toString())));
            }
            if (main != null && pakkage != null) {
                this.m_target.add(new Statement(pakkage, AdenineConstants.main, main));
            }
        }
        catch (AdenineException e) {
            errors.add(e);
        }
        catch (RDFException e) {
            errors.add(e);
        }
        return errors;
    }

    public ExistentialExpression compileBlock(Block b, HashMap prefixes) throws AdenineException, RDFException {
        ListIterator k = b.m_items.listIterator();
        ExistentialExpression eeLast = null;
        ExistentialExpression eeFirst = null;
        block0: while (k.hasNext()) {
            Object o = k.next();
            if (o instanceof Block) {
                throw new SyntaxException("Block not valid here", ((Block)o).m_startline);
            }
            Line line = (Line)o;
            ListIterator i = line.m_tokens.listIterator();
            while (i.hasNext()) {
                Token t = (Token)i.next();
                ExistentialExpression ee1 = null;
                boolean breakAfter = false;
                if (t instanceof IdentifierToken) {
                    if (t.m_token.equals("@prefix")) {
                        this.processPrefix(t.m_line, i, prefixes);
                        continue;
                    }
                    IInstructionGenerator ig = (IInstructionGenerator)this.m_instructionGenerators.get(t.m_token);
                    if (ig != null) {
                        ee1 = ig.generateInstruction(this, t, prefixes, k, i);
                    }
                }
                if (ee1 == null) {
                    ee1 = this.compileFunctionCall(t.m_line, line.m_tokens, k, prefixes);
                    breakAfter = true;
                }
                if (eeFirst == null) {
                    eeFirst = ee1;
                }
                if (eeLast != null) {
                    eeLast.add(AdenineConstants.next, ee1);
                }
                eeLast = ee1;
                if (breakAfter) continue block0;
            }
        }
        if (eeFirst == null) {
            return null;
        }
        return eeFirst;
    }

    public ExistentialExpression generateInstruction(Resource type, int line) throws RDFException {
        ExistentialExpression ee = new ExistentialExpression();
        ee.add(Constants.s_rdf_type, type);
        ee.add(AdenineConstants.line, (ITemplateExpression)new LiteralExpression(Integer.toString(line)));
        if (this.m_sourceResource != null) {
            ee.add(AdenineConstants.source, this.m_sourceResource);
        }
        return ee;
    }

    public void processAttributes(ExistentialExpression ee, Iterator i, Iterator k, int line, HashMap prefixes) throws AdenineException, RDFException {
        if (!i.hasNext()) {
            if (!k.hasNext()) {
                throw new SyntaxException("Unexpected end of file processing ;", line);
            }
            Object o = k.next();
            if (o instanceof Line) {
                i = ((Line)o).m_tokens.iterator();
            }
        }
        while (i.hasNext()) {
            ITemplateExpression[] r = this.processPredicateObject(i, prefixes, line);
            ee.add(r[0], r[1]);
            if (!i.hasNext()) continue;
            Token t = (Token)i.next();
            if (!(t instanceof SemicolonToken)) {
                throw new SyntaxException("Semicolon expected", line);
            }
            if (i.hasNext()) continue;
            if (!k.hasNext()) {
                throw new SyntaxException("Unexpected end of file processing ;", line);
            }
            Object o = k.next();
            if (!(o instanceof Line)) continue;
            i = ((Line)o).m_tokens.iterator();
        }
    }

    ExistentialExpression processDollarBrace(int line, Iterator i, HashMap prefixes) throws AdenineException, RDFException {
        ExistentialExpression resSubject = new ExistentialExpression();
        while (i.hasNext()) {
            Token t;
            ITemplateExpression[] a = this.processPredicateObject(i, prefixes, line);
            resSubject.add(a[0], a[1]);
            if (!i.hasNext() || (t = (Token)i.next()) instanceof SemicolonToken) continue;
            throw new SyntaxException("Semicolon expected", line);
        }
        return resSubject;
    }

    ITemplateExpression processObject(Token t3, HashMap prefixes, int line) throws AdenineException, RDFException {
        ITemplateExpression resObject = null;
        if (t3 instanceof IdentifierToken) {
            resObject = new ResourceExpression(this.identifierToResource(t3.m_line, t3.m_token, prefixes));
        } else {
            if (t3 instanceof SemicolonToken) {
                throw new SyntaxException("; cannot be used as object", t3.m_line);
            }
            if (t3 instanceof URIToken) {
                resObject = new ResourceExpression(t3.m_token);
            } else if (t3 instanceof ParenthesizedToken) {
                resObject = this.processList(t3.m_line, ((ParenthesizedToken)t3).m_tokens.iterator(), prefixes);
            } else if (t3 instanceof LiteralToken) {
                resObject = new LiteralExpression(t3.m_token);
            } else if (t3 instanceof BracedToken) {
                BracedToken bt = (BracedToken)t3;
                if (bt.m_percent) {
                    resObject = this.processQuery(bt, prefixes, t3.m_line);
                } else {
                    if (!bt.m_dollar) {
                        throw new SyntaxException("{} cannot be used in this context", t3.m_line);
                    }
                    resObject = this.processDollarBrace(t3.m_line, bt.m_tokens.iterator(), prefixes);
                }
            } else {
                throw new SyntaxException("Invalid token", t3.m_line);
            }
        }
        return resObject;
    }

    ITemplateExpression processList(int line, Iterator i, HashMap prefixes) throws AdenineException, RDFException {
        ExistentialExpression resSubject;
        if (!i.hasNext()) {
            return new ResourceExpression(Constants.s_daml_nil);
        }
        ExistentialExpression resFirst = resSubject = new ExistentialExpression();
        ExistentialExpression resLast = null;
        while (i.hasNext()) {
            ITemplateExpression o = this.processObject((Token)i.next(), prefixes, line);
            if (resLast != null) {
                resLast.add(Constants.s_daml_rest, (ITemplateExpression)resSubject);
            }
            resSubject.add(Constants.s_daml_first, o);
            resLast = resSubject;
            resSubject = new ExistentialExpression();
        }
        resLast.add(Constants.s_daml_rest, Constants.s_daml_nil);
        return resFirst;
    }

    ITemplateExpression processQuery(BracedToken token, HashMap prefixes, int line) throws AdenineException, RDFException {
        ExistentialExpression res = new ExistentialExpression();
        res.add(Constants.s_rdf_type, AdenineConstants.ConditionSet);
        ListIterator i = token.m_tokens.listIterator();
        ArrayList<ITemplateExpression> currentCondition = new ArrayList<ITemplateExpression>();
        ArrayList<ITemplateExpression> conditions = new ArrayList<ITemplateExpression>();
        while (i.hasNext()) {
            Token t1 = (Token)i.next();
            if (t1 instanceof IdentifierToken && t1.m_token.equals(",")) {
                if (currentCondition.isEmpty()) {
                    throw new SyntaxException("Misplaced ,", t1.m_line);
                }
                conditions.add(this.makeList(currentCondition.iterator()));
                currentCondition = new ArrayList();
                continue;
            }
            if (!currentCondition.isEmpty() && (t1 instanceof IdentifierToken || t1 instanceof URIToken || t1 instanceof LiteralToken)) {
                ITemplateExpression o = this.compileToken(t1, prefixes);
                currentCondition.add(o);
                continue;
            }
            i.previous();
            currentCondition.add(this.processObject((Token)i.next(), prefixes, line));
        }
        if (!currentCondition.isEmpty()) {
            conditions.add(this.makeList(currentCondition.iterator()));
            currentCondition = new ArrayList();
        }
        res.add(AdenineConstants.conditions, this.makeList(conditions.iterator()));
        return res;
    }

    ITemplateExpression makeList(Iterator i) throws AdenineException, RDFException {
        ExistentialExpression resSubject;
        if (!i.hasNext()) {
            return new ResourceExpression(Constants.s_daml_nil);
        }
        ExistentialExpression resFirst = resSubject = new ExistentialExpression();
        ExistentialExpression resLast = null;
        while (i.hasNext()) {
            ITemplateExpression o = (ITemplateExpression)i.next();
            if (resLast != null) {
                resLast.add(Constants.s_daml_rest, (ITemplateExpression)resSubject);
            }
            resSubject.add(Constants.s_daml_first, o);
            resLast = resSubject;
            resSubject = new ExistentialExpression();
        }
        resLast.add(Constants.s_daml_rest, Constants.s_daml_nil);
        return resFirst;
    }

    ExistentialExpression compileFunctionCall(int line, ArrayList tokens, Iterator k, HashMap prefixes) throws AdenineException, RDFException {
        ExistentialExpression eeFirst;
        ExistentialExpression ee = this.generateInstruction(AdenineConstants.FunctionCall, line);
        ListIterator i = tokens.listIterator();
        if (!i.hasNext()) {
            throw new SyntaxException("Invalid function call", line);
        }
        ITemplateExpression resFunction = this.compileToken((Token)i.next(), prefixes);
        ee.add(AdenineConstants.function, resFunction);
        ExistentialExpression eeLast = null;
        ExistentialExpression eeNext = eeFirst = new ExistentialExpression();
        while (i.hasNext()) {
            Token t = (Token)i.next();
            if (k != null && t instanceof SemicolonToken) {
                this.processAttributes(ee, i, k, line, prefixes);
                break;
            }
            if (i.hasNext()) {
                Token t2 = (Token)i.next();
                if (t2 instanceof IdentifierToken && t2.m_token.equals("=")) {
                    if (!i.hasNext()) {
                        throw new SyntaxException("Incomplete named parameter", line);
                    }
                    Token t3 = (Token)i.next();
                    ITemplateExpression te1 = this.processObject(t, prefixes, t.m_line);
                    ITemplateExpression te2 = this.compileToken(t3, prefixes);
                    ExistentialExpression eeParam = new ExistentialExpression();
                    eeParam.add(AdenineConstants.parameterName, te1);
                    eeParam.add(AdenineConstants.parameterVariable, te2);
                    ee.add(AdenineConstants.namedParameter, (ITemplateExpression)eeParam);
                    continue;
                }
                i.previous();
            }
            ITemplateExpression ee1 = this.compileToken(t, prefixes);
            eeNext.add(Constants.s_rdf_type, Constants.s_daml_List);
            eeNext.add(Constants.s_daml_first, ee1);
            if (eeLast != null) {
                eeLast.add(Constants.s_daml_rest, (ITemplateExpression)eeNext);
            }
            eeLast = eeNext;
            eeNext = new ExistentialExpression();
        }
        if (eeLast == null) {
            ee.add(AdenineConstants.PARAMETERS, Constants.s_daml_nil);
        } else {
            ee.add(AdenineConstants.PARAMETERS, (ITemplateExpression)eeFirst);
            eeLast.add(Constants.s_daml_rest, Constants.s_daml_nil);
        }
        return ee;
    }

    ExistentialExpression compileList(int line, ArrayList tokens, HashMap prefixes) throws AdenineException, RDFException {
        ExistentialExpression eeFirst;
        ExistentialExpression ee = this.generateInstruction(AdenineConstants.FunctionCall, line);
        ExistentialExpression resFunction = this.compileIdentifier("List", line);
        ee.add(AdenineConstants.function, (ITemplateExpression)resFunction);
        ExistentialExpression eeLast = null;
        ExistentialExpression eeNext = eeFirst = new ExistentialExpression();
        Iterator i = tokens.iterator();
        while (i.hasNext()) {
            Token t = (Token)i.next();
            if (t instanceof SemicolonToken) {
                throw new SyntaxException("; invalid here", line);
            }
            ITemplateExpression ee1 = this.compileToken(t, prefixes);
            eeNext.add(Constants.s_rdf_type, Constants.s_daml_List);
            eeNext.add(Constants.s_daml_first, ee1);
            if (eeLast != null) {
                eeLast.add(Constants.s_daml_rest, (ITemplateExpression)eeNext);
            }
            eeLast = eeNext;
            eeNext = new ExistentialExpression();
        }
        if (eeLast == null) {
            ee.add(AdenineConstants.PARAMETERS, Constants.s_daml_nil);
        } else {
            ee.add(AdenineConstants.PARAMETERS, (ITemplateExpression)eeFirst);
            eeLast.add(Constants.s_daml_rest, Constants.s_daml_nil);
        }
        return ee;
    }

    boolean isURIIdentifier(String str) {
        return str.indexOf(":") != -1 || str.indexOf("?") == 0;
    }

    public Resource identifierToResource(int line, String str, HashMap prefixes) throws AdenineException {
        if (str.length() >= 2 && str.charAt(0) == '?') {
            return new Resource("urn:haystack:wildcard:" + str.substring(1));
        }
        if (str.equals("^")) {
            String s = (String)prefixes.get("@base");
            if (s == null) {
                throw new SyntaxException("Cannot use ^ without declaring a @base", line);
            }
            return new Resource(s);
        }
        int i = str.indexOf(":");
        if (i == -1) {
            throw new SyntaxException("Identifier must be of the form ?name or prefix:name: " + str, line);
        }
        String prefix = str.substring(0, i);
        String base = (String)prefixes.get(prefix);
        if (base == null) {
            throw new SyntaxException("Unknown prefix: " + prefix, line);
        }
        return new Resource(String.valueOf(base) + str.substring(i + 1));
    }

    ITemplateExpression compileObject(Iterator i, HashMap prefixes, int line) throws AdenineException, RDFException {
        if (!i.hasNext()) {
            throw new SyntaxException("Unexpected EOF", line);
        }
        Token t3 = (Token)i.next();
        return this.compileToken(t3, prefixes);
    }

    ITemplateExpression[] compilePredicateObject(Iterator i, HashMap prefixes, int line) throws AdenineException, RDFException {
        if (!i.hasNext()) {
            throw new SyntaxException("Unexpected EOF", line);
        }
        ITemplateExpression resPredicate = null;
        Token t2 = (Token)i.next();
        resPredicate = this.compileToken(t2, prefixes);
        ITemplateExpression[] a = new ITemplateExpression[]{resPredicate, this.compileObject(i, prefixes, line)};
        return a;
    }

    ITemplateExpression[] processPredicateObject(Iterator i, HashMap prefixes, int line) throws AdenineException, RDFException {
        if (!i.hasNext()) {
            throw new SyntaxException("Unexpected EOF", line);
        }
        ITemplateExpression resPredicate = null;
        Token t2 = (Token)i.next();
        if (t2 instanceof IdentifierToken) {
            resPredicate = new ResourceExpression(this.identifierToResource(t2.m_line, t2.m_token, prefixes));
        } else {
            if (t2 instanceof SemicolonToken) {
                throw new SyntaxException("; cannot be used as predicate", t2.m_line);
            }
            if (t2 instanceof URIToken) {
                resPredicate = new ResourceExpression(t2.m_token);
            } else if (t2 instanceof ParenthesizedToken) {
                resPredicate = this.processList(t2.m_line, ((ParenthesizedToken)t2).m_tokens.iterator(), prefixes);
            } else {
                if (t2 instanceof LiteralToken) {
                    throw new SyntaxException("Predicate cannot be literal", t2.m_line);
                }
                if (t2 instanceof BracedToken) {
                    BracedToken bt = (BracedToken)t2;
                    if (!bt.m_dollar) {
                        throw new SyntaxException("{} cannot be used in this context", t2.m_line);
                    }
                    resPredicate = this.processDollarBrace(t2.m_line, bt.m_tokens.iterator(), prefixes);
                } else {
                    throw new SyntaxException("Invalid token", t2.m_line);
                }
            }
        }
        ITemplateExpression[] a = new ITemplateExpression[2];
        a[0] = resPredicate;
        if (!i.hasNext()) {
            throw new SyntaxException("predicate missing object", t2.m_line);
        }
        a[1] = this.processObject((Token)i.next(), prefixes, t2.m_line);
        return a;
    }

    public ITemplateExpression compileToken(Token token, HashMap prefixes) throws AdenineException, RDFException {
        try {
            if (token instanceof URIToken) {
                return this.compileResource(new Resource(token.m_token));
            }
            if (token instanceof IdentifierToken) {
                if (this.isURIIdentifier(token.m_token)) {
                    return this.compileResource(this.identifierToResource(token.m_line, token.m_token, prefixes));
                }
                return this.compileIdentifier(token.m_token, token.m_line);
            }
            if (token instanceof LiteralToken) {
                return this.compileLiteral(token.m_token);
            }
            if (token instanceof StringToken) {
                return this.compileString(token.m_token);
            }
            if (token instanceof ParenthesizedToken) {
                ParenthesizedToken pt = (ParenthesizedToken)token;
                if (pt.m_prefix == '@') {
                    return this.compileList(token.m_line, pt.m_tokens, prefixes);
                }
                return this.compileFunctionCall(token.m_line, pt.m_tokens, null, prefixes);
            }
            if (token instanceof BackQuoteToken) {
                BackQuoteToken bqt = (BackQuoteToken)token;
                BackQuoteExpression bqe = new BackQuoteExpression(this.compileToken(bqt.m_token, prefixes), token.m_line);
                return bqe;
            }
            if (token instanceof IndexToken) {
                IndexToken it = (IndexToken)token;
                ExistentialExpression ee = new ExistentialExpression();
                ee.add(Constants.s_rdf_type, AdenineConstants.Index);
                ee.add(AdenineConstants.base, this.compileToken(it.m_base, prefixes));
                ee.add(AdenineConstants.index, this.compileToken(it.m_index, prefixes));
                return ee;
            }
            if (token instanceof DereferencementToken) {
                DereferencementToken it = (DereferencementToken)token;
                ExistentialExpression ee = new ExistentialExpression();
                ee.add(Constants.s_rdf_type, AdenineConstants.Dereferencement);
                ee.add(AdenineConstants.base, this.compileToken(it.m_base, prefixes));
                ee.add(AdenineConstants.member, this.compileToken(it.m_member, prefixes));
                return ee;
            }
            if (token instanceof BracedToken) {
                BracedToken bt = (BracedToken)token;
                if (bt.m_dollar) {
                    return this.compileDollarBrace(token.m_line, bt.m_tokens.iterator(), prefixes);
                }
                if (bt.m_percent) {
                    return this.compileQuery(bt, prefixes, token.m_line);
                }
                return this.compileModel(bt, prefixes, token.m_line);
            }
            throw new SyntaxException("Unexpected token: " + token, token == null ? -1 : token.m_line);
        }
        catch (AdenineException ae) {
            if (ae.m_line == -1 && token != null) {
                ae.m_line = token.m_line;
            }
            throw ae;
        }
    }

    public ExistentialExpression compileIdentifier(String str, int line) throws RDFException {
        ExistentialExpression ee = this.generateInstruction(AdenineConstants.Identifier, line);
        ee.add(AdenineConstants.name, (ITemplateExpression)new LiteralExpression(str));
        return ee;
    }

    ExistentialExpression compileLiteral(String str) {
        ExistentialExpression ee = new ExistentialExpression();
        ee.add(Constants.s_rdf_type, AdenineConstants.Literal);
        ee.add(AdenineConstants.literal, (ITemplateExpression)new LiteralExpression(str));
        return ee;
    }

    ExistentialExpression compileString(String str) {
        ExistentialExpression ee = new ExistentialExpression();
        ee.add(Constants.s_rdf_type, AdenineConstants.String);
        ee.add(AdenineConstants.string, (ITemplateExpression)new LiteralExpression(str));
        return ee;
    }

    ExistentialExpression compileResource(Resource res) {
        ExistentialExpression ee = new ExistentialExpression();
        ee.add(Constants.s_rdf_type, AdenineConstants.Resource);
        ee.add(AdenineConstants.resource, res);
        return ee;
    }

    ExistentialExpression compileStatement(ITemplateExpression subject, ITemplateExpression predicate, ITemplateExpression object) throws AdenineException, RDFException {
        ExistentialExpression ee = new ExistentialExpression();
        ee.add(Constants.s_rdf_type, AdenineConstants.Statement);
        if (subject != null) {
            ee.add(AdenineConstants.subject, subject);
        }
        ee.add(AdenineConstants.predicate, predicate);
        ee.add(AdenineConstants.object, object);
        return ee;
    }

    ExistentialExpression compileDollarBrace(int line, Iterator i, HashMap prefixes) throws AdenineException, RDFException {
        ExistentialExpression ee = this.generateInstruction(AdenineConstants.BNode, line);
        while (i.hasNext()) {
            Token t;
            ITemplateExpression[] a = this.compilePredicateObject(i, prefixes, line);
            ExistentialExpression r = this.compileStatement(null, a[0], a[1]);
            ee.add(AdenineConstants.statement, (ITemplateExpression)r);
            if (!i.hasNext() || (t = (Token)i.next()) instanceof SemicolonToken) continue;
            throw new SyntaxException("Semicolon expected", line);
        }
        return ee;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ITemplateExpression compileModel(BracedToken token, HashMap prefixes, int line) throws AdenineException, RDFException {
        ExistentialExpression res = this.generateInstruction(AdenineConstants.Model, line);
        ITemplateExpression lastRes = null;
        Iterator i = token.m_tokens.iterator();
        while (i.hasNext()) {
            ITemplateExpression resSubject = null;
            Token t1 = (Token)i.next();
            if (t1 instanceof SemicolonToken) {
                if (lastRes == null) throw new SyntaxException("Misplaced ;", t1.m_line);
                resSubject = lastRes;
            } else {
                resSubject = this.compileToken(t1, prefixes);
            }
            lastRes = resSubject;
            if (!i.hasNext()) {
                s_logCategory.warn((Object)("Extraneous semicolon on line " + line));
                return res;
            }
            ITemplateExpression[] rest = this.compilePredicateObject(i, prefixes, line);
            ExistentialExpression resStatement = this.compileStatement(resSubject, rest[0], rest[1]);
            res.add(AdenineConstants.statement, (ITemplateExpression)resStatement);
        }
        return res;
    }

    ITemplateExpression compileQuery(BracedToken token, HashMap prefixes, int line) throws AdenineException, RDFException {
        ExistentialExpression res = this.generateInstruction(AdenineConstants.Query, line);
        Iterator i = token.m_tokens.iterator();
        ArrayList<ITemplateExpression> currentCondition = new ArrayList<ITemplateExpression>();
        ArrayList<ITemplateExpression> conditions = new ArrayList<ITemplateExpression>();
        while (i.hasNext()) {
            Token t1 = (Token)i.next();
            if (t1 instanceof IdentifierToken && t1.m_token.equals(",")) {
                if (currentCondition.isEmpty()) {
                    throw new SyntaxException("Misplaced ,", t1.m_line);
                }
                conditions.add(this.makeList(currentCondition.iterator()));
                currentCondition = new ArrayList();
                continue;
            }
            currentCondition.add(this.compileToken(t1, prefixes));
        }
        if (!currentCondition.isEmpty()) {
            conditions.add(this.makeList(currentCondition.iterator()));
            currentCondition = new ArrayList();
        }
        res.add(AdenineConstants.queryConditions, this.makeList(conditions.iterator()));
        return res;
    }

    void compileMethod(int line, ListIterator i, Iterator k, HashMap prefixes, HashMap precompiledMethodData) throws AdenineException, RDFException {
        Resource resFirst;
        Resource resName;
        IRDFContainer source;
        LocalRDFContainer precompileStorage = null;
        if (this.m_precompile) {
            precompileStorage = new LocalRDFContainer();
            source = precompileStorage;
        } else {
            source = this.m_target;
        }
        Token t = (Token)i.next();
        if (t instanceof IdentifierToken) {
            resName = this.identifierToResource(line, t.m_token, prefixes);
        } else if (t instanceof URIToken) {
            resName = new Resource(t.m_token);
        } else {
            throw new SyntaxException("Token not appropriate in service name specification: " + t, line);
        }
        source.add(new Statement(resName, Constants.s_rdf_type, AdenineConstants.Method));
        String base = (String)prefixes.get("@base");
        if (base != null) {
            Resource resBase = new Resource(base);
            this.m_target.add(new Statement(resName, Constants.s_rdfs_isDefinedBy, resBase));
        }
        this.m_target.add(new Statement(resName, AdenineConstants.compileTime, new Literal(new Date().toString())));
        Resource resLast = null;
        Resource resNew = resFirst = ((URIGenerator)prefixes.get("@urigenerator")).generateAnonymousResource();
        while (i.hasNext()) {
            t = (Token)i.next();
            if (t instanceof SemicolonToken) {
                ExistentialExpression ee = new ExistentialExpression(resName);
                this.processAttributes(ee, i, k, line, prefixes);
                ee.generate((URIGenerator)prefixes.get("@urigenerator"), this.m_target);
                break;
            }
            if (t instanceof IdentifierToken) {
                if (i.hasNext()) {
                    Token t2 = (Token)i.next();
                    if (t2 instanceof IdentifierToken && t2.m_token.equals("=")) {
                        if (!i.hasNext()) {
                            throw new SyntaxException("Incomplete named parameter", line);
                        }
                        Token t3 = (Token)i.next();
                        ITemplateExpression te1 = this.processObject(t, prefixes, t.m_line);
                        ITemplateExpression te2 = this.compileToken(t3, prefixes);
                        ExistentialExpression eeParam = new ExistentialExpression();
                        eeParam.add(AdenineConstants.parameterName, te1);
                        eeParam.add(AdenineConstants.parameterVariable, te2);
                        source.add(new Statement(resName, AdenineConstants.namedParameter, eeParam.generate((URIGenerator)prefixes.get("@urigenerator"), source)));
                        continue;
                    }
                    i.previous();
                }
                if (this.isURIIdentifier(t.m_token)) {
                    throw new SyntaxException("Parameter identifier cannot be a URI", line);
                }
                ExistentialExpression resIdent = this.compileIdentifier(t.m_token, t.m_line);
                source.add(new Statement(resNew, Constants.s_rdf_type, Constants.s_daml_List));
                source.add(new Statement(resNew, Constants.s_daml_first, resIdent.generate((URIGenerator)prefixes.get("@urigenerator"), source)));
                if (resLast != null) {
                    source.add(new Statement(resLast, Constants.s_daml_rest, resNew));
                }
                resLast = resNew;
                resNew = ((URIGenerator)prefixes.get("@urigenerator")).generateAnonymousResource();
                continue;
            }
            throw new SyntaxException("Token not appropriate in method specification: " + t, line);
        }
        if (resLast == null) {
            source.add(new Statement(resName, AdenineConstants.PARAMETERS, Constants.s_daml_nil));
        } else {
            source.add(new Statement(resName, AdenineConstants.PARAMETERS, resFirst));
            source.add(new Statement(resLast, Constants.s_daml_rest, Constants.s_daml_nil));
        }
        if (!k.hasNext()) {
            throw new SyntaxException("Expected method body", line + 1);
        }
        Object o = k.next();
        if (!(o instanceof Block)) {
            throw new SyntaxException("Expected method body", line + 1);
        }
        if (this.m_precompile) {
            this.m_target.add(precompileStorage);
        }
        ExistentialExpression resBlock = this.compileBlock((Block)o, prefixes);
        source.add(new Statement(resName, AdenineConstants.start, resBlock.generate((URIGenerator)prefixes.get("@urigenerator"), source)));
        if (this.m_precompile) {
            precompiledMethodData.put(resName, source);
        }
    }

    void compileLibrary(int line, Iterator i, Iterator k, HashMap prefixes) throws AdenineException, RDFException {
        Resource resName;
        IRDFContainer source = this.m_target;
        Token t = (Token)i.next();
        if (t instanceof IdentifierToken) {
            resName = this.identifierToResource(line, t.m_token, prefixes);
        } else if (t instanceof URIToken) {
            resName = new Resource(t.m_token);
        } else {
            throw new SyntaxException("Token not appropriate in library name specification: " + t, line);
        }
        source.add(new Statement(resName, Constants.s_rdf_type, AdenineConstants.LIBRARY));
        Object o = k.next();
        if (!(o instanceof Block)) {
            throw new SyntaxException("Expected library body", line + 1);
        }
        ExistentialExpression resBlock = this.compileBlock((Block)o, prefixes);
        source.add(new Statement(resName, AdenineConstants.start, resBlock.generate((URIGenerator)prefixes.get("@urigenerator"), source)));
    }

    Resource compileMain(int line, Iterator i, Iterator k, HashMap prefixes) throws AdenineException, RDFException {
        Resource resFirst;
        IRDFContainer source = this.m_target;
        Resource resName = ((URIGenerator)prefixes.get("@urigenerator")).generateAnonymousResource();
        Resource resLast = null;
        Resource resNew = resFirst = ((URIGenerator)prefixes.get("@urigenerator")).generateAnonymousResource();
        while (i.hasNext()) {
            Token t = (Token)i.next();
            if (t instanceof SemicolonToken) {
                ExistentialExpression ee = new ExistentialExpression(resName);
                this.processAttributes(ee, i, k, line, prefixes);
                ee.generate((URIGenerator)prefixes.get("@urigenerator"), this.m_target);
                break;
            }
            if (t instanceof IdentifierToken) {
                if (this.isURIIdentifier(t.m_token)) {
                    throw new SyntaxException("Parameter identifier cannot be a URI", line);
                }
                ExistentialExpression resIdent = this.compileIdentifier(t.m_token, t.m_line);
                source.add(new Statement(resNew, Constants.s_rdf_type, Constants.s_daml_List));
                source.add(new Statement(resNew, Constants.s_daml_first, resIdent.generate((URIGenerator)prefixes.get("@urigenerator"), source)));
                if (resLast != null) {
                    source.add(new Statement(resLast, Constants.s_daml_rest, resNew));
                }
                resLast = resNew;
                resNew = ((URIGenerator)prefixes.get("@urigenerator")).generateAnonymousResource();
                continue;
            }
            throw new SyntaxException("Token not appropriate in main method specification: " + t, line);
        }
        if (resLast == null) {
            source.add(new Statement(resName, AdenineConstants.PARAMETERS, Constants.s_daml_nil));
        } else {
            source.add(new Statement(resName, AdenineConstants.PARAMETERS, resFirst));
            source.add(new Statement(resLast, Constants.s_daml_rest, Constants.s_daml_nil));
        }
        Object o = k.next();
        if (!(o instanceof Block)) {
            throw new SyntaxException("Expected main body", line + 1);
        }
        ExistentialExpression resBlock = this.compileBlock((Block)o, prefixes);
        source.add(new Statement(resName, AdenineConstants.start, resBlock.generate((URIGenerator)prefixes.get("@urigenerator"), source)));
        return resName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Resource compileTopLevel(HashMap prefixes, Block b) throws AdenineException, RDFException {
        HashMap precompiledMethodData = new HashMap();
        IRDFContainer source = this.m_target;
        Iterator k = b.m_items.iterator();
        Resource lastRes = null;
        Resource mainRes = null;
        block0: while (k.hasNext()) {
            Object o = k.next();
            if (o instanceof Block) {
                throw new SyntaxException("Block not valid here", ((Block)o).m_startline);
            }
            Line line = (Line)o;
            ListIterator i = line.m_tokens.listIterator();
            while (i.hasNext()) {
                Resource resSubject = null;
                Token t1 = (Token)i.next();
                if (t1 instanceof IdentifierToken) {
                    if (t1.m_token.equals("method")) {
                        this.compileMethod(t1.m_line, i, k, prefixes, precompiledMethodData);
                        lastRes = null;
                        continue block0;
                    }
                    if (t1.m_token.equals("library")) {
                        this.compileLibrary(t1.m_line, i, k, prefixes);
                        lastRes = null;
                        continue block0;
                    }
                    if (t1.m_token.equals("add")) {
                        Token t2 = (Token)i.next();
                        if (!(t2 instanceof BracedToken)) {
                            throw new SyntaxException("add requires a model parameter", t1.m_line);
                        }
                        this.compileAdd(((BracedToken)t2).m_tokens.iterator(), prefixes);
                        lastRes = null;
                        continue block0;
                    }
                    if (t1.m_token.equals("main")) {
                        if (mainRes != null) {
                            throw new SyntaxException("main service already defined", t1.m_line);
                        }
                        mainRes = this.compileMain(t1.m_line, i, k, prefixes);
                        lastRes = null;
                        continue block0;
                    }
                    if (t1.m_token.equals("@base")) {
                        URIToken t3 = (URIToken)i.next();
                        prefixes.put("@base", t3.m_token);
                        prefixes.put("", String.valueOf(t3.m_token) + ":");
                        prefixes.put("@urigenerator", new URIGenerator(t3.m_token));
                        lastRes = null;
                        continue;
                    }
                    if (t1.m_token.equals("@prefix")) {
                        this.processPrefix(t1.m_line, i, prefixes);
                        lastRes = null;
                        continue;
                    }
                    resSubject = this.identifierToResource(t1.m_line, t1.m_token, prefixes);
                } else if (t1 instanceof SemicolonToken) {
                    if (lastRes == null) throw new SyntaxException("Misplaced ;", t1.m_line);
                    resSubject = lastRes;
                } else if (t1 instanceof URIToken) {
                    resSubject = new Resource(t1.m_token);
                } else if (t1 instanceof ParenthesizedToken) {
                    resSubject = (Resource)this.processList(t1.m_line, ((ParenthesizedToken)t1).m_tokens.iterator(), prefixes).generate((URIGenerator)prefixes.get("@urigenerator"), source);
                } else {
                    if (t1 instanceof LiteralToken) {
                        throw new SyntaxException("Subject cannot be literal", t1.m_line);
                    }
                    if (!(t1 instanceof BracedToken)) throw new SyntaxException("Invalid token", t1.m_line);
                    BracedToken bt = (BracedToken)t1;
                    if (!bt.m_dollar) {
                        throw new SyntaxException("{} cannot be used in this context", t1.m_line);
                    }
                    resSubject = (Resource)this.processDollarBrace(t1.m_line, bt.m_tokens.iterator(), prefixes).generate((URIGenerator)prefixes.get("@urigenerator"), source);
                }
                lastRes = resSubject;
                if (!i.hasNext()) {
                    s_logCategory.warn((Object)("Extraneous semicolon on line " + line));
                    continue block0;
                }
                ITemplateExpression[] rest = this.processPredicateObject(i, prefixes, line.m_lineno);
                source.add(new Statement(resSubject, (Resource)rest[0].generate((URIGenerator)prefixes.get("@urigenerator"), source), rest[1].generate((URIGenerator)prefixes.get("@urigenerator"), source)));
            }
        }
        if (!this.m_precompile) return mainRes;
        Iterator j = precompiledMethodData.keySet().iterator();
        ArrayList methodsToCompile = new ArrayList();
        LocalRDFContainer tempStorage = new LocalRDFContainer();
        tempStorage.add(this.m_tempStorage);
        while (j.hasNext()) {
            Object key = j.next();
            methodsToCompile.add(key);
            tempStorage.add((IRDFContainer)precompiledMethodData.get(key));
        }
        this.m_interpreter = new Interpreter(tempStorage);
        Collection successfulMethods = this.m_interpreter.compileMethodsToJava(methodsToCompile, this.m_outPath);
        j = precompiledMethodData.keySet().iterator();
        while (j.hasNext()) {
            Resource resName = (Resource)j.next();
            if (successfulMethods.contains(resName)) {
                this.m_target.add(new Statement(resName, Constants.s_haystack_JavaClass, tempStorage.extract(resName, Constants.s_haystack_JavaClass, null)));
                this.m_target.add(new Statement(resName, AdenineConstants.precompile, new Literal("true")));
                this.m_target.add(new Statement(resName, AdenineConstants.preload, new Literal("true")));
                s_logCategory.info((Object)(resName + " precompiled"));
            } else {
                this.m_target.add((IRDFContainer)precompiledMethodData.get(resName));
                s_logCategory.info((Object)(resName + " could not be precompiled"));
            }
            this.m_target.add(new Statement(resName, AdenineSourceAgent.PRECOMPILE_TIME, new Literal(new Date().toString())));
        }
        return mainRes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void compileAdd(Iterator i, HashMap prefixes) throws AdenineException, RDFException {
        IRDFContainer source = this.m_target;
        Resource lastRes = null;
        while (i.hasNext()) {
            Resource resSubject = null;
            Token t1 = (Token)i.next();
            if (t1 instanceof IdentifierToken) {
                resSubject = this.identifierToResource(t1.m_line, t1.m_token, prefixes);
            } else if (t1 instanceof SemicolonToken) {
                if (lastRes == null) throw new SyntaxException("Misplaced ;", t1.m_line);
                resSubject = lastRes;
            } else if (t1 instanceof URIToken) {
                resSubject = new Resource(t1.m_token);
            } else if (t1 instanceof ParenthesizedToken) {
                resSubject = (Resource)this.processList(t1.m_line, ((ParenthesizedToken)t1).m_tokens.iterator(), prefixes).generate((URIGenerator)prefixes.get("@urigenerator"), source);
            } else {
                if (t1 instanceof LiteralToken) {
                    throw new SyntaxException("Subject cannot be literal", t1.m_line);
                }
                if (!(t1 instanceof BracedToken)) throw new SyntaxException("Invalid token", t1.m_line);
                BracedToken bt = (BracedToken)t1;
                if (!bt.m_dollar) {
                    throw new SyntaxException("{} cannot be used in this context", t1.m_line);
                }
                resSubject = (Resource)this.processDollarBrace(t1.m_line, bt.m_tokens.iterator(), prefixes).generate((URIGenerator)prefixes.get("@urigenerator"), source);
            }
            lastRes = resSubject;
            if (!i.hasNext()) {
                s_logCategory.warn((Object)("Extraneous semicolon on line " + t1.m_line));
                return;
            }
            ITemplateExpression[] rest = this.processPredicateObject(i, prefixes, t1.m_line);
            source.add(new Statement(resSubject, (Resource)rest[0].generate((URIGenerator)prefixes.get("@urigenerator"), source), rest[1].generate((URIGenerator)prefixes.get("@urigenerator"), source)));
        }
    }
}

