/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.compilers.rdfCode.RDFCodeCompiler;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.ICallable;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.Message;
import edu.mit.lcs.haystack.proxy.IServiceAccessor;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.LocalRDFContainer;
import edu.mit.lcs.haystack.rdf.Resource;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;

public class Console {
    HashMap prefixes;
    Environment env;
    Interpreter in;
    DynamicEnvironment denv;
    String m_lastCommand = "";
    private static final String font = Constants.isWindows ? "Tahoma" : "Sans";
    public static final String s_prompt = "\nadenine> ";
    public static final String s_inputPrompt = "\ninput> ";
    String m_prompt = "\nadenine> ";
    boolean m_inInput = false;
    String m_input;
    static /* synthetic */ Class class$0;

    public Console(IRDFContainer rdfc) {
        this.in = new Interpreter(rdfc);
        this.env = this.in.createInitialEnvironment();
        this.denv = new DynamicEnvironment(rdfc, null);
        this.denv.setInstructionSource(rdfc);
        this.env.setValue("quit", new ICallable(){

            public Message invoke(Message message, DynamicEnvironment denv) throws AdenineException {
                throw new QuitException();
            }
        });
        this.prefixes = new HashMap();
        this.prefixes.put("adenine", "http://haystack.lcs.mit.edu/schemata/adenine#");
        this.prefixes.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.prefixes.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.prefixes.put("daml", "http://www.daml.org/2001/03/daml+oil#");
        this.prefixes.put("xsd", "http://www.w3.org/2001/XMLSchema#");
        this.prefixes.put("dc", "http://purl.org/dc/elements/1.1/");
        this.prefixes.put("hs", "http://haystack.lcs.mit.edu/schemata/haystack#");
        this.prefixes.put("xenon", "http://haystack.lcs.mit.edu/schemata/xenon#");
        this.prefixes.put("config", "http://haystack.lcs.mit.edu/schemata/config#");
        this.prefixes.put("mail", "http://haystack.lcs.mit.edu/schemata/mail#");
        this.prefixes.put("content", "http://haystack.lcs.mit.edu/schemata/content#");
        this.prefixes.put("ozone", "http://haystack.lcs.mit.edu/schemata/ozone#");
        this.prefixes.put("slide", "http://haystack.lcs.mit.edu/schemata/ozoneslide#");
        this.prefixes.put("source", "http://haystack.lcs.mit.edu/agents/adenine#");
        this.prefixes.put("op", "http://haystack.lcs.mit.edu/schemata/operation#");
        this.prefixes.put("opui", "http://haystack.lcs.mit.edu/ui/operation#");
        this.env.setValue("compile", new Compile());
        this.env.setValue("help", new Help());
        System.out.print("Haystack Adenine Console\nVersion 1.0\nCopyright (c) Massachusetts Institute of Technology, 2001-2002.\n");
    }

    public void setServiceAccessor(IServiceAccessor sa) {
        this.denv.setServiceAccessor(sa);
    }

    public void setEnvironmentValue(String name, Object o) {
        this.env.setValue(name, o);
    }

    public void setDynamicEnvironmentValue(String name, Object o) {
        this.denv.setValue(name, o);
    }

    public void setEnvironment(Environment env) {
        this.env = env;
    }

    public void setDynamicEnvironment(DynamicEnvironment denv) {
        this.denv = denv;
    }

    public void run() {
        PrintWriter oldWriter = this.denv.getOutput();
        BufferedReader oldReader = this.denv.getInput();
        while (true) {
            try {
                System.out.print(this.m_prompt);
                String str = oldReader.readLine();
                Object o = this.in.eval(str, this.prefixes, this.env, this.denv);
                System.out.print("Result: ");
                System.out.println(o == null ? "null" : o.toString());
                continue;
            }
            catch (QuitException qe) {
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        try {
            LocalRDFContainer rdfc = new LocalRDFContainer();
            RDFCodeCompiler compiler = new RDFCodeCompiler(rdfc);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Ledu.mit.lcs.haystack.adenine.interpreter.Interpreter;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            compiler.compile(null, new InputStreamReader(clazz.getResourceAsStream("/schemata/adenine.ad")), "/schemata/adenine.ad", null, null);
            new Console(rdfc).run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class QuitException
    extends AdenineException {
        public QuitException() {
            super("");
        }
    }

    class Help
    implements ICallable {
        static /* synthetic */ Class class$0;

        Help() {
        }

        /*
         * Unable to fully structure code
         */
        public Message invoke(Message message, DynamicEnvironment denv) throws AdenineException {
            sb = new StringBuffer();
            methods = message.m_values[0].getClass().getMethods();
            if (methods.length > 0) {
                sb.append("Methods:\n");
                i = 0;
                while (i < methods.length) {
                    block11: {
                        m = methods[i];
                        try {
                            v0 = Help.class$0;
                            if (v0 == null) {
                                try {
                                    v0 = Class.forName("[Ljava.lang.Object;").getComponentType();
                                }
                                catch (ClassNotFoundException v1) {
                                    throw new NoClassDefFoundError(v1.getMessage());
                                }
                            }
                            v0.getMethod(m.getName(), m.getParameterTypes());
                            break block11;
                        }
                        catch (Exception e) {
                            sb.append(String.valueOf(m.getReturnType().getName()) + " " + m.getName() + "(");
                            params = m.getParameterTypes();
                            j = 0;
                            ** while (j < params.length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            sb.append(params[j].getName());
                            if (j != params.length - 1) {
                                sb.append(", ");
                            }
                            ++j;
                            continue;
                        }
lbl33:
                        // 1 sources

                        sb.append(")\n");
                    }
                    ++i;
                }
            }
            if ((fields = message.m_values[0].getClass().getFields()).length > 0) {
                sb.append("Fields:\n");
                i = 0;
                while (i < fields.length) {
                    f = fields[i];
                    sb.append(f.getType());
                    sb.append(" ");
                    sb.append(f.getName());
                    sb.append("\n");
                    ++i;
                }
                sb.append("\n");
            }
            System.out.print(sb.toString());
            return new Message();
        }
    }

    class Compile
    implements ICallable {
        Compile() {
        }

        public Message invoke(Message message, DynamicEnvironment denv) throws AdenineException {
            try {
                Console.this.in.compileMethodToJava((Resource)message.m_values[0], (String)message.m_values[1]);
                return new Message();
            }
            catch (Exception e) {
                e.printStackTrace();
                return new Message();
            }
        }
    }
}

