/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine;

import java.io.StringReader;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class AdenineLineStyler
implements LineStyleListener {
    AdenineScanner scanner = new AdenineScanner();
    int[] tokenColors;
    Color[] colors;
    Vector blockComments = new Vector();
    public static final int EOF = -1;
    public static final int EOL = 10;
    public static final int WORD = 0;
    public static final int WHITE = 1;
    public static final int KEY = 2;
    public static final int COMMENT = 3;
    public static final int STRING = 5;
    public static final int OTHER = 6;
    public static final int NUMBER = 7;
    public static final int URI = 8;
    public static final int MAXIMUM_TOKEN = 9;

    public AdenineLineStyler() {
        this.initializeColors();
        this.scanner = new AdenineScanner();
    }

    Color getColor(int type) {
        if (type < 0 || type >= this.tokenColors.length) {
            return null;
        }
        return this.colors[this.tokenColors[type]];
    }

    boolean inBlockComment(int start, int end) {
        int i = 0;
        while (i < this.blockComments.size()) {
            int[] offsets = (int[])this.blockComments.elementAt(i);
            if (offsets[0] >= start && offsets[0] <= end) {
                return true;
            }
            if (offsets[1] >= start && offsets[1] <= end) {
                return true;
            }
            if (offsets[0] <= start && offsets[1] >= end) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void initializeColors() {
        Display display = Display.getDefault();
        this.colors = new Color[]{new Color((Device)display, new RGB(0, 0, 0)), new Color((Device)display, new RGB(255, 0, 0)), new Color((Device)display, new RGB(0, 127, 0)), new Color((Device)display, new RGB(0, 0, 255))};
        this.tokenColors = new int[9];
        this.tokenColors[0] = 0;
        this.tokenColors[1] = 0;
        this.tokenColors[2] = 3;
        this.tokenColors[3] = 1;
        this.tokenColors[5] = 2;
        this.tokenColors[6] = 0;
        this.tokenColors[7] = 0;
        this.tokenColors[8] = 1;
    }

    void disposeColors() {
        int i = 0;
        while (i < this.colors.length) {
            this.colors[i].dispose();
            ++i;
        }
    }

    public void lineGetStyle(LineStyleEvent event) {
        Vector<StyleRange> styles = new Vector<StyleRange>();
        if (this.inBlockComment(event.lineOffset, event.lineOffset + event.lineText.length())) {
            styles.addElement(new StyleRange(event.lineOffset, event.lineText.length(), this.getColor(3), null));
            event.styles = new StyleRange[styles.size()];
            styles.copyInto(event.styles);
            return;
        }
        Color defaultFgColor = ((Control)event.widget).getForeground();
        this.scanner.setRange(event.lineText);
        int token = this.scanner.nextToken();
        while (token != -1) {
            if (token != 6) {
                StyleRange lastStyle;
                if (token != 1) {
                    Color color = this.getColor(token);
                    if (!color.equals((Object)defaultFgColor) || token == 2) {
                        StyleRange style = new StyleRange(this.scanner.getStartOffset() + event.lineOffset, this.scanner.getLength(), color, null);
                        if (token == 2) {
                            style.fontStyle = 1;
                        }
                        if (styles.isEmpty()) {
                            styles.addElement(style);
                        } else {
                            lastStyle = (StyleRange)styles.lastElement();
                            if (lastStyle.similarTo(style) && lastStyle.start + lastStyle.length == style.start) {
                                lastStyle.length += style.length;
                            } else {
                                styles.addElement(style);
                            }
                        }
                    }
                } else if (!styles.isEmpty()) {
                    lastStyle = (StyleRange)styles.lastElement();
                    if (lastStyle.fontStyle == 1) {
                        int start = this.scanner.getStartOffset() + event.lineOffset;
                        lastStyle = (StyleRange)styles.lastElement();
                        if (lastStyle.start + lastStyle.length == start) {
                            lastStyle.length += this.scanner.getLength();
                        }
                    }
                }
            }
            token = this.scanner.nextToken();
        }
        event.styles = new StyleRange[styles.size()];
        styles.copyInto(event.styles);
    }

    public void parseBlockComments(String text) {
        this.blockComments = new Vector();
        StringReader buffer = new StringReader(text);
        boolean blkComment = false;
        boolean cnt = false;
        int[] offsets = new int[2];
    }

    public class AdenineScanner {
        protected Hashtable fgKeys = null;
        protected StringBuffer fBuffer = new StringBuffer();
        protected String fDoc;
        protected int fPos;
        protected int fEnd;
        protected int fStartToken;
        protected boolean fEofSeen = false;
        private String[] fgKeywords = new String[]{"method", "while", "for", "in", "import", "break", "function", "if", "else", "return", "importjava", "var", "prefix", "library", "base", "uniqueMethod", "with", "call"};

        public AdenineScanner() {
            this.initialize();
        }

        public final int getLength() {
            return this.fPos - this.fStartToken;
        }

        void initialize() {
            this.fgKeys = new Hashtable();
            Integer k = new Integer(2);
            int i = 0;
            while (i < this.fgKeywords.length) {
                this.fgKeys.put(this.fgKeywords[i], k);
                ++i;
            }
        }

        public final int getStartOffset() {
            return this.fStartToken;
        }

        public int nextToken() {
            this.fStartToken = this.fPos;
            int c = this.read();
            switch (c) {
                case -1: {
                    return -1;
                }
                case 39: {
                    while (true) {
                        c = this.read();
                        switch (c) {
                            case 39: {
                                return 5;
                            }
                            case -1: {
                                this.unread(c);
                                return 5;
                            }
                            case 92: {
                                c = this.read();
                            }
                        }
                    }
                }
                case 34: {
                    while (true) {
                        c = this.read();
                        switch (c) {
                            case 34: {
                                return 5;
                            }
                            case -1: {
                                this.unread(c);
                                return 5;
                            }
                            case 92: {
                                c = this.read();
                            }
                        }
                    }
                }
                case 60: {
                    while (true) {
                        c = this.read();
                        switch (c) {
                            case 62: {
                                return 8;
                            }
                            case -1: {
                                this.unread(c);
                                return 8;
                            }
                        }
                    }
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    while (Character.isDigit((char)(c = this.read()))) {
                    }
                    this.unread(c);
                    return 7;
                }
            }
            if (Character.isWhitespace((char)c)) {
                while (Character.isWhitespace((char)(c = this.read()))) {
                }
                this.unread(c);
                return 1;
            }
            if (Character.isJavaIdentifierStart((char)c)) {
                this.fBuffer.setLength(0);
                do {
                    this.fBuffer.append((char)c);
                } while (Character.isJavaIdentifierPart((char)(c = this.read())));
                this.unread(c);
                Integer i = (Integer)this.fgKeys.get(this.fBuffer.toString());
                if (i != null) {
                    return i;
                }
                return 0;
            }
            return 6;
        }

        protected int read() {
            if (this.fPos <= this.fEnd) {
                return this.fDoc.charAt(this.fPos++);
            }
            return -1;
        }

        public void setRange(String text) {
            this.fDoc = text;
            this.fPos = 0;
            this.fEnd = this.fDoc.length() - 1;
        }

        protected void unread(int c) {
            if (c != -1) {
                --this.fPos;
            }
        }
    }
}

