/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.soap;

import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.MalformedLSIDException;
import com.ibm.lsid.server.LSIDAssigningService;
import com.ibm.lsid.server.conf.ServiceRegistry;
import com.ibm.lsid.server.soap.AxisFaultBuilder;
import com.ibm.lsid.server.soap.LSIDWebService;
import com.ibm.lsid.soap.SOAPConstants;
import com.ibm.lsid.wsdl.WSDLConstants;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.message.SOAPBodyElement;

public class AssigningWebService
extends LSIDWebService
implements SOAPConstants,
WSDLConstants {
    public SOAPBodyElement[] assignLSID(SOAPBodyElement[] bodyElements) throws AxisFault {
        try {
            LSID bogusLsid = new LSID("urn:lsid:foo:bar:row");
            this.getRequestContext(bogusLsid);
            ServiceRegistry reg = this.getServiceRegistry("assnserviceImplRegistry");
            LSIDAssigningService service = (LSIDAssigningService)reg.lookupService(bogusLsid);
            if (service == null) {
                throw AxisFaultBuilder.createFault(521, "no assigning service available");
            }
            String authority = this.getStringValue(bodyElements[0], "authority");
            String namespace = this.getStringValue(bodyElements[0], "namespace");
            Iterator it = bodyElements[0].getChildElements((Name)new PrefixedQName(null, "propertyList", null));
            if (!it.hasNext()) {
                AxisFaultBuilder.createFault(712, "must specify property list");
            }
            MessageElement propselt = (MessageElement)it.next();
            Properties props = AssigningWebService.extractPropertyList(propselt);
            LSID lsid = service.assignLSID(authority, namespace, props);
            SOAPBodyElement ret = new SOAPBodyElement();
            ret.setName("assignLSIDResponse");
            ret.setNamespaceURI("http://www.omg.org/LSID/2003/Assigning/StandardSOAPBinding");
            this.addStringValue(ret, "lsid", lsid.toString());
            return new SOAPBodyElement[]{ret};
        }
        catch (LSIDException e) {
            throw AxisFaultBuilder.createFault(e);
        }
    }

    public SOAPBodyElement[] assignLSIDFromList(SOAPBodyElement[] bodyElements) throws AxisFault {
        try {
            LSID bogusLsid = new LSID("urn:lsid:foo:bar:row");
            this.getRequestContext(bogusLsid);
            ServiceRegistry reg = this.getServiceRegistry("assnserviceImplRegistry");
            LSIDAssigningService service = (LSIDAssigningService)reg.lookupService(bogusLsid);
            if (service == null) {
                throw AxisFaultBuilder.createFault(521, "no assigning service available");
            }
            Iterator it = bodyElements[0].getChildElements((Name)new PrefixedQName(null, "propertyList", null));
            if (!it.hasNext()) {
                AxisFaultBuilder.createFault(712, "must specify property list");
            }
            MessageElement propselt = (MessageElement)it.next();
            Properties props = AssigningWebService.extractPropertyList(propselt);
            it = bodyElements[0].getChildElements((Name)new PrefixedQName(null, "suggestedLSIDs", null));
            if (!it.hasNext()) {
                AxisFaultBuilder.createFault(712, "must specify suggested lsids");
            }
            MessageElement lsidselt = (MessageElement)it.next();
            LSID[] lsids = AssigningWebService.extractLSIDList(lsidselt);
            LSID lsid = service.assignLSIDFromList(props, lsids);
            SOAPBodyElement ret = new SOAPBodyElement();
            ret.setName("assignLSIDFromListResponse");
            ret.setNamespaceURI("http://www.omg.org/LSID/2003/Assigning/StandardSOAPBinding");
            this.addStringValue(ret, "lsid", lsid.toString());
            return new SOAPBodyElement[]{ret};
        }
        catch (LSIDException e) {
            throw AxisFaultBuilder.createFault(e);
        }
    }

    public SOAPBodyElement[] getLSIDPattern(SOAPBodyElement[] bodyElements) throws AxisFault {
        try {
            LSID bogusLsid = new LSID("urn:lsid:foo:bar:row");
            this.getRequestContext(bogusLsid);
            ServiceRegistry reg = this.getServiceRegistry("assnserviceImplRegistry");
            LSIDAssigningService service = (LSIDAssigningService)reg.lookupService(bogusLsid);
            if (service == null) {
                throw AxisFaultBuilder.createFault(521, "no assigning service available");
            }
            String authority = this.getStringValue(bodyElements[0], "authority");
            String namespace = this.getStringValue(bodyElements[0], "namespace");
            Iterator it = bodyElements[0].getChildElements((Name)new PrefixedQName(null, "propertyList", null));
            if (!it.hasNext()) {
                AxisFaultBuilder.createFault(712, "must specify property list");
            }
            MessageElement propselt = (MessageElement)it.next();
            Properties props = AssigningWebService.extractPropertyList(propselt);
            String pattern = service.getLSIDPattern(authority, namespace, props);
            SOAPBodyElement ret = new SOAPBodyElement();
            ret.setName("getLSIDPatternResponse");
            ret.setNamespaceURI("http://www.omg.org/LSID/2003/Assigning/StandardSOAPBinding");
            this.addStringValue(ret, "LSIDPattern", pattern);
            return new SOAPBodyElement[]{ret};
        }
        catch (LSIDException e) {
            throw AxisFaultBuilder.createFault(e);
        }
    }

    public SOAPBodyElement[] getLSIDPatternFromList(SOAPBodyElement[] bodyElements) throws AxisFault {
        try {
            LSID bogusLsid = new LSID("urn:lsid:foo:bar:row");
            this.getRequestContext(bogusLsid);
            ServiceRegistry reg = this.getServiceRegistry("assnserviceImplRegistry");
            LSIDAssigningService service = (LSIDAssigningService)reg.lookupService(bogusLsid);
            if (service == null) {
                throw AxisFaultBuilder.createFault(521, "no assigning service available");
            }
            Iterator it = bodyElements[0].getChildElements((Name)new PrefixedQName(null, "propertyList", null));
            if (!it.hasNext()) {
                throw AxisFaultBuilder.createFault(712, "must specify property list");
            }
            MessageElement propselt = (MessageElement)it.next();
            Properties props = AssigningWebService.extractPropertyList(propselt);
            it = bodyElements[0].getChildElements((Name)new PrefixedQName(null, "suggestedLSIDPatterns", null));
            if (!it.hasNext()) {
                throw AxisFaultBuilder.createFault(712, "must specify suggested lsids");
            }
            MessageElement patternselt = (MessageElement)it.next();
            String[] patterns = AssigningWebService.extractPatternList(patternselt);
            String pattern = service.getLSIDPatternFromList(props, patterns);
            SOAPBodyElement ret = new SOAPBodyElement();
            ret.setName("getLSIDPatternFromListResponse");
            ret.setNamespaceURI("http://www.omg.org/LSID/2003/Assigning/StandardSOAPBinding");
            this.addStringValue(ret, "LSIDPattern", pattern);
            return new SOAPBodyElement[]{ret};
        }
        catch (LSIDException e) {
            throw AxisFaultBuilder.createFault(e);
        }
    }

    public SOAPBodyElement[] assignLSIDForNewRevision(SOAPBodyElement[] bodyElements) throws AxisFault {
        try {
            LSID bogusLsid = new LSID("urn:lsid:foo:bar:row");
            this.getRequestContext(bogusLsid);
            ServiceRegistry reg = this.getServiceRegistry("assnserviceImplRegistry");
            LSIDAssigningService service = (LSIDAssigningService)reg.lookupService(bogusLsid);
            if (service == null) {
                throw AxisFaultBuilder.createFault(521, "no assigning service available");
            }
            LSID prevLsid = new LSID(this.getStringValue(bodyElements[0], "previousLSID"));
            LSID lsid = service.assignLSIDForNewRevision(prevLsid);
            SOAPBodyElement ret = new SOAPBodyElement();
            ret.setName("assignLSIDForNewRevisionResponse");
            ret.setNamespaceURI("http://www.omg.org/LSID/2003/Assigning/StandardSOAPBinding");
            this.addStringValue(ret, "lsid", lsid.toString());
            return new SOAPBodyElement[]{ret};
        }
        catch (LSIDException e) {
            throw AxisFaultBuilder.createFault(e);
        }
    }

    public SOAPBodyElement[] getAllowedPropertyNames(SOAPBodyElement[] bodyElements) throws AxisFault {
        try {
            LSID bogusLsid = new LSID("urn:lsid:foo:bar:row");
            this.getRequestContext(bogusLsid);
            ServiceRegistry reg = this.getServiceRegistry("assnserviceImplRegistry");
            LSIDAssigningService service = (LSIDAssigningService)reg.lookupService(bogusLsid);
            if (service == null) {
                throw AxisFaultBuilder.createFault(521, "no assigning service available");
            }
            String[] names = service.getAllowedPropertyNames();
            SOAPBodyElement ret = new SOAPBodyElement();
            ret.setName("getAllowedPropertyNamesResponse");
            ret.setNamespaceURI("http://www.omg.org/LSID/2003/Assigning/StandardSOAPBinding");
            SOAPBodyElement elt = new SOAPBodyElement();
            elt.setName("propertyNames");
            AssigningWebService.addPropertyNameList((MessageElement)elt, names);
            try {
                ret.addChildElement((SOAPElement)elt);
            }
            catch (SOAPException e) {
                throw AxisFaultBuilder.createFault((Exception)((Object)e), "error building response");
            }
            return new SOAPBodyElement[]{ret};
        }
        catch (LSIDException e) {
            throw AxisFaultBuilder.createFault(e);
        }
    }

    public SOAPBodyElement[] getAuthoritiesAndNamespaces(SOAPBodyElement[] bodyElements) throws AxisFault {
        try {
            LSID bogusLsid = new LSID("urn:lsid:foo:bar:row");
            this.getRequestContext(bogusLsid);
            ServiceRegistry reg = this.getServiceRegistry("assnserviceImplRegistry");
            LSIDAssigningService service = (LSIDAssigningService)reg.lookupService(bogusLsid);
            if (service == null) {
                throw AxisFaultBuilder.createFault(521, "no assigning service available");
            }
            String[][] names = service.getAuthoritiesAndNamespaces();
            SOAPBodyElement ret = new SOAPBodyElement();
            ret.setName("getAuthoritiesAndNamespacesResponse");
            ret.setNamespaceURI("http://www.omg.org/LSID/2003/Assigning/StandardSOAPBinding");
            SOAPBodyElement elt = new SOAPBodyElement();
            elt.setName("authorityAndNamespaces");
            AssigningWebService.addAuthoritiesAndNamespaces((MessageElement)elt, names);
            try {
                ret.addChildElement((SOAPElement)elt);
            }
            catch (SOAPException e) {
                throw AxisFaultBuilder.createFault((Exception)((Object)e), "error building response");
            }
            return new SOAPBodyElement[]{ret};
        }
        catch (LSIDException e) {
            throw AxisFaultBuilder.createFault(e);
        }
    }

    private static Properties extractPropertyList(MessageElement elt) throws AxisFault {
        PrefixedQName name = new PrefixedQName("http://www.omg.org/LSID/2003/Standard/Assigning/WSDL/SchemaTypes", "property", "anb");
        Iterator elts = elt.getChildElements((Name)name);
        Properties props = new Properties();
        while (elts.hasNext()) {
            MessageElement propelt = (MessageElement)elts.next();
            Iterator nameelts = propelt.getChildElements((Name)new PrefixedQName("http://www.omg.org/LSID/2003/Standard/Assigning/WSDL/SchemaTypes", "name", "anb"));
            Iterator valueelts = propelt.getChildElements((Name)new PrefixedQName("http://www.omg.org/LSID/2003/Standard/Assigning/WSDL/SchemaTypes", "value", "anb"));
            if (!nameelts.hasNext() || !valueelts.hasNext()) {
                throw AxisFaultBuilder.createFault(710, "each property in the propery list must have a name and value");
            }
            MessageElement nameelt = (MessageElement)nameelts.next();
            MessageElement valueelt = (MessageElement)valueelts.next();
            props.put(nameelt.getValue(), valueelt.getValue());
        }
        return props;
    }

    private static LSID[] extractLSIDList(MessageElement elt) throws AxisFault {
        PrefixedQName name = new PrefixedQName("http://www.omg.org/LSID/2003/Standard/Assigning/WSDL/SchemaTypes", "LSID", "anb");
        Iterator elts = elt.getChildElements((Name)name);
        Vector<LSID> v = new Vector<LSID>();
        while (elts.hasNext()) {
            MessageElement lsidelt = (MessageElement)elts.next();
            try {
                v.add(new LSID(lsidelt.getValue()));
            }
            catch (MalformedLSIDException e) {
                AxisFaultBuilder.createFault((LSIDException)((Object)e));
            }
        }
        LSID[] lsids = new LSID[v.size()];
        v.toArray(lsids);
        return lsids;
    }

    private static String[] extractPatternList(MessageElement elt) throws AxisFault {
        PrefixedQName name = new PrefixedQName("http://www.omg.org/LSID/2003/Standard/Assigning/WSDL/SchemaTypes", "LSIDPattern", "anb");
        Iterator elts = elt.getChildElements((Name)name);
        Vector<String> v = new Vector<String>();
        while (elts.hasNext()) {
            MessageElement patternelt = (MessageElement)elts.next();
            v.add(patternelt.getValue());
        }
        String[] lsids = new String[v.size()];
        v.toArray(lsids);
        return lsids;
    }

    private static void addPropertyNameList(MessageElement part, String[] propertyNames) throws AxisFault {
        for (int i = 0; i < propertyNames.length; ++i) {
            MessageElement propelt = new MessageElement((Name)new PrefixedQName("http://www.omg.org/LSID/2003/Standard/Assigning/WSDL/SchemaTypes", "propertyName", "anb"));
            try {
                propelt.setObjectValue((Object)propertyNames[i]);
                part.addChildElement((SOAPElement)propelt);
                continue;
            }
            catch (SOAPException e) {
                AxisFaultBuilder.createFault((Exception)((Object)e), "Error building property list");
            }
        }
    }

    private static void addAuthoritiesAndNamespaces(MessageElement part, String[][] auths) throws AxisFault {
        for (int i = 0; i < auths.length; ++i) {
            try {
                MessageElement anelt = new MessageElement((Name)new PrefixedQName("http://www.omg.org/LSID/2003/Standard/Assigning/WSDL/SchemaTypes", "authorityNamespace", "anb"));
                MessageElement authelt = new MessageElement((Name)new PrefixedQName("http://www.omg.org/LSID/2003/Standard/Assigning/WSDL/SchemaTypes", "authority", "anb"));
                MessageElement nselt = new MessageElement((Name)new PrefixedQName("http://www.omg.org/LSID/2003/Standard/Assigning/WSDL/SchemaTypes", "namespace", "anb"));
                anelt.addChildElement((SOAPElement)authelt);
                anelt.addChildElement((SOAPElement)nselt);
                authelt.addTextNode(auths[i][0]);
                nselt.addTextNode(auths[i][1]);
                part.addChildElement((SOAPElement)anelt);
                continue;
            }
            catch (SOAPException e) {
                AxisFaultBuilder.createFault((Exception)((Object)e), "Error building property list");
            }
        }
    }
}

