/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.impl;

import com.ibm.lsid.ExpiringResponse;
import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.MetadataResponse;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.client.LSIDResolver;
import com.ibm.lsid.client.cache.LSIDCache;
import com.ibm.lsid.server.LSIDAuthorityService;
import com.ibm.lsid.server.LSIDDataService;
import com.ibm.lsid.server.LSIDMetadataService;
import com.ibm.lsid.server.LSIDRequestContext;
import com.ibm.lsid.server.LSIDServerException;
import com.ibm.lsid.server.impl.SimpleFANStore;
import com.ibm.lsid.server.impl.SimpleFANStoreMetadataService;
import com.ibm.lsid.wsdl.HTTPLocation;
import com.ibm.lsid.wsdl.LSIDDataPort;
import com.ibm.lsid.wsdl.LSIDMetadataPort;
import com.ibm.lsid.wsdl.LSIDWSDLWrapper;
import com.ibm.lsid.wsdl.SOAPLocation;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Vector;

public abstract class SimpleResolutionService
implements LSIDAuthorityService,
LSIDDataService,
LSIDMetadataService {
    private static final String FOREIGN_HINT = "foreignAuthorities";
    private Vector validLSIDs = new Vector();

    public ExpiringResponse getAvailableServices(LSIDRequestContext req) throws LSIDServerException {
        String reqUrl;
        LSID lsid = req.getLsid();
        if (!this.validLSIDs.contains(lsid)) {
            this.validate(req);
            this.validLSIDs.add(lsid);
        }
        if (!(reqUrl = req.getReqUrl()).endsWith("/")) {
            reqUrl = reqUrl + "/";
        }
        try {
            URL metaDataURL;
            HTTPLocation p;
            String urlStr;
            LSIDWSDLWrapper wsdl = new LSIDWSDLWrapper(lsid);
            if (this.hasData(req)) {
                urlStr = reqUrl.substring(0, reqUrl.lastIndexOf(47)) + "/data";
                wsdl.setDataLocation((LSIDDataPort)new SOAPLocation(this.getServiceName(), "SOAPData", urlStr));
                try {
                    URL dataURL = new URL(urlStr);
                    p = new HTTPLocation(this.getServiceName(), "HTTPData", dataURL.getHost(), dataURL.getPort(), dataURL.getPath());
                    wsdl.setDataLocation((LSIDDataPort)p);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            if (this.hasMetadata(req)) {
                urlStr = reqUrl.substring(0, reqUrl.lastIndexOf(47)) + "/metadata/";
                wsdl.setMetadataLocation((LSIDMetadataPort)new SOAPLocation(this.getServiceName(), "SOAPMetadata", urlStr));
                try {
                    metaDataURL = new URL(urlStr);
                    p = new HTTPLocation(this.getServiceName(), "HTTPMetadata", metaDataURL.getHost(), metaDataURL.getPort(), metaDataURL.getPath());
                    wsdl.setMetadataLocation((LSIDMetadataPort)p);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            if (this.hasForeignAuthorities(req)) {
                urlStr = reqUrl.substring(0, reqUrl.lastIndexOf(47)) + "/metadata/" + FOREIGN_HINT;
                wsdl.setMetadataLocation((LSIDMetadataPort)new SOAPLocation(this.getServiceName() + "FAN", "SOAPForeignAuthorities", urlStr));
                try {
                    metaDataURL = new URL(urlStr);
                    p = new HTTPLocation(this.getServiceName() + "FAN", "HTTPForeignAuthorities", metaDataURL.getHost(), metaDataURL.getPort(), "/authority/metadata/?hint=foreignAuthorities");
                    wsdl.setMetadataLocation((LSIDMetadataPort)p);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            this.addCustomServices(req, wsdl);
            return new ExpiringResponse((Object)wsdl.toString(), this.getExpiration());
        }
        catch (LSIDException e) {
            throw new LSIDServerException((Exception)((Object)e), "Error processing getAvailableServices for LSID " + lsid);
        }
    }

    protected void checkFormats(String[] formats, String format) throws LSIDServerException {
        boolean hasRDF = false;
        if (formats != null && formats.length > 0) {
            for (int i = 0; i < formats.length; ++i) {
                if (!formats[i].equals(format)) continue;
                hasRDF = true;
                break;
            }
            if (!hasRDF) {
                throw new LSIDServerException(401, "No acceptable metadata format");
            }
        }
    }

    protected void checkLowerCase(LSID lsid) throws LSIDServerException {
        String check = lsid.getNamespace() + lsid.getObject() + (lsid.getRevision() != null ? lsid.getRevision() : null);
        for (int i = 0; i < check.length(); ++i) {
            if (check.charAt(i) < 'A' || check.charAt(i) > 'Z') continue;
            throw new LSIDServerException(201, "namespace, object and revision must not contain lower-case chars");
        }
    }

    protected void addCustomServices(LSIDRequestContext ctx, LSIDWSDLWrapper wrapper) throws LSIDServerException {
    }

    protected Date getExpiration() {
        return null;
    }

    protected abstract String getServiceName();

    protected abstract void validate(LSIDRequestContext var1) throws LSIDServerException;

    protected abstract boolean hasMetadata(LSIDRequestContext var1);

    protected abstract boolean hasData(LSIDRequestContext var1);

    public abstract MetadataResponse doGetMetadata(LSIDRequestContext var1, String[] var2) throws LSIDServerException;

    protected boolean hasForeignAuthorities(LSIDRequestContext req) {
        try {
            return SimpleFANStore.lookupFAPs(req.getLsid()).length >= 1;
        }
        catch (LSIDServerException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void notifyForeignAuthority(LSIDRequestContext req, LSIDAuthority authorityName) throws LSIDServerException {
        block5: {
            SimpleFANStore.addFAP(authorityName, req.getLsid());
            LSIDCache cache = LSIDResolver.getCache();
            if (cache != null) {
                try {
                    LSIDMetadataPort port;
                    LSIDWSDLWrapper wrapper = cache.readWSDL(req.getLsid().getAuthority(), req.getLsid());
                    if (wrapper == null || (port = wrapper.getMetadataPort(this.getServiceName() + "SOAP")) != null) break block5;
                    String reqUrl = req.getReqUrl();
                    String urlStr = reqUrl.substring(0, reqUrl.lastIndexOf(47)) + "/metadata/" + FOREIGN_HINT;
                    wrapper.setMetadataLocation((LSIDMetadataPort)new SOAPLocation(this.getServiceName() + "SOAP", "SOAPForeignAuthorities", urlStr));
                    try {
                        URL metaDataURL = new URL(urlStr);
                        HTTPLocation p = new HTTPLocation(this.getServiceName() + "HTTP", "HTTPForeignAuthorities", metaDataURL.getHost(), metaDataURL.getPort(), "/authority/metadata/?hint=foreignAuthorities");
                        wrapper.setMetadataLocation((LSIDMetadataPort)p);
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                    cache.writeWSDL(req.getLsid().getAuthority(), req.getLsid(), wrapper);
                }
                catch (LSIDException e) {
                    throw new LSIDServerException((Exception)((Object)e), "Error updating cache for foreign auth notification");
                }
            }
        }
    }

    public void revokeNotificationForeignAuthority(LSIDRequestContext req, LSIDAuthority authorityName) throws LSIDServerException {
        SimpleFANStore.removeFAP(authorityName, req.getLsid());
    }

    public InputStream getDataByRange(LSIDRequestContext req, int start, int length) throws LSIDServerException {
        throw new LSIDServerException(501, "Method getDataByRange not implemented");
    }

    public MetadataResponse getMetadata(LSIDRequestContext req, String[] acceptedFormats) throws LSIDServerException {
        String hint = req.getHint();
        if (hint != null && hint.equals(FOREIGN_HINT)) {
            return new SimpleFANStoreMetadataService().getMetadata(req, acceptedFormats);
        }
        return this.doGetMetadata(req, acceptedFormats);
    }
}

