/*
 * Decompiled with CFR 0.152.
 */
package org.tulsoft.tools.soap.axis;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.tulsoft.shared.GException;
import org.tulsoft.tools.soap.axis.AxisUtils;

public class AxisCall {
    protected Call call;
    protected boolean profiling = false;
    protected StringBuffer profileBuf = new StringBuffer();
    protected long profilingTotal = 0L;
    protected URL target;

    public AxisCall(URL target) throws GException {
        this.target = target;
        try {
            this.call = (Call)new Service().createCall();
            this.call.setTargetEndpointAddress(target);
        }
        catch (ServiceException e) {
            throw new GException(e.toString());
        }
    }

    public AxisCall(URL target, int timeout) throws GException {
        this(target);
        this.setTimeout(timeout);
    }

    public Call getCall() {
        return this.call;
    }

    public void setProfiling(boolean enable) {
        this.profiling = enable;
    }

    public String getProfile() {
        if (this.profileBuf.length() > 0) {
            this.profileBuf.append("\n");
            this.profileBuf.append(this.profilingTotal);
            this.profileBuf.append("\t");
            this.profileBuf.append("TOTAL\n");
            return new String(this.profileBuf);
        }
        return "";
    }

    public void disableTimeout() {
        this.call.setTimeout(new Integer(0));
    }

    public void setTimeout(int timeout) {
        if (timeout >= 0) {
            this.call.setTimeout(new Integer(timeout));
        }
    }

    public Object doCall(QName method, Object[] parameters) throws GException {
        try {
            this.call.setOperationName(method);
            if (this.profiling) {
                long start = System.currentTimeMillis();
                Object result = this.call.invoke(parameters);
                long time = System.currentTimeMillis() - start;
                this.profilingTotal += time;
                this.profileBuf.append(time);
                this.profileBuf.append("\t");
                this.profileBuf.append(method.toString());
                return result;
            }
            return this.call.invoke(parameters);
        }
        catch (AxisFault e) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            AxisUtils.formatFault(e, ps, this.target.toString(), this.call == null ? null : this.call.getOperationName());
            throw new GException(baos.toString());
        }
        catch (Exception e) {
            throw new GException(e.toString());
        }
    }

    public Object doCall(String method, Object[] parameters) throws GException {
        return this.doCall(new QName(method), parameters);
    }

    public Object doCall(String methodNamespace, String methodLocalName, Object[] parameters) throws GException {
        return this.doCall(new QName(methodNamespace, methodLocalName), parameters);
    }
}

