/*
 * Decompiled with CFR 0.152.
 */
package org.tulsoft.tools.servlets;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import org.tulsoft.shared.UUtils;
import org.tulsoft.tools.servlets.HtmlConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Html
implements HtmlConstants {
    private static final Hashtable<String, Object> emptyHashtable = new Hashtable();
    protected HttpServletRequest request = null;
    protected boolean autoEscape = true;

    public Html() {
    }

    public Html(HttpServletRequest req) {
        this.setRequester(req);
    }

    public void setRequester(HttpServletRequest request) {
        this.request = request;
    }

    public boolean setAutoEscape(boolean newValue) {
        boolean oldValue = this.autoEscape;
        this.autoEscape = newValue;
        return oldValue;
    }

    public String gen(String tag, String contents) {
        return this.gen(tag, emptyHashtable, contents);
    }

    public String gen(String tag, String[] attrs, String contents) {
        return this.gen(tag, Html.array2hash(attrs), contents);
    }

    public String gen(String tag, String[] attrs) {
        return this.gen(tag, Html.array2hash(attrs), null);
    }

    public String gen(String tag, Hashtable<String, Object> attrs) {
        return this.gen(tag, attrs, null);
    }

    public String gen(String tag) {
        return this.gen(tag, emptyHashtable, null);
    }

    public String gen(String tag, String attrName, String attrValue, String contents) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put(attrName, attrValue);
        return this.gen(tag, ht, contents);
    }

    public String gen(String tag, Hashtable<String, Object> attrs, String contents) {
        StringBuffer buf = new StringBuffer();
        buf.append("<" + tag);
        Enumeration<String> en = attrs.keys();
        while (en.hasMoreElements()) {
            String name = en.nextElement();
            if (UUtils.isEmpty(name)) continue;
            Object value = attrs.get(name);
            buf.append(" " + name);
            if (value instanceof NullObject) continue;
            buf.append("=\"" + (this.autoEscape ? Html.esc((String)value) : value) + "\"");
        }
        buf.append(">");
        if (contents == null) {
            return new String(buf);
        }
        buf.append(contents);
        buf.append("</" + tag + ">");
        return new String(buf);
    }

    public String end(String tag) {
        return "</" + tag + ">";
    }

    public String a(String href, String contents) {
        return this.a(href, null, contents);
    }

    public String a(String href, String target, String contents) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("HREF", href);
        if (target != null) {
            ht.put("TARGET", target);
        }
        return this.a(ht, contents);
    }

    public String a(String[] attrs, String contents) {
        return this.a(Html.array2hash(attrs), contents);
    }

    public String a(Hashtable<String, Object> attrs, String contents) {
        boolean localAutoEscape = this.setAutoEscape(false);
        StringBuffer buf = new StringBuffer();
        buf.append(this.gen("A", attrs));
        buf.append(contents);
        buf.append(this.end("A"));
        this.setAutoEscape(localAutoEscape);
        return new String(buf);
    }

    public String startHtml(String title) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("TITLE", title);
        return this.startHtml(ht, null);
    }

    public String startHtml(String[] attrs) {
        return this.startHtml(Html.array2hash(attrs), null);
    }

    public String startHtml(Hashtable<String, Object> attrs, String theRest) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.gen("HTML") + this.gen("HEAD"));
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        Enumeration<String> en = attrs.keys();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            if (key.equalsIgnoreCase("TITLE")) {
                buf.append(this.gen("TITLE", (String)attrs.get(key)));
                continue;
            }
            if (key.equalsIgnoreCase("SCRIPT")) {
                Hashtable<String, Object> ht2 = new Hashtable<String, Object>();
                ht2.put("TYPE", "text/javascript");
                ht2.put("LANGUAGE", "JavaScript");
                buf.append(this.gen("SCRIPT", ht2, "<!-- Hide script\n" + attrs.get(key) + "\n" + "// End script hiding -->\n"));
                continue;
            }
            if (key.equalsIgnoreCase("NOSCRIPT")) {
                buf.append(this.gen("NOSCRIPT", (String)attrs.get(key)));
                continue;
            }
            ht.put(key, attrs.get(key));
        }
        if (theRest != null) {
            buf.append(theRest);
        }
        buf.append(this.end("HEAD"));
        buf.append(this.gen("BODY", ht));
        return new String(buf);
    }

    public String endHtml() {
        return this.end("BODY") + this.end("HTML");
    }

    public String text(String name) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("NAME", name);
        return this.text(ht);
    }

    public String text(String name, String dflt) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("NAME", name);
        ht.put("VALUE", dflt);
        return this.text(ht);
    }

    public String text(String name, String dflt, int size) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("NAME", name);
        ht.put("VALUE", dflt);
        ht.put("SIZE", "" + size);
        return this.text(ht);
    }

    public String text(String name, String[] attrs) {
        Hashtable<String, Object> ht = Html.array2hash(attrs);
        ht.put("NAME", name);
        return this.text(ht);
    }

    public String text(Hashtable<String, Object> attrs) {
        this.stickyPreviousValue(attrs, "VALUE");
        return this.gen("INPUT", attrs, null);
    }

    public String hidden(String name, String value) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("NAME", name);
        if (value != null) {
            ht.put("VALUE", value);
        }
        return this.hidden(ht);
    }

    public String hidden(String name, String value, boolean force) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("NAME", name);
        if (value != null) {
            ht.put("VALUE", value);
        }
        ht.put("FORCE", new Boolean(force));
        return this.hidden(ht);
    }

    public String hidden(Hashtable<String, Object> attrs) {
        attrs.put("TYPE", "hidden");
        this.stickyPreviousValue(attrs, "VALUE");
        attrs.remove("FORCE");
        return this.gen("INPUT", attrs, null);
    }

    public String checkbox(String name) {
        return this.checkbox(name, false, "on");
    }

    public String checkbox(String name, boolean checked) {
        return this.checkbox(name, checked, "on");
    }

    public String checkbox(String name, boolean checked, String value) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("TYPE", "checkbox");
        ht.put("NAME", name);
        if (value != null) {
            ht.put("VALUE", value);
        }
        if (checked) {
            ht.put("CHECKED", this.getNullObject());
        }
        return this.gen("INPUT", ht);
    }

    public String checkbox(String name, String[] attrs) {
        Hashtable<String, Object> ht = Html.array2hash(attrs);
        ht.put("TYPE", "checkbox");
        return this.gen("INPUT", ht);
    }

    protected void stickyPreviousValue(Hashtable<String, Object> attrs, String attrName) {
        String previousValue;
        Object force = attrs.get("FORCE");
        if (force != null) {
            if (force instanceof String && UUtils.is((String)force)) {
                return;
            }
            if (force instanceof Boolean && ((Boolean)force).booleanValue()) {
                return;
            }
        }
        String name = (String)attrs.get("NAME");
        if (this.request != null && name != null && (previousValue = this.request.getParameter(name)) != null) {
            attrs.put(attrName, previousValue);
        }
    }

    public String submit(String label) {
        return this.submit(label, null);
    }

    public String submit(String label, String name) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("TYPE", "submit");
        if (name != null) {
            ht.put("NAME", name);
        }
        if (label != null) {
            ht.put("VALUE", label);
        }
        return this.gen("INPUT", ht);
    }

    public String button(String label) {
        return this.button(label, null, label);
    }

    public String button(String label, String onClick) {
        return this.button(label, onClick, label);
    }

    public String button(String label, String onClick, String name) {
        return "<INPUT TYPE=\"button\" NAME=\"" + name + "\"" + " VALUE=\"" + label + "\"" + (UUtils.isEmpty(onClick) ? "" : " ONCLICK=\"" + onClick + "\"") + ">\n";
    }

    public String list(String name, String[] labels) {
        return this.list(name, labels, null, null);
    }

    public String list(String name, String[] labels, Hashtable<String, String> selected) {
        return this.list(name, labels, null, selected);
    }

    public String list(String name, String[] labels, String[] values, Hashtable<String, String> selected) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("NAME", name);
        return this.list(ht, labels, values, selected);
    }

    public String list(String[] attrs, String[] labels, String[] values, Hashtable<String, String> selected) {
        return this.list(Html.array2hash(attrs), values, labels, selected);
    }

    public String list(Hashtable<String, Object> attrs, String[] labels, String[] values, Hashtable<String, String> selected) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.gen("SELECT", attrs));
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        NullObject nullObj = new NullObject();
        if (values == null || values.length < labels.length) {
            for (int i = 0; i < labels.length; ++i) {
                if (selected != null && selected.get(labels[i]) != null) {
                    ht.put("SELECTED", nullObj);
                } else {
                    ht.remove("SELECTED");
                }
                buf.append(this.gen("OPTION", ht, Html.esc(labels[i])));
            }
        } else {
            for (int i = 0; i < labels.length; ++i) {
                ht.put("VALUE", values[i]);
                if (selected != null && (selected.get(labels[i]) != null || selected.get(values[i]) != null)) {
                    ht.put("SELECTED", nullObj);
                } else {
                    ht.remove("SELECTED");
                }
                buf.append(this.gen("OPTION", ht, Html.esc(labels[i])));
            }
        }
        buf.append(this.end("SELECT"));
        return new String(buf);
    }

    public static String esc(String value) {
        int len = value.length();
        StringBuffer buf = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '\"') {
                buf.append("&quot;");
                continue;
            }
            if (c == '&') {
                buf.append("&amp;");
                continue;
            }
            if (c == '<') {
                buf.append("&lt;");
                continue;
            }
            if (c == '>') {
                buf.append("&gt;");
                continue;
            }
            int ci = 0xFFFF & c;
            if (ci < 160) {
                buf.append(c);
                continue;
            }
            buf.append("&#");
            buf.append(new Integer(ci).toString());
            buf.append(';');
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] trimList(int maxLen, String[] source) {
        if (maxLen < 1) {
            return source;
        }
        String[] stringArray = source;
        synchronized (source) {
            String[] result = new String[source.length];
            boolean changed = false;
            for (int i = 0; i < source.length; ++i) {
                if (source[i].length() > maxLen + 3) {
                    result[i] = source[i].substring(0, maxLen - 3) + "...";
                    changed = true;
                    continue;
                }
                result[i] = source[i];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return changed ? result : source;
        }
    }

    public static Hashtable<String, Object> array2hash(String[] attrs) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        for (int i = 0; i < attrs.length - 1; i += 2) {
            ht.put(attrs[i], attrs[i + 1]);
        }
        return ht;
    }

    public NullObject getNullObject() {
        return new NullObject();
    }

    public class NullObject {
    }
}

