/*
 * Decompiled with CFR 0.152.
 */
package org.tulsoft.tools.loaders;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.tulsoft.shared.UUtils;

public class CLoader
extends ClassLoader {
    private Hashtable<String, Class> Classes = new Hashtable();
    private boolean debug = false;
    private String path = "";
    public static final String DYNACLASSPATH = "DYNACLASSPATH";

    public CLoader() {
    }

    public CLoader(String path) {
        this.path = path;
    }

    public void setDebug(boolean toggle) {
        this.debug = toggle;
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            Class<?> newClass = this.Classes.get(name);
            if (newClass == null) {
                try {
                    newClass = this.findSystemClass(name);
                    if (newClass != null) {
                        if (this.debug) {
                            System.out.println("Found " + name);
                        }
                        return newClass;
                    }
                }
                catch (ClassNotFoundException e) {
                }
                catch (NoClassDefFoundError e) {
                    // empty catch block
                }
                byte[] buf = this.bytesForClass(name);
                try {
                    newClass = this.defineClass(name, buf, 0, buf.length);
                }
                catch (Error e2) {
                    newClass = this.defineClass(null, buf, 0, buf.length);
                }
                this.Classes.put(name, newClass);
            }
            if (resolve) {
                this.resolveClass(newClass);
            }
            return newClass;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(e.getMessage());
        }
        catch (Error e) {
            throw new ClassNotFoundException(e.getMessage());
        }
    }

    protected byte[] bytesForClass(String name) throws IOException, ClassNotFoundException {
        FileInputStream in = this.streamFor(name);
        int length = in.available();
        if (length == 0) {
            throw new ClassNotFoundException(name);
        }
        byte[] buf = new byte[length];
        in.read(buf);
        if (this.debug) {
            System.out.println("Loaded " + name + " (length: " + length + ")");
        }
        return buf;
    }

    protected FileInputStream streamFor(String name) throws IOException {
        String fileSep = System.getProperty("file.separator");
        if (!name.endsWith(".class")) {
            name = name.replace('.', fileSep.charAt(0)) + ".class";
        }
        if (!new File(name).exists()) {
            if (UUtils.isEmpty(name) || name.startsWith(fileSep)) {
                return new FileInputStream(name);
            }
            if (UUtils.isEmpty(this.path)) {
                this.path = System.getProperty(DYNACLASSPATH);
            }
            if (!UUtils.isEmpty(this.path)) {
                name = this.path.endsWith(fileSep) ? this.path + name : this.path + fileSep + name;
            }
        }
        if (this.debug) {
            System.out.println("Loading class file: " + name);
        }
        return new FileInputStream(name);
    }
}

