/*
 * Decompiled with CFR 0.152.
 */
package org.tulsoft.tools.gui;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.tulsoft.tools.gui.SwingUtils;

public class ProgressView
extends JPanel {
    public static final String VERSION = "$Id: ProgressView.java,v 1.1 2005/09/18 13:41:36 marsenger Exp $";
    protected boolean isInitialized = true;
    protected String msg = "Loading, please wait...";
    protected JFrame frame;
    protected JLabel progressLabel = null;
    protected JProgressBar progressBar = null;
    protected int frameWidth = 400;
    protected int frameHeight = 200;
    public static ProgressView monitor = new ProgressView();

    public Insets getInsets() {
        return new Insets(40, 30, 20, 30);
    }

    protected ProgressView() {
        this(10);
    }

    public ProgressView(int maxProgressValue) {
        this.progressBar = new JProgressBar(0, maxProgressValue);
        this.progressBar.setStringPainted(true);
        this.progressBar.setAlignmentX(0.5f);
        this.progressLabel = new JLabel(this.msg);
        this.progressLabel.setAlignmentX(0.5f);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.progressLabel);
        this.add(Box.createRigidArea(new Dimension(1, 20)));
        this.add(this.progressBar);
    }

    public void show(String title) {
        if (!this.isInitialized) {
            return;
        }
        this.frame = SwingUtils.createMainFrame(this, title);
        this.frame.setCursor(Cursor.getPredefinedCursor(3));
        SwingUtils.showMainFrame(this.frame, this.frameWidth, this.frameHeight);
    }

    public void destroy() {
        this.isInitialized = false;
        if (this.frame != null) {
            this.frame.setCursor(Cursor.getPredefinedCursor(0));
            this.frame.dispose();
        }
    }

    public void setText(String msg) {
        if (this.isInitialized) {
            this.progressLabel.setText(msg);
        }
    }

    public void setValue(int progressValue) {
        if (this.isInitialized) {
            this.progressBar.setValue(progressValue);
        }
    }

    public void add() {
        if (this.isInitialized) {
            this.progressBar.setValue(this.progressBar.getValue() + 1);
        }
    }

    public void setTextAndAdd(String msg) {
        if (this.isInitialized) {
            this.setText(msg);
            this.add();
        }
    }

    public void setFrameWidth(int width) {
        if (width > 0) {
            this.frameWidth = width;
        }
    }

    public void setFrameHeight(int height) {
        if (height > 0) {
            this.frameHeight = height;
        }
    }
}

