/*
 * Decompiled with CFR 0.152.
 */
package org.tulsoft.tools.external;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.tulsoft.shared.GException;

public abstract class InputStreamProvider
extends PipedInputStream
implements Runnable {
    protected PipedOutputStream _pos;
    protected Thread thread;
    protected String errMessage = "";
    protected boolean error = false;
    protected Object data = null;
    protected String format = null;

    public InputStreamProvider() throws IOException {
        this.init();
    }

    public InputStreamProvider(Object _obj) throws IOException {
        this.data = _obj;
        this.init();
    }

    public InputStreamProvider(Object _obj, String _format) throws IOException {
        this.data = _obj;
        this.format = _format;
        this.init();
    }

    protected InputStreamProvider(int _FAKE) throws IOException {
    }

    protected void init() throws IOException {
        this._pos = new PipedOutputStream();
        this.connect(this._pos);
        this.thread = new Thread(this);
        this.thread.start();
    }

    public abstract void write(OutputStream var1) throws GException;

    public void run() {
        try {
            this.write(this._pos);
        }
        catch (GException ex) {
            this.errMessage = "InputStreamProvider: " + ex.getMessage();
            this.error = true;
        }
    }

    public String getErrorMessage() {
        return this.errMessage;
    }

    public int read() throws IOException {
        if (this.error) {
            throw new IOException(this.errMessage);
        }
        return super.read();
    }

    public int read(byte[] b) throws IOException {
        if (this.error) {
            throw new IOException(this.errMessage);
        }
        return super.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.error) {
            throw new IOException(this.errMessage);
        }
        return super.read(b, off, len);
    }

    protected void receive(int b) throws IOException {
        if (this.error) {
            throw new IOException("pipe is broken because of :" + this.errMessage);
        }
        super.receive(b);
    }
}

