/*
 * Decompiled with CFR 0.152.
 */
package org.tulsoft.tools.external;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Properties;
import org.tulsoft.shared.GException;
import org.tulsoft.shared.UUtils;
import org.tulsoft.tools.external.CatchOutput;
import org.tulsoft.tools.external.CatchOutputDefaultImpl;

public class Executor {
    public static final String VERSION = "$Id: Executor.java,v 1.2 2007/03/25 18:55:18 marsenger Exp $";
    CatchOutput stdoutProcessor;
    Thread stdoutThread = null;
    CatchOutput stderrProcessor = null;
    Thread stderrThread = null;
    SendInputThread stdinThread = null;
    Process child = null;
    boolean stdoutStreamAskedFor = false;
    boolean stderrStreamAskedFor = false;
    protected long id = System.currentTimeMillis();

    public Executor(String[] cmdArr, String[] envArr) throws GException {
        this.child = this.startIt(cmdArr, envArr);
    }

    public Executor(String[] cmdArr, String[] envArr, String toStdin) throws GException {
        this.child = this.startIt(cmdArr, envArr);
        if (toStdin != null) {
            this.stdinThread = new SendInputThread(this.child.getOutputStream(), toStdin);
            this.stdinThread.start();
        }
    }

    public Executor(String[] cmdArr, String[] envArr, InputStream toStdin) throws GException {
        this.child = this.startIt(cmdArr, envArr);
        if (toStdin != null) {
            this.stdinThread = new SendInputThread(this.child.getOutputStream(), toStdin);
            this.stdinThread.start();
        }
    }

    protected Process startIt(String[] cmdArr, String[] envArr) throws GException {
        try {
            return Runtime.getRuntime().exec(cmdArr, envArr);
        }
        catch (IOException e) {
            String app = "[empty]";
            if (cmdArr.length > 0) {
                app = cmdArr[0];
            }
            throw new GException("Can't launch an application " + app + ".\n" + e.toString());
        }
    }

    public int waitFor() throws GException, InterruptedException {
        if (!this.stdoutStreamAskedFor) {
            this.stdoutProcessor = new CatchOutputDefaultImpl(this.child.getInputStream());
            this.stdoutThread = new Thread(this.stdoutProcessor);
            this.stdoutThread.start();
        }
        if (!this.stderrStreamAskedFor) {
            this.stderrProcessor = new CatchOutputDefaultImpl(this.child.getErrorStream());
            this.stderrThread = new Thread(this.stderrProcessor);
            this.stderrThread.start();
        }
        int exitLauncherCode = -1;
        try {
            exitLauncherCode = this.child.waitFor();
            if (this.stdoutThread != null) {
                this.stdoutThread.join();
            }
            if (this.stderrThread != null) {
                this.stderrThread.join();
            }
            if (this.stdinThread != null) {
                this.stdinThread.join();
            }
        }
        catch (InterruptedException e) {
            if (this.stdoutThread != null) {
                this.stdoutThread.join();
            }
            if (this.stderrThread != null) {
                this.stderrThread.join();
            }
            if (this.stdinThread != null) {
                this.stdinThread.join();
            }
            e.fillInStackTrace();
        }
        String msg = null;
        if (this.stdoutThread != null) {
            msg = this.stdoutProcessor.getErrorMessage();
        }
        if (msg == null && this.stderrThread != null) {
            msg = this.stderrProcessor.getErrorMessage();
        }
        if (msg == null && this.stdinThread != null) {
            msg = this.stdinThread.getErrorMessage();
        }
        if (msg == null) {
            return exitLauncherCode;
        }
        throw new GException("Error during running external program:\n" + msg);
    }

    public String getId() {
        return "" + this.id;
    }

    public String getFormattedId() {
        return "Started at " + UUtils.formatDate(this.id);
    }

    public void killIt() {
        if (this.child != null) {
            this.child.destroy();
        }
    }

    public InputStream getStdoutStream() {
        this.stdoutStreamAskedFor = true;
        return this.child.getInputStream();
    }

    public InputStream getStderrStream() {
        this.stderrStreamAskedFor = true;
        return this.child.getErrorStream();
    }

    public String getStdout() {
        if (this.stdoutThread == null) {
            return "";
        }
        return this.stdoutProcessor.getData();
    }

    public String getStderr() {
        if (this.stderrThread == null) {
            return "";
        }
        return this.stderrProcessor.getData();
    }

    public static String[] propertiesToEnv(Properties properties) {
        return Executor.propertiesToEnv(properties, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] propertiesToEnv(Properties properties, boolean toUpperCase) {
        String[] envp;
        Properties properties2 = properties;
        synchronized (properties2) {
            envp = new String[properties.size()];
            int i = 0;
            if (toUpperCase) {
                Enumeration<?> en = properties.propertyNames();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    envp[i++] = key.toUpperCase() + "=" + properties.getProperty(key);
                }
            } else {
                Enumeration<?> en = properties.propertyNames();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    envp[i++] = key + "=" + properties.getProperty(key);
                }
            }
        }
        return envp;
    }

    class SendInputThread
    extends Thread {
        String errorMessage = null;
        BufferedWriter processInput;
        String contents = null;
        InputStream inputStream = null;
        boolean fromStream = false;

        public SendInputThread(OutputStream stream, String contents) {
            this.contents = contents;
            this.fromStream = false;
            this.processInput = new BufferedWriter(new OutputStreamWriter(stream));
        }

        public SendInputThread(OutputStream stream, InputStream inputStream) {
            this.inputStream = inputStream;
            this.fromStream = true;
            this.processInput = new BufferedWriter(new OutputStreamWriter(stream));
        }

        public void run() {
            try {
                if (this.fromStream) {
                    int b;
                    while ((b = this.inputStream.read()) != -1) {
                        this.processInput.write(b);
                    }
                } else {
                    this.processInput.write(this.contents);
                }
                this.processInput.close();
            }
            catch (IOException e) {
                this.errorMessage = "Error by feeding the application input: " + e.toString();
            }
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

