/*
 * Decompiled with CFR 0.152.
 */
package org.tulsoft.shared;

import java.util.Vector;

public abstract class StringUtils {
    public static final String VERSION = "$Id: StringUtils.java,v 1.3 2007/03/25 18:55:17 marsenger Exp $";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] addPrefix(String prefix, String[] strings) {
        String[] stringArray = strings;
        synchronized (strings) {
            String[] list = new String[strings.length];
            for (int i = 0; i < list.length; ++i) {
                list[i] = prefix + strings[i];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] addSuffix(String suffix, String[] strings) {
        String[] stringArray = strings;
        synchronized (strings) {
            String[] list = new String[strings.length];
            for (int i = 0; i < list.length; ++i) {
                list[i] = strings[i] + suffix;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return list;
        }
    }

    public static String stripChar(char CHAR, String str) {
        char[] s = str.toCharArray();
        int padds = 0;
        for (int i = 0; i < s.length; ++i) {
            if (s[i] != CHAR) continue;
            ++padds;
        }
        char[] n = new char[s.length - padds];
        int j = 0;
        for (int i = 0; i < s.length; ++i) {
            if (s[i] == CHAR) continue;
            n[j++] = s[i];
        }
        return new String(n);
    }

    public static int numBeforeLocation(char CHAR, String str, int loc) {
        char[] c = str.toCharArray();
        int ix = 0;
        for (int i = 0; i < Math.min(loc, c.length); ++i) {
            if (c[i] != CHAR) continue;
            ++ix;
        }
        return ix;
    }

    public static int[] positions(char CHAR, String str) {
        char[] c = str.toCharArray();
        int ix = 0;
        for (int i = 0; i < c.length; ++i) {
            if (c[i] != CHAR) continue;
            ++ix;
        }
        int[] res = new int[ix];
        ix = 0;
        for (int i = 0; i < c.length; ++i) {
            if (c[i] != CHAR) continue;
            res[ix++] = i;
        }
        return res;
    }

    public static String removeWhites(String str) {
        StringBuffer buf = new StringBuffer();
        char[] c = str.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] <= ' ') continue;
            buf.append(c[i]);
        }
        return new String(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(String[] stringList, String delimiter) {
        int len = stringList.length;
        StringBuffer buf = new StringBuffer(len * 20);
        String[] stringArray = stringList;
        synchronized (stringList) {
            for (int i = 0; i < len - 1; ++i) {
                buf.append(stringList[i]);
                buf.append(delimiter);
            }
            if (len > 0) {
                buf.append(stringList[len - 1]);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return buf.toString();
        }
    }

    public static String join(String[] stringList) {
        return StringUtils.join(stringList, " ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(Vector stringVector, String delimiter) {
        int len = stringVector.size();
        StringBuffer buf = new StringBuffer(len * 20);
        Vector vector = stringVector;
        synchronized (vector) {
            for (int i = 0; i < len - 1; ++i) {
                buf.append((String)stringVector.elementAt(i));
                buf.append(delimiter);
            }
            if (len > 0) {
                buf.append((String)stringVector.elementAt(len - 1));
            }
        }
        return buf.toString();
    }

    public static String join(Vector stringVector) {
        return StringUtils.join(stringVector, " ");
    }

    public static String replace(String string, String from, String to) {
        if (from.equals("")) {
            return string;
        }
        StringBuffer buf = new StringBuffer(2 * string.length());
        int previndex = 0;
        int index = 0;
        int flen = from.length();
        while (true) {
            if ((index = string.indexOf(from, previndex)) == -1) break;
            buf.append(string.substring(previndex, index) + to);
            previndex = index + flen;
        }
        buf.append(string.substring(previndex));
        return buf.toString();
    }

    public static String delete(String string, String delete) {
        return StringUtils.replace(string, delete, "");
    }

    public static String removePositions(String str, int[] pos) {
        char[] n = new char[str.length() - pos.length];
        char[] s = str.toCharArray();
        int shift = 0;
        for (int i = 0; i < s.length; ++i) {
            if (shift < pos.length && i == pos[shift]) {
                ++shift;
                continue;
            }
            n[i - shift] = s[i];
        }
        return new String(n);
    }

    public static int nthIndexOf(String s, String find, int n) {
        return StringUtils.nthIndexOf(s, find, n, 0);
    }

    public static int nthIndexOf(String s, String find, int n, int from) {
        int f = 0;
        int len = find.length();
        f = s.indexOf(find, f + from);
        for (int i = 0; i < n && f != -1; ++i) {
            f = s.indexOf(find, f + len);
        }
        return f;
    }

    public static String[] toStringArray(Vector v) {
        Object[] s = new String[v.size()];
        v.copyInto(s);
        return s;
    }

    public static String capitalize(String string) {
        if (string == null || string.equals("")) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
    }

    public static String[] customizeMsg(String str, int maxLines) {
        return StringUtils.customizeMsg(str, maxLines, -1);
    }

    public static String[] customizeMsg(String str, int maxLines, int maxLineLength) {
        String[] msgLines = str.split("\n");
        if (msgLines.length > maxLines) {
            String[] tmp = new String[maxLines];
            System.arraycopy(msgLines, 0, tmp, 0, tmp.length);
            msgLines = tmp;
        }
        if (maxLineLength > 0) {
            for (int i = 0; i < msgLines.length; ++i) {
                if (msgLines[i].length() <= maxLineLength) continue;
                msgLines[i] = msgLines[i].substring(0, maxLineLength) + "...";
            }
        }
        return msgLines;
    }
}

