/*
 * Decompiled with CFR 0.152.
 */
package org.tulsoft.shared;

import java.util.Arrays;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.tulsoft.shared.UUtils;

public abstract class PrefsUtils {
    public static final String VERSION = "$Id: PrefsUtils.java,v 1.1 2005/09/18 09:25:41 marsenger Exp $";

    public static Preferences getNode(String nodeName) {
        Preferences myNode = Preferences.userRoot();
        if (UUtils.notEmpty(nodeName)) {
            myNode = myNode.node(nodeName);
        }
        return myNode;
    }

    public static Preferences getNode(Class c, String nodeName) {
        if (UUtils.isEmpty(nodeName)) {
            return PrefsUtils.getNode(PrefsUtils.nodeNameFromClass(c));
        }
        if (nodeName.startsWith("/")) {
            return PrefsUtils.getNode(PrefsUtils.nodeNameFromClass(c) + nodeName);
        }
        return PrefsUtils.getNode(PrefsUtils.nodeNameFromClass(c) + "/" + nodeName);
    }

    public static Preferences getNode(Class c) {
        return PrefsUtils.getNode(PrefsUtils.nodeNameFromClass(c));
    }

    public static String[] getValues(Preferences node) {
        try {
            Object[] keys = node.keys();
            Arrays.sort(keys);
            String[] values = new String[keys.length];
            int j = 0;
            for (int i = keys.length - 1; i >= 0; --i) {
                values[j++] = node.get((String)keys[i], "");
            }
            return values;
        }
        catch (BackingStoreException e) {
            return new String[0];
        }
    }

    public static void removeKeys(Preferences node) {
        try {
            node.clear();
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    private static String nodeNameFromClass(Class c) {
        String className = c.getName();
        return "/" + className.replace('.', '/');
    }

    public static void updateKey(Preferences node, String key, String value) {
        try {
            String[] keys = node.keys();
            for (int i = 0; i < keys.length; ++i) {
                if (!value.equals(node.get(keys[i], ""))) continue;
                node.remove(keys[i]);
            }
            node.put(key, value);
            node.sync();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }
}

