/*
 * Decompiled with CFR 0.152.
 */
package org.tulsoft.shared;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.tulsoft.shared.GException;
import org.tulsoft.shared.UUtils;

public abstract class FileUtils {
    public static String resolvePath(String fileName, String path) {
        if (new File(fileName).isAbsolute()) {
            return fileName;
        }
        String fileSep = System.getProperty("file.separator");
        if (UUtils.isEmpty(path)) {
            return fileName;
        }
        if (path.endsWith(fileSep)) {
            return path + fileName;
        }
        return path + fileSep + fileName;
    }

    public static String resolvePathFromClassPath(String fileName) throws GException {
        File file = new File(fileName);
        if (file.isAbsolute()) {
            if (file.exists()) {
                return fileName;
            }
            throw new GException("File " + fileName + " does not exist.");
        }
        String classPath = System.getProperty("java.class.path");
        String pathSep = System.getProperty("path.separator");
        String fileSep = System.getProperty("file.separator");
        String[] dirs = classPath.split("\\Q" + pathSep + "\\E");
        for (int i = 0; i < dirs.length; ++i) {
            String resultName;
            if (UUtils.isEmpty(dirs[i]) || !new File(resultName = dirs[i].endsWith(fileName) || (dirs[i] + fileSep).endsWith(fileName) || dirs[i].endsWith(fileName + fileSep) ? dirs[i] : dirs[i] + (dirs[i].endsWith(fileSep) ? "" : fileSep) + fileName).exists()) continue;
            return resultName;
        }
        throw new GException("File " + fileName + " does not exist.");
    }

    public static File resolvePathInJarFilesFromClassPath(String fileName, boolean perhapsDirectory) throws GException {
        String classPath = System.getProperty("java.class.path");
        String pathSep = System.getProperty("path.separator");
        String[] dirs = classPath.split("\\Q" + pathSep + "\\E");
        for (int i = 0; i < dirs.length; ++i) {
            File jarFile;
            if (UUtils.isEmpty(dirs[i]) || !FileUtils.isJarFile(dirs[i]) || !(jarFile = new File(dirs[i])).exists() || !FileUtils.existsInJarFile(jarFile, fileName, perhapsDirectory)) continue;
            return jarFile;
        }
        throw new GException("File " + fileName + " was not found.");
    }

    public static boolean existsInJarFile(File jarFile, String fileName, boolean perhapsDirectory) {
        try {
            ZipFile zf = new ZipFile(jarFile);
            if (zf.getEntry(fileName) != null) {
                return true;
            }
            if (perhapsDirectory) {
                if (!fileName.endsWith("/")) {
                    fileName = fileName + "/";
                }
                Enumeration<? extends ZipEntry> en = zf.entries();
                while (en.hasMoreElements()) {
                    String name = en.nextElement().getName();
                    if (!name.startsWith(fileName)) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isJarFile(String fileName) {
        File f = new File(fileName);
        String lastName = f.getName();
        if (UUtils.isEmpty(f.getName())) {
            return false;
        }
        String fileExt = FileUtils.getExtension(f).toLowerCase();
        return fileExt.equals("jar") || fileExt.equals("zip");
    }

    public static String getExtension(File f) {
        String filename;
        int pos;
        if (f != null && (pos = (filename = f.getName()).lastIndexOf(46)) > 0 && pos < filename.length() - 1) {
            return filename.substring(pos + 1);
        }
        return "";
    }

    public static String getExtension(String f) {
        return FileUtils.getExtension(new File(f));
    }

    public static String getFile(String fName) {
        try {
            return FileUtils.getFile(fName, true);
        }
        catch (IOException e) {
            return "";
        }
        catch (GException e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFile(String fName, boolean silent) throws IOException, GException {
        StringBuffer contents = new StringBuffer();
        BufferedReader data = null;
        try {
            String line;
            data = new BufferedReader(new InputStreamReader(new FileInputStream(fName)));
            while ((line = data.readLine()) != null) {
                contents.append(line);
                contents.append("\n");
            }
        }
        catch (IOException e) {
            if (!silent) {
                throw (IOException)e.fillInStackTrace();
            }
        }
        catch (Error e) {
            if (!silent) {
                throw new GException("Serious error. " + e.toString(), e);
            }
        }
        finally {
            try {
                if (data != null) {
                    data.close();
                }
            }
            catch (IOException e) {}
        }
        return new String(contents);
    }

    public static byte[] getBinaryFile(String fName) throws IOException, GException {
        return FileUtils.getBinaryFile(new FileInputStream(fName));
    }

    public static byte[] getBinaryFile(InputStream in) throws IOException, GException {
        if (in == null) {
            return new byte[0];
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
        try {
            int bytesRead;
            byte[] buffer = new byte[256];
            while ((bytesRead = in.read(buffer)) != -1) {
                bout.write(buffer, 0, bytesRead);
            }
            bout.close();
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        catch (Throwable e) {
            throw new GException("Serious error. " + e.toString(), e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }

    public static byte[] getURLFile(URL url) throws IOException, GException {
        URLConnection uc = url.openConnection();
        uc.connect();
        return FileUtils.getBinaryFile(uc.getInputStream());
    }

    public static byte[] findAndGetBinaryFile(String fileName) throws GException {
        String fullFileName = null;
        File jarFile = null;
        try {
            fullFileName = new File(fileName).exists() ? new File(fileName).getAbsolutePath() : FileUtils.resolvePathFromClassPath(fileName);
        }
        catch (GException e) {
            jarFile = FileUtils.resolvePathInJarFilesFromClassPath(fileName, false);
        }
        if (jarFile == null) {
            try {
                return FileUtils.getBinaryFile(fullFileName);
            }
            catch (IOException e) {
                throw new GException(e.toString());
            }
        }
        return FileUtils.getJarEntry(jarFile, fileName);
    }

    public static byte[] getJarEntry(File jarFile, String entryName) throws GException {
        try {
            ZipFile zf = new ZipFile(jarFile);
            ZipEntry ze = zf.getEntry(entryName);
            if (ze == null) {
                throw new GException("'" + entryName + "' was not found in '" + jarFile.getAbsolutePath() + "'.");
            }
            if (ze.isDirectory()) {
                throw new GException("'" + entryName + "' found in '" + jarFile.getAbsolutePath() + "' is a directory.");
            }
            int size = (int)ze.getSize();
            if (size == 1) {
                throw new GException("'" + entryName + "' was found in '" + jarFile.getAbsolutePath() + "' but it reports unknown size.");
            }
            zf.close();
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(jarFile)));
            int rb = 0;
            int chunk = 0;
            byte[] buf = new byte[size];
            while ((ze = zis.getNextEntry()) != null) {
                if (!ze.getName().equals(entryName)) continue;
                while (size - rb > 0 && (chunk = zis.read(buf, rb, size - rb)) != -1) {
                    rb += chunk;
                }
                zf.close();
                return buf;
            }
            throw new GException("'" + entryName + "' was not found in '" + jarFile.getAbsolutePath() + "'");
        }
        catch (Exception e) {
            throw new GException("Reading from '" + jarFile.getAbsolutePath() + "' failed.\n" + e.toString());
        }
    }
}

