/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard.renderers;

import java.awt.Color;
import java.awt.Component;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.biomoby.shared.MobyException;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.tulsoft.tools.gui.SwingUtils;

public class XMLTree
extends JTree {
    public static final int MAX_TEXT_SIZE = 1000;
    int textSizeLimit = 1000;
    Element rootElement = null;
    static Icon nodeIcon;
    static Icon leafIcon;

    public XMLTree(String text) throws MobyException {
        this.init((Content)this.createDocument(text).getRootElement());
        this.revalidate();
    }

    public XMLTree(String text, int textSizeLimit) throws MobyException {
        this.textSizeLimit = textSizeLimit;
        this.init((Content)this.createDocument(text).getRootElement());
        this.revalidate();
    }

    public XMLTree(Document document) {
        this.init((Content)document.getRootElement());
        this.revalidate();
    }

    public XMLTree(Document document, int textSizeLimit) {
        this.textSizeLimit = textSizeLimit;
        this.init((Content)document.getRootElement());
        this.revalidate();
    }

    protected void loadIcons() {
        if (nodeIcon == null) {
            nodeIcon = SwingUtils.createIcon((String)"images/xml_node.gif", XMLTree.class);
        }
        if (leafIcon == null) {
            leafIcon = SwingUtils.createIcon((String)"images/leaf.gif", XMLTree.class);
        }
    }

    protected Document createDocument(String text) throws MobyException {
        try {
            return new SAXBuilder(false).build((Reader)new StringReader(text));
        }
        catch (Exception e) {
            throw new MobyException(e.toString());
        }
    }

    private void init(Content content) {
        this.loadIcons();
        this.rootElement = (Element)content;
        this.setRowHeight(0);
        this.getSelectionModel().setSelectionMode(1);
        this.setShowsRootHandles(true);
        this.setEditable(false);
        this.setModel(new DefaultTreeModel(this.createTreeNode(content)));
        XMLTreeCellRenderer tRend = new XMLTreeCellRenderer();
        tRend.setLeafIcon(leafIcon);
        this.setCellRenderer(tRend);
        this.setAllNodesExpanded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllNodesExpanded() {
        TreeModel treeModel = this.getModel();
        synchronized (treeModel) {
            this.expandAll(this, new TreePath(this.getModel().getRoot()), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeModel treeModel = this.getModel();
        synchronized (treeModel) {
            TreeNode node = (TreeNode)parent.getLastPathComponent();
            if (node.getChildCount() >= 0) {
                Enumeration<? extends TreeNode> e = node.children();
                while (e.hasMoreElements()) {
                    TreeNode n = e.nextElement();
                    TreePath path = parent.pathByAddingChild(n);
                    this.expandAll(tree, path, expand);
                }
            }
            if (expand) {
                tree.expandPath(parent);
            } else {
                tree.collapsePath(parent);
            }
        }
    }

    private XMLNode createTreeNode(Content content) {
        XMLNode node = new XMLNode(content);
        if (content instanceof Parent) {
            Parent parent = (Parent)content;
            for (Object child : parent.getContent()) {
                Text text;
                if (child instanceof Element) {
                    node.add(this.createTreeNode((Content)child));
                    continue;
                }
                if (this.textSizeLimit == 0 || !(child instanceof Text) || (text = (Text)child).getTextNormalize().equals("")) continue;
                node.add(this.createTreeNode((Content)text));
            }
        }
        return node;
    }

    private class XMLTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private XMLTreeCellRenderer() {
        }

        @Override
        public Color getBackgroundNonSelectionColor() {
            return null;
        }

        @Override
        public Color getBackground() {
            return null;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setOpaque(false);
            if (value instanceof XMLNode) {
                XMLNode node = (XMLNode)value;
                if (node.getUserObject() instanceof Element) {
                    this.setIcon(nodeIcon);
                    Element element = (Element)node.getUserObject();
                    StringBuffer nameBuffer = new StringBuffer("<html>" + element.getQualifiedName());
                    boolean addedAnAttribute = false;
                    if (element.getParent() instanceof Element) {
                        Element parent = (Element)element.getParent();
                        if (parent.getNamespace(element.getNamespacePrefix()) == null) {
                            nameBuffer.append(" <font color=\"purple\">xmlns:" + element.getNamespacePrefix() + "</font>=\"<font color=\"green\">" + element.getNamespaceURI() + "</font>\"");
                        }
                    } else {
                        nameBuffer.append(" <font color=\"purple\">xmlns:" + element.getNamespacePrefix() + "</font>=\"<font color=\"green\">" + element.getNamespaceURI() + "</font>\"");
                    }
                    for (Attribute attribute : element.getAttributes()) {
                        String name = attribute.getName().trim();
                        String attributeValue = attribute.getValue().trim();
                        if (attributeValue == null || attributeValue.length() <= 0) continue;
                        if (addedAnAttribute) {
                            nameBuffer.append(",");
                        }
                        addedAnAttribute = true;
                        nameBuffer.append(" <font color=\"purple\">" + name + "</font>=\"<font color=\"green\">" + attributeValue + "</font>\"");
                    }
                    nameBuffer.append("</html>");
                    this.setText(nameBuffer.toString());
                } else if (node.getUserObject() instanceof Text) {
                    Text text = (Text)node.getUserObject();
                    String name = text.getText();
                    if (XMLTree.this.textSizeLimit > -1 && name.length() > XMLTree.this.textSizeLimit) {
                        name = name.substring(0, XMLTree.this.textSizeLimit) + "...";
                    }
                    this.setText("<html><pre><font color=\"blue\">" + name.replaceAll("<br>", "\n").replaceAll("<", "&lt;") + "</font></pre></html>");
                }
            }
            this.setBackground(new Color(0, 0, 0, 0));
            return this;
        }
    }

    private class XMLNode
    extends DefaultMutableTreeNode {
        public XMLNode(Content userObject) {
            super(userObject);
        }
    }
}

