/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard.renderers;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.tools.SPInterface;
import org.apache.commons.discovery.tools.Service;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biomoby.service.dashboard.renderers.Renderer;

public class RendererRegistry {
    private static Log log = LogFactory.getLog(RendererRegistry.class);
    private static RendererRegistry instance;
    private List renderers = new ArrayList();

    public static synchronized RendererRegistry instance() {
        if (instance == null) {
            instance = new RendererRegistry();
            instance.loadInstances(RendererRegistry.class.getClassLoader());
        }
        return instance;
    }

    protected RendererRegistry() {
    }

    public void loadInstances(ClassLoader classLoader) {
        log.info((Object)"Loading renderers started.");
        SPInterface spiIF = new SPInterface(Renderer.class);
        ClassLoaders loaders = new ClassLoaders();
        loaders.put(classLoader);
        Enumeration spe = Service.providers((SPInterface)spiIF, (ClassLoaders)loaders);
        while (spe.hasMoreElements()) {
            Renderer spi = (Renderer)spe.nextElement();
            log.info((Object)("Renderer '" + spi.getName() + "' loaded."));
            this.renderers.add(spi);
        }
        log.info((Object)"Loading renderers finished.");
    }

    public Renderer getRenderer(String criterion, Object value) {
        for (Renderer rend : this.renderers) {
            if (!rend.canHandle(criterion, value)) continue;
            return rend;
        }
        return null;
    }

    public List getRenderers(String criterion, Object value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Can handle: " + criterion + " = " + value + "?"));
        }
        ArrayList<Renderer> res = new ArrayList<Renderer>();
        for (Renderer rend : this.renderers) {
            if (!rend.canHandle(criterion, value)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("\tfound " + rend.getName()));
            }
            res.add(rend);
        }
        return res;
    }

    public void addRenderer(Renderer renderer) {
        this.renderers.add(renderer);
    }

    public void removeRenderer(Renderer renderer) {
        this.renderers.remove(renderer);
    }

    public int size() {
        return this.renderers.size();
    }

    public Iterator iterator() {
        return this.renderers.iterator();
    }

    public Renderer get(int index) {
        return (Renderer)this.renderers.get(index);
    }
}

