/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard.renderers;

import java.io.File;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biomoby.service.dashboard.PropertyChannel;
import org.biomoby.service.dashboard.ServiceCallerModel;
import org.biomoby.service.dashboard.SwingWorker;
import org.biomoby.service.dashboard.data.DataContainer;
import org.biomoby.service.dashboard.renderers.AbstractMobyRenderer;
import org.biomoby.service.dashboard.renderers.TabCollectionRenderer;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.datatypes.MobyObject;
import org.biomoby.shared.parser.MobyPackage;
import org.cgiar.icis.pedigree.PedigreeTreeComponent;
import org.cgiar.icis.pedigree.PedigreeTreeNodeObject;
import org.tulsoft.shared.GException;
import org.tulsoft.tools.loaders.ICreator;

public class ICISPedigreeTree
extends AbstractMobyRenderer {
    private static Log log = LogFactory.getLog(ICISPedigreeTree.class);

    public ICISPedigreeTree() {
        super("Pedigree Tree", "images/tree.gif");
    }

    @Override
    public boolean canHandle(String criterion, Object value) {
        return criterion.equals("moby-type") && this.isSubclassOfKnown(value.toString());
    }

    @Override
    public JComponent getComponent(DataContainer data) throws MobyException {
        if (data.getData().getClass().isArray()) {
            return new TabCollectionRenderer(this).getComponent(data);
        }
        try {
            String xmlPedigree = this.traverseToString(data.getData());
            try {
                MobyPedigreeTree treeComp = new MobyPedigreeTree(data);
                treeComp.updatePedigreeTree(null, 0L, xmlPedigree);
                return treeComp;
            }
            catch (Exception e2) {
                throw new MobyException("Cannot create a pedigree tree.", (Throwable)e2);
            }
        }
        catch (Error e) {
            throw new MobyException("Problem in renderer '" + this.getName() + "'.", (Throwable)e);
        }
    }

    @Override
    public boolean save2File(DataContainer data, File file) throws MobyException {
        return false;
    }

    class MobyPedigreeTree
    extends PedigreeTreeComponent {
        DataContainer initData;

        public MobyPedigreeTree(DataContainer data) throws Exception {
            super(350);
            this.initData = data;
        }

        public void valueChanged(TreeSelectionEvent evt) {
            DefaultMutableTreeNode node;
            if (evt.getSource() == this.pedigreeTree && (node = (DefaultMutableTreeNode)this.pedigreeTree.getLastSelectedPathComponent()) != null) {
                Object userNode = node.getUserObject();
                if (userNode == null) {
                    return;
                }
                if (!(userNode instanceof PedigreeTreeNodeObject)) {
                    log.error((Object)("Found '" + userNode.toString() + "' (of type: " + userNode.getClass().getName() + ") instead of a PedigreeTreeNodeObject."));
                    return;
                }
                PedigreeTreeNodeObject treeNode = (PedigreeTreeNodeObject)userNode;
                if (treeNode.getName() != null) {
                    if (node.isLeaf()) {
                        MyCaller runWorker = new MyCaller(treeNode.getPropertyValue("icis:gid"), (PropertyChannel)this.initData.getMetadata(), node);
                        runWorker.start();
                    }
                    this.updateGermplasmItemInfo(treeNode);
                }
            }
        }

        class MyCaller
        extends SwingWorker {
            MobyException exception = null;
            DataContainer data = new DataContainer();
            String gid;
            PropertyChannel propertyChannel;
            DefaultMutableTreeNode node;

            public MyCaller(String gid, PropertyChannel propertyChannel, DefaultMutableTreeNode node) {
                this.gid = gid;
                this.propertyChannel = propertyChannel;
                this.node = node;
            }

            @Override
            public Object construct() {
                try {
                    this.propertyChannel.fire("status-msg", "Calling service to update pedigree tree...");
                    MobyObject mInp = (MobyObject)ICreator.createInstance((String)"org.biomoby.shared.datatypes.GCP_GermplasmId");
                    mInp.setId(this.gid);
                    MobyPackage moby = new MobyPackage(mInp, "germplasm_id");
                    this.data.setData(moby.toXML());
                    ServiceCallerModel callerModel = new ServiceCallerModel();
                    callerModel.setPropertyChannel(this.propertyChannel);
                    callerModel.runIt(this.data);
                }
                catch (MobyException e) {
                    this.exception = e;
                }
                catch (GException e) {
                    this.exception = new MobyException("Problem updating pedigree tree.", (Throwable)e);
                }
                catch (Error e) {
                    this.exception = new MobyException("Problem updating pedigree tree.", (Throwable)e);
                }
                return null;
            }

            @Override
            public void finished() {
                if (this.exception == null) {
                    this.propertyChannel.fire("status-msg", "Service invocation finished.");
                    try {
                        MobyPackage response = MobyPackage.createFromXML((Object)this.data.getData());
                        String xml = ICISPedigreeTree.this.traverseToString(response.getJob(0).getData());
                        PedigreeTreeNodeObject treeNode = (PedigreeTreeNodeObject)this.node.getUserObject();
                        MobyPedigreeTree.this.updatePedigreeTree(this.node, 0L, xml);
                        MobyPedigreeTree.this.updateGermplasmItemInfo(treeNode);
                    }
                    catch (Exception e2) {
                        log.error((Object)("Unable to update pedigree tree: " + e2.toString()));
                    }
                } else {
                    this.propertyChannel.fire("status-msg", "Service invocation failed (see the log file).");
                    log.error((Object)("Unable to update pedigree tree: " + this.exception.toString()));
                }
            }
        }
    }
}

