/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard.renderers;

import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import org.apache.axis.encoding.Base64;
import org.biomoby.service.dashboard.data.DataContainer;
import org.biomoby.service.dashboard.renderers.AbstractMobyRenderer;
import org.biomoby.service.dashboard.renderers.TabCollectionRenderer;
import org.biomoby.shared.MobyException;

public class Base64Image
extends AbstractMobyRenderer {
    public Base64Image() {
        super("Image", "images/image.gif");
    }

    public Base64Image(String name, String iconName) {
        super(name, iconName);
    }

    @Override
    public boolean canHandle(String criterion, Object value) {
        return criterion.equals("moby-type") && this.isSubclassOfKnown(value.toString());
    }

    @Override
    public JComponent getComponent(DataContainer data) throws MobyException {
        if (data.getData().getClass().isArray()) {
            return new TabCollectionRenderer(this).getComponent(data);
        }
        try {
            String encoded = this.traverseToString(data.getData());
            byte[] imageData = Base64.decode((String)encoded);
            ImageIcon theImage = new ImageIcon(imageData);
            return new JScrollPane(new JLabel(theImage));
        }
        catch (Error e) {
            throw new MobyException("Problem in renderer '" + this.getName() + "'.", (Throwable)e);
        }
    }

    @Override
    public boolean save2File(DataContainer data, File file) throws MobyException {
        if (data.getData().getClass().isArray()) {
            return new TabCollectionRenderer(this).save2File(data, file);
        }
        String encoded = this.traverseToString(data.getData());
        byte[] imageData = Base64.decode((String)encoded);
        return super.save2File(new DataContainer(imageData), file);
    }
}

