/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard.renderers;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.biomoby.service.dashboard.data.DataContainer;
import org.biomoby.service.dashboard.renderers.BoxCollectionRenderer;
import org.biomoby.service.dashboard.renderers.Renderer;
import org.biomoby.shared.MobyException;
import org.tulsoft.tools.gui.SwingUtils;

public abstract class AbstractRenderer
implements Renderer {
    private String name;
    private Icon icon;
    protected String iconFileName;

    public AbstractRenderer(String name) {
        this.name = name;
    }

    public AbstractRenderer(String name, Icon icon) {
        this.name = name;
        this.icon = icon;
    }

    public AbstractRenderer(String name, String iconFileName) {
        this.name = name;
        this.iconFileName = iconFileName;
    }

    @Override
    public Icon getIcon() {
        if (this.icon == null && this.iconFileName != null) {
            this.icon = SwingUtils.createIcon((String)this.iconFileName, (Object)this);
        }
        return this.icon;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public boolean save2File(DataContainer data, File file) throws MobyException {
        if (data == null) {
            return false;
        }
        Object d = data.getData();
        if (d instanceof byte[]) {
            return this.saveBytes((byte[])d, file);
        }
        if (d.getClass().isArray()) {
            Object[] ds = (Object[])d;
            if (byte[].class == ds.getClass().getComponentType()) {
                BoxCollectionRenderer collRend = new BoxCollectionRenderer(this);
                return collRend.save2File(data, file);
            }
            try {
                PrintWriter fileout = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                for (int i = 0; i < ds.length; ++i) {
                    fileout.print(ds[i].toString());
                }
                fileout.close();
                return true;
            }
            catch (IOException e) {
                throw new MobyException(this.error(e, file));
            }
        }
        try {
            PrintWriter fileout = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            fileout.print(data.getData().toString());
            fileout.close();
            return true;
        }
        catch (IOException e) {
            throw new MobyException(this.error(e, file));
        }
    }

    protected String error(Exception e, File file) {
        return "Problem with file " + file.getAbsolutePath() + ": " + e.toString();
    }

    protected boolean saveBytes(byte[] bytes, File file) throws MobyException {
        try {
            BufferedOutputStream fileout = new BufferedOutputStream(new FileOutputStream(file));
            fileout.write(bytes);
            fileout.close();
            return true;
        }
        catch (IOException e) {
            throw new MobyException(this.error(e, file));
        }
    }

    @Override
    public abstract boolean canHandle(String var1, Object var2);

    @Override
    public abstract JComponent getComponent(DataContainer var1) throws MobyException;
}

