/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard.renderers;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biomoby.service.dashboard.renderers.AbstractRenderer;
import org.biomoby.service.dashboard.renderers.Renderer;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.Utils;
import org.biomoby.shared.datatypes.MapDataTypesIfc;
import org.biomoby.shared.parser.MobyParser;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public abstract class AbstractMobyRenderer
extends AbstractRenderer {
    private static Log log = LogFactory.getLog(AbstractMobyRenderer.class);
    protected static final String RENDERERS_CONF_FILE = "renderers.conf.xml";
    protected static MapDataTypesIfc mapDataTypes;
    protected static Map KNOWN;

    public AbstractMobyRenderer(String name) {
        super(name);
    }

    public AbstractMobyRenderer(String name, String iconName) {
        super(name, iconName);
    }

    protected Map getKnownTypesForThisClass() {
        Class<?> thisClass = this.getClass();
        for (Class parentClass : KNOWN.keySet()) {
            if (!parentClass.isAssignableFrom(thisClass)) continue;
            return (Map)KNOWN.get(parentClass);
        }
        return new HashMap();
    }

    protected boolean isSubclassOfKnown(String testedTypeName) {
        Map knownTypes = this.getKnownTypesForThisClass();
        try {
            Class testedClass;
            if (mapDataTypes == null) {
                mapDataTypes = MobyParser.loadB2JMapping();
            }
            if ((testedClass = mapDataTypes.getClass(testedTypeName)) == null) {
                return false;
            }
            for (String dataTypeName : knownTypes.keySet()) {
                Class parentClass = mapDataTypes.getClass(dataTypeName);
                if (parentClass == null) {
                    log.error((Object)("No class found for " + dataTypeName + ". Try to regenerate datatypes."));
                    continue;
                }
                if (!parentClass.isAssignableFrom(testedClass)) continue;
                return true;
            }
        }
        catch (MobyException mobyException) {
            // empty catch block
        }
        return false;
    }

    protected String getMethodOfKnown(Object actor) {
        Map knownTypes = this.getKnownTypesForThisClass();
        try {
            if (mapDataTypes == null) {
                mapDataTypes = MobyParser.loadB2JMapping();
            }
            Class<?> actorClass = actor.getClass();
            for (String dataTypeName : knownTypes.keySet()) {
                Class parentClass = mapDataTypes.getClass(dataTypeName);
                if (parentClass == null || !parentClass.isAssignableFrom(actorClass)) continue;
                return (String)knownTypes.get(dataTypeName);
            }
        }
        catch (MobyException mobyException) {
            // empty catch block
        }
        return null;
    }

    protected String traverseToString(Object data) throws MobyException {
        try {
            HashSet alreadyVisited = new HashSet();
            Object actor = data;
            while (true) {
                Class<?> actorClass;
                if (alreadyVisited.contains(actorClass = actor.getClass())) {
                    throw new MobyException("Found cycle for class " + actorClass + ": " + alreadyVisited.toString());
                }
                alreadyVisited.add(actorClass);
                String methodName = this.getMethodOfKnown(actor);
                if (methodName == null) {
                    throw new MobyException("Expected method was not found in classes: " + alreadyVisited.toString());
                }
                Method method = actorClass.getMethod(methodName, new Class[0]);
                Object result = method.invoke(actor, new Object[0]);
                if (result instanceof String) {
                    return (String)result;
                }
                actor = result;
            }
        }
        catch (Throwable e) {
            throw new MobyException(e.toString());
        }
    }

    static {
        try {
            KNOWN = new HashMap();
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(Utils.getResourceURL((String)RENDERERS_CONF_FILE, Renderer.class));
            Element root = doc.getRootElement();
            List rs = root.getChildren("renderer");
            for (Element rend : rs) {
                String className = rend.getAttributeValue("class");
                try {
                    Class<?> aClass = Class.forName(className);
                    List mts = rend.getChildren("moby_type");
                    HashMap<String, String> aClassMap = new HashMap<String, String>();
                    for (Element mobyType : mts) {
                        String mtName = mobyType.getAttributeValue("name");
                        String mtMethod = mobyType.getAttributeValue("method");
                        if (mtName == null || mtMethod == null) continue;
                        aClassMap.put(mtName, mtMethod);
                    }
                    KNOWN.put(aClass, aClassMap);
                }
                catch (Exception e2) {
                    log.error((Object)("Class instantiation failed for " + className + ": " + Utils.stackTraceIfSerious((Throwable)e2)));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Problem with renderers.conf.xml: " + Utils.stackTraceIfSerious((Throwable)e)));
        }
        if (log.isDebugEnabled()) {
            for (Class aClass : KNOWN.keySet()) {
                log.debug((Object)("Moby types renderable by " + aClass.getName() + ": " + KNOWN.get(aClass)));
            }
        }
    }
}

