/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard.data;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.biomoby.service.dashboard.Dashboard;
import org.biomoby.service.dashboard.data.DataTypeTreeTable;
import org.biomoby.service.dashboard.data.ParametersTable;
import org.biomoby.shared.MobyData;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyPrimaryData;
import org.biomoby.shared.MobyPrimaryDataSet;
import org.biomoby.shared.MobyPrimaryDataSimple;
import org.biomoby.shared.MobySecondaryData;
import org.biomoby.shared.MobyService;
import org.biomoby.shared.datatypes.MobyObject;
import org.biomoby.shared.parser.MobyCollection;
import org.biomoby.shared.parser.MobyJob;
import org.biomoby.shared.parser.MobyPackage;
import org.biomoby.shared.parser.MobySimple;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.tulsoft.shared.UUtils;
import org.tulsoft.tools.gui.SwingUtils;

public class ServiceInputPanel
extends JPanel {
    protected static Icon addDataIcon;
    protected static Icon addParamIcon;
    protected static Icon addCollIcon;
    Vector inputTables;
    ParametersTable paramsTable;

    public ServiceInputPanel(MobyService service, MobyDataType[] dataTypes) {
        super(new GridBagLayout());
        ServiceInputPanel.loadIcons();
        MobyPrimaryData[] primInputs = service.getPrimaryInputs();
        MobySecondaryData[] sis = service.getSecondaryInputs();
        MobySecondaryData[] secInputs = new MobySecondaryData[sis.length];
        for (int i = 0; i < sis.length; ++i) {
            secInputs[i] = sis[i];
        }
        this.inputTables = new Vector();
        this.paramsTable = secInputs == null || secInputs.length == 0 ? null : new ParametersTable(secInputs);
        JTabbedPane tabbedPane = new JTabbedPane();
        SwingUtils.addComponent((JComponent)this, (Component)tabbedPane, (int)0, (int)0, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        for (int i = 0; i < primInputs.length; ++i) {
            MobyPrimaryData pData = primInputs[i];
            MobyDataType rootType = this.findDataType(pData.getDataType().getName(), dataTypes);
            if (rootType == null) continue;
            DataTypeTreeTable treeTable = new DataTypeTreeTable(rootType, dataTypes);
            JPanel p = new JPanel(new GridBagLayout());
            SwingUtils.addComponent((JComponent)p, (Component)treeTable.scrollable(), (int)0, (int)0, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
            this.inputTables.addElement(pData);
            this.inputTables.addElement(treeTable);
            String toolTip = rootType.getDescription();
            tabbedPane.addTab(pData.getName(), addDataIcon, p, "<html>" + toolTip.replaceAll("\n", "<br>\n"));
        }
        if (secInputs != null && secInputs.length > 0) {
            JPanel p = new JPanel(new GridBagLayout());
            SwingUtils.addComponent((JComponent)p, (Component)this.paramsTable.scrollable(), (int)0, (int)0, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
            tabbedPane.addTab("Parameters", addDataIcon, p, "Enter secondary inputs/parameters");
        }
    }

    protected MobyDataType findDataType(String dataTypeToBeFound, MobyDataType[] dataTypes) {
        for (int i = 0; i < dataTypes.length; ++i) {
            if (!dataTypeToBeFound.equals(dataTypes[i].getName())) continue;
            return dataTypes[i];
        }
        System.err.println("Strange, data type '" + dataTypeToBeFound + "' was not found in " + dataTypes.length + " data types.");
        return null;
    }

    protected static void loadIcons() {
        if (addDataIcon == null) {
            addDataIcon = SwingUtils.createIcon((String)"images/smallAnnotate.gif", Dashboard.class);
        }
    }

    public Document getXMLDocument() {
        Vector<Element> v = new Vector<Element>();
        for (int i = 0; i < this.inputTables.size(); i += 2) {
            MobyData data = (MobyData)this.inputTables.elementAt(i);
            DataTypeTreeTable table = (DataTypeTreeTable)this.inputTables.elementAt(i + 1);
            String articleName = data.getName();
            Element dataElem = table.toXML();
            Element wrapperElem = null;
            if (data instanceof MobyPrimaryDataSimple) {
                wrapperElem = MobySimple.toXML((String)articleName, (Element)dataElem);
            } else if (data instanceof MobyPrimaryDataSet) {
                wrapperElem = MobyCollection.toXML((String)articleName, (Element[])new Element[]{MobySimple.toXML((String)"", (Element)dataElem)});
            }
            if (wrapperElem == null) continue;
            v.addElement(wrapperElem);
        }
        if (this.paramsTable != null) {
            Element[] params = this.paramsTable.toXML();
            for (int i = 0; i < params.length; ++i) {
                v.addElement(params[i]);
            }
        }
        Object[] allData = new Element[v.size()];
        v.copyInto(allData);
        Document doc = MobyPackage.toXMLDocument((Element[])new Element[]{MobyJob.toXML((String)"sip_1_", (Element[])allData)});
        return doc;
    }

    public void setValues(String xml) throws MobyException {
        MobyPackage pack = MobyPackage.createFromXML((Object)xml);
        MobyJob job = null;
        if (pack != null && pack.getJobs().length > 0) {
            job = pack.getJob(0);
        }
        if (job == null) {
            return;
        }
        for (int i = 0; i < this.inputTables.size(); i += 2) {
            MobyData data = (MobyData)this.inputTables.elementAt(i);
            DataTypeTreeTable table = (DataTypeTreeTable)this.inputTables.elementAt(i + 1);
            String articleName = data.getName();
            MobyObject object = job.getData(articleName);
            if (object == null) continue;
            table.populateData(object);
        }
        if (this.paramsTable != null) {
            Object[] values = this.paramsTable.tableModel.getData();
            for (int i = 0; i < values.length; ++i) {
                String name;
                String secondary;
                if ("".equals(values[i]) || (secondary = job.getParameter(name = this.paramsTable.paramDefs[i].getName())) == null) continue;
                values[i] = UUtils.isEmpty((String)secondary) ? "" : secondary;
            }
        }
        this.updateUI();
    }

    public String toXML() {
        XMLOutputter xo = new XMLOutputter();
        xo.setFormat(Format.getPrettyFormat());
        return xo.outputString(this.getXMLDocument());
    }
}

