/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard.data;

import com.toedter.components.JSpinField;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.biomoby.service.dashboard.chooser.DateTimeChooserEditor;
import org.biomoby.shared.MobySecondaryData;
import org.biomoby.shared.parser.MobyParameter;
import org.jdom.Element;
import org.tulsoft.shared.UUtils;

public class ParametersTable
extends JTable {
    protected ParametersTableModel tableModel;
    MobySecondaryData[] paramDefs;

    public ParametersTable(MobySecondaryData[] paramDefs) {
        this.tableModel = new ParametersTableModel(paramDefs);
        this.paramDefs = paramDefs;
        this.setModel(this.tableModel);
        this.getTableHeader().setReorderingAllowed(false);
        this.getColumnModel().getColumn(1).setCellEditor(new MultiEditor());
        this.getColumnModel().getColumn(1).setCellRenderer(new MultiRenderer());
    }

    public JScrollPane scrollable() {
        return new JScrollPane(this);
    }

    public Element[] toXML() {
        Object[] values = this.tableModel.getData();
        Vector<Element> v = new Vector<Element>();
        for (int i = 0; i < values.length; ++i) {
            if ("".equals(values[i])) continue;
            v.addElement(MobyParameter.toXML((String)this.paramDefs[i].getName(), (String)values[i].toString()));
        }
        Object[] result = new Element[v.size()];
        v.copyInto(result);
        return result;
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                return ParametersTable.this.tableModel.columnToolTips[realIndex];
            }
        };
    }

    protected class ParametersTableModel
    extends AbstractTableModel {
        protected static final int COL_NAME = 0;
        protected static final int COL_VALUE = 1;
        String[] columnToolTips = new String[]{"Parameter (article) name", "Parameter value"};
        String[] columnNames = new String[]{"Name", "Value"};
        Class[] columnClasses = new Class[]{String.class, String.class};
        MobySecondaryData[] paramDefs;
        Object[] values;

        public ParametersTableModel(MobySecondaryData[] paramDefs) {
            this.paramDefs = paramDefs;
            this.values = new Object[paramDefs.length];
            for (int i = 0; i < paramDefs.length; ++i) {
                MobySecondaryData def = paramDefs[i];
                String defValue = def.getDefaultValue();
                this.values[i] = UUtils.isEmpty((String)defValue) ? "" : defValue;
            }
        }

        public Object[] getData() {
            return this.values;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return this.paramDefs[row].getName();
            }
            if (col == 1) {
                return this.values[row];
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            if (col == 1) {
                this.values[row] = aValue;
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.paramDefs.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Class getColumnClass(int col) {
            return this.columnClasses[col];
        }
    }

    class MultiEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        TableCellEditor[] cellEditors;
        protected TableCellEditor editor;

        public MultiEditor() {
            this.cellEditors = new TableCellEditor[ParametersTable.this.paramDefs.length];
            for (int i = 0; i < ParametersTable.this.paramDefs.length; ++i) {
                MobySecondaryData def = ParametersTable.this.paramDefs[i];
                String[] allowed = def.getAllowedValues();
                String type = def.getDataType();
                int min = def.getMinimumValue();
                int max = def.getMaximumValue();
                this.cellEditors[i] = allowed.length > 0 ? new DefaultCellEditor(new JComboBox<String>(allowed)) : (type.equals("Float") ? ParametersTable.this.getDefaultEditor(Double.class) : (type.equals("Integer") ? new SpinnerEditor(min, max) : (type.equals("Boolean") ? ParametersTable.this.getDefaultEditor(Boolean.class) : (type.equals("DateTime") ? new DateTimeChooserEditor() : ParametersTable.this.getDefaultEditor(String.class)))));
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.editor = this.cellEditors[row];
            return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return this.editor.getCellEditorValue();
        }

        @Override
        public boolean stopCellEditing() {
            return this.editor.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            this.editor.cancelCellEditing();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.editor.addCellEditorListener(l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.editor.removeCellEditorListener(l);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return this.editor.shouldSelectCell(anEvent);
        }
    }

    class MultiRenderer
    extends DefaultTableCellRenderer {
        TableCellRenderer[] cellRenderers;

        public MultiRenderer() {
            this.setOpaque(true);
            this.cellRenderers = new TableCellRenderer[ParametersTable.this.paramDefs.length];
            for (int i = 0; i < ParametersTable.this.paramDefs.length; ++i) {
                MobySecondaryData def = ParametersTable.this.paramDefs[i];
                String type = def.getDataType();
                this.cellRenderers[i] = type.equals("Boolean") ? ParametersTable.this.getDefaultRenderer(Boolean.class) : ParametersTable.this.getDefaultRenderer(String.class);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (ParametersTable.this.paramDefs[row].getDataType().equals("Boolean")) {
                value = value instanceof Boolean ? value : new Boolean(value.toString());
            }
            return this.cellRenderers[row].getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    class SpinnerEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        int currentRow = -1;
        JSpinField spinner;

        public SpinnerEditor(int min, int max) {
            this.spinner = new JSpinField(min, max);
            this.spinner.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    try {
                        if (evt.getPropertyName().equals("value") && SpinnerEditor.this.currentRow > -1) {
                            ParametersTable.this.tableModel.setValueAt(evt.getNewValue().toString(), SpinnerEditor.this.currentRow, 1);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            try {
                this.spinner.setValue(new Integer(value.toString()).intValue());
                this.currentRow = row;
            }
            catch (NumberFormatException e2) {
                // empty catch block
            }
            return this.spinner;
        }

        @Override
        public Object getCellEditorValue() {
            return new Integer(this.spinner.getValue());
        }
    }
}

