/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard.data;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.biomoby.service.dashboard.Dashboard;
import org.biomoby.service.dashboard.data.DataTypeModel;
import org.biomoby.service.dashboard.data.DataTypeNode;
import org.biomoby.service.dashboard.treetable.JTreeTable;
import org.biomoby.service.dashboard.treetable.TreeTableModelAdapter;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.Utils;
import org.biomoby.shared.datatypes.MobyObject;
import org.jdom.Document;
import org.jdom.Element;
import org.tulsoft.tools.gui.SwingUtils;

public class DataTypeTreeTable
extends JTreeTable {
    public static Icon tAreaIcon;
    public static Icon cloneIcon;
    public static Icon addIcon;
    public static Icon removeIcon;
    public static Icon xmlIcon;

    public DataTypeTreeTable(MobyDataType rootType, MobyDataType[] dataTypes) {
        super(new DataTypeModel(rootType, dataTypes));
        this.createItself();
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    protected void createItself() {
        this.loadIcons();
        this.getTableHeader().setReorderingAllowed(false);
        CommonRenderer commonRenderer = new CommonRenderer();
        this.getColumnModel().getColumn(6).setCellRenderer(commonRenderer);
        this.getColumnModel().getColumn(8).setCellRenderer(commonRenderer);
        CommonEditor commonEditor = new CommonEditor();
        this.getColumnModel().getColumn(6).setCellEditor(commonEditor);
        this.getColumnModel().getColumn(8).setCellEditor(commonEditor);
        this.setupButtonColumn(7, tAreaIcon, commonRenderer, commonEditor, true);
        this.setupButtonColumn(0, addIcon, commonRenderer, commonEditor, false);
        this.setupButtonColumn(1, cloneIcon, commonRenderer, commonEditor, false);
        this.setupButtonColumn(2, removeIcon, commonRenderer, commonEditor, false);
        TableColumn cdataColumn = this.getColumnModel().getColumn(8);
        if (xmlIcon != null) {
            cdataColumn.setMaxWidth(xmlIcon.getIconWidth() + 2);
        }
        cdataColumn.setHeaderRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return (JComponent)value;
            }
        });
        cdataColumn.setHeaderValue(new JButton("", xmlIcon));
        this.initColumnSizes();
    }

    protected void setupButtonColumn(int column, Icon icon, CommonRenderer commonRenderer, CommonEditor commonEditor, boolean fillHeader) {
        TableColumn buttonColumn = this.getColumnModel().getColumn(column);
        if (icon != null) {
            buttonColumn.setMaxWidth(icon.getIconWidth() + 2);
        }
        buttonColumn.setCellRenderer(commonRenderer);
        buttonColumn.setCellEditor(commonEditor);
        if (fillHeader) {
            buttonColumn.setHeaderRenderer(new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    return (JComponent)value;
                }
            });
            buttonColumn.setHeaderValue(new JButton("", icon));
        }
    }

    public Document getXMLDocument() {
        Element root = this.toXML();
        if (root == null) {
            return null;
        }
        return new Document(root);
    }

    public Element toXML() {
        return ((DataTypeNode)this.getInnerModel().getRoot()).toXML();
    }

    public void populateData(MobyObject mobyObject) {
        DataTypeNode node = (DataTypeNode)this.getInnerModel().getRoot();
        node.children = null;
        node.loadChildren();
        node.setId(mobyObject.getId());
        node.setNamespace(mobyObject.getNamespace());
        if (node.isPrimitive) {
            node.setValue(mobyObject.getValue());
        }
        if (!node.isPrimitive()) {
            this.populate_children(mobyObject, node);
        }
        this.updateUI();
    }

    private void populate_children(MobyObject mobyObject, DataTypeNode node) {
        if (node.children == null) {
            return;
        }
        for (DataTypeNode n : node.children) {
            String methodName = "getMoby_" + Utils.mobyEscape((String)Utils.javaEscape((String)Utils.checkOrCreateArticleName((String)n.getMemberName(), (String)mobyObject.getClass().getName())));
            try {
                Method method = mobyObject.getClass().getMethod(methodName, new Class[0]);
                Object o = method.invoke((Object)mobyObject, new Object[0]);
                if (o == null) continue;
                if (o.getClass().isArray()) {
                    if (!n.isHAS()) continue;
                    Object[] os = (Object[])o;
                    for (int x = 1; x < os.length; ++x) {
                        DataTypeNode newNode = DataTypeNode.createNode(n.getDataType(), n.getMemberName(), 3, n.getParentNode(), n.dtTable, n.model);
                        newNode.loadChildren();
                        newNode.setId(((MobyObject)os[x]).getId());
                        newNode.setNamespace(((MobyObject)os[x]).getNamespace());
                        if (newNode.isPrimitive) {
                            newNode.setValue(((MobyObject)os[x]).getValue());
                        }
                        n.getParentNode().addChild(newNode, n.getParentNode().getChildCount());
                        if (newNode.isPrimitive()) continue;
                        this.populate_children((MobyObject)os[x], newNode);
                    }
                    if (os.length <= 0) continue;
                    n.setId(((MobyObject)os[0]).getId());
                    n.setNamespace(((MobyObject)os[0]).getNamespace());
                    if (n.isPrimitive) {
                        n.setValue(((MobyObject)os[0]).getValue());
                    }
                    if (n.isPrimitive()) continue;
                    this.populate_children((MobyObject)os[0], n);
                    continue;
                }
                n.setId(((MobyObject)o).getId());
                n.setNamespace(((MobyObject)o).getNamespace());
                if (n.isPrimitive) {
                    n.setValue(((MobyObject)o).getValue());
                }
                if (n.isPrimitive()) continue;
                this.populate_children((MobyObject)o, n);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
    }

    protected void loadIcons() {
        if (tAreaIcon == null) {
            tAreaIcon = DataTypeTreeTable.loadIcon("images/smallMoreLines.gif");
        }
        if (cloneIcon == null) {
            cloneIcon = DataTypeTreeTable.loadIcon("images/smallClone.gif");
        }
        if (addIcon == null) {
            addIcon = DataTypeTreeTable.loadIcon("images/smallAdd.gif");
        }
        if (removeIcon == null) {
            removeIcon = DataTypeTreeTable.loadIcon("images/smallRemove.gif");
        }
        if (xmlIcon == null) {
            xmlIcon = DataTypeTreeTable.loadIcon("images/smallXML.gif");
        }
    }

    protected static Icon loadIcon(String path) {
        return SwingUtils.createIcon((String)path, Dashboard.class);
    }

    private void initColumnSizes() {
        TableModel model = this.getModel();
        TableColumn column = null;
        Component comp = null;
        int cellWidth = 0;
        int l = 0;
        Object[] longValues = new Object[]{"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", "xxxxxxx", "xxxxxxxxxxxx"};
        for (int i = 3; i < 6; ++i) {
            column = this.getColumnModel().getColumn(i);
            comp = this.getDefaultRenderer(model.getColumnClass(i)).getTableCellRendererComponent(this, longValues[l++], false, false, 0, i);
            cellWidth = comp.getPreferredSize().width;
            column.setPreferredWidth(cellWidth);
        }
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                return ((DataTypeModel)DataTypeTreeTable.this.getInnerModel()).getColumnToolTip(realIndex);
            }
        };
    }

    class CommonEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected TableCellEditor editor;

        CommonEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            DataTypeNode dtNode = (DataTypeNode)((TreeTableModelAdapter)table.getModel()).nodeForRow(row);
            switch (column) {
                case 6: {
                    this.editor = dtNode.getValueEditor(table);
                    if (value == null || value.toString().indexOf("\n") <= -1) break;
                    this.editor.stopCellEditing();
                    return null;
                }
                case 8: {
                    this.editor = dtNode.getCDATAEditor(table);
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 7: {
                    this.editor = dtNode.getButtonEditor(column);
                }
            }
            if (this.editor == null) {
                return null;
            }
            return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return this.editor.getCellEditorValue();
        }

        @Override
        public boolean stopCellEditing() {
            return this.editor.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            this.editor.cancelCellEditing();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.editor.addCellEditorListener(l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.editor.removeCellEditorListener(l);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return this.editor.shouldSelectCell(anEvent);
        }
    }

    class CommonRenderer
    extends DefaultTableCellRenderer {
        public CommonRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TableCellRenderer renderer = null;
            DataTypeNode dtNode = (DataTypeNode)((TreeTableModelAdapter)table.getModel()).nodeForRow(row);
            switch (column) {
                case 6: {
                    renderer = dtNode.getValueRenderer(table, value);
                    value = dtNode.fixValue(value);
                    break;
                }
                case 8: {
                    renderer = dtNode.getCDATARenderer(table);
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 7: {
                    renderer = dtNode.getButtonRenderer(column);
                }
            }
            if (renderer == null) {
                return null;
            }
            return renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

