/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard.data;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang.ArrayUtils;
import org.biomoby.service.dashboard.chooser.DateTimeChooserEditor;
import org.biomoby.service.dashboard.data.DataTypeModel;
import org.biomoby.service.dashboard.data.DataTypeTreeTable;
import org.biomoby.service.generator.DataTypesGenerator;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyRelationship;
import org.biomoby.shared.parser.MobyPackage;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;
import org.tulsoft.shared.UUtils;

public class DataTypeNode {
    MobyDataType dataType;
    int memberRel = -1;
    String memberName;
    DataTypeNode[] children = null;
    DataTypeNode parent;
    String id = "";
    String namespace = "";
    Object value;
    boolean isPrimitive = false;
    HashMap dtTable = new HashMap();
    DataTypeModel model;
    protected static TableCellRenderer defaultRenderer = new DefaultTableCellRenderer();
    protected TableCellRenderer renderer;
    protected TableCellEditor defaultEditor = new DefaultCellEditor(new JTextField());
    boolean storeValueAsCDATA = false;
    TableCellRenderer rendererCDATA;

    protected DataTypeNode() {
    }

    protected DataTypeNode(MobyDataType dataType, String memberName, int memberRel, DataTypeNode parent, HashMap dtTable, DataTypeModel model) {
        this.dataType = dataType;
        this.memberName = memberName;
        this.memberRel = memberRel;
        this.parent = parent;
        this.dtTable = dtTable;
        this.model = model;
        this.isPrimitive = DataTypesGenerator.isPrimitiveType((String)dataType.getName());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(100);
        if (this.memberRel < 0) {
            buf.append(this.dataType.getName());
        } else {
            buf.append("<html><b>");
            buf.append(this.memberRel == 3 ? "HAS" : "HASA");
            buf.append(": </b>");
            buf.append(this.dataType.getName());
            if (this.memberName != null) {
                buf.append(" (<font color='blue'>");
                buf.append(this.memberName);
                buf.append("</font>)");
            }
        }
        return buf.toString();
    }

    public Element toXML() {
        if (this.isPrimitive && (this.value == null || "".equals(this.value.toString()))) {
            return null;
        }
        Element elem = MobyPackage.getXMLElement((String)this.dataType.getName());
        MobyPackage.setXMLAttributeForced((Element)elem, (String)"id", (String)this.getId());
        MobyPackage.setXMLAttributeForced((Element)elem, (String)"namespace", (String)this.getNamespace());
        MobyPackage.setXMLAttribute((Element)elem, (String)"articleName", (String)this.getMemberName());
        if (this.value != null && !"".equals(this.value.toString())) {
            if (this.storeValueAsCDATA) {
                elem.addContent((Content)new CDATA(this.value.toString()));
            } else {
                elem.setText(this.value.toString());
            }
        }
        DataTypeNode[] ch = this.getChildren();
        for (int i = 0; i < ch.length; ++i) {
            Element childElem = ch[i].toXML();
            if (childElem == null) continue;
            elem.addContent((Content)childElem);
        }
        return elem;
    }

    public boolean isLeaf() {
        this.loadChildren();
        return this.isPrimitive || this.children.length == 0;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isString() {
        return false;
    }

    public boolean isHAS() {
        return this.memberRel == 3;
    }

    public DataTypeNode getParentNode() {
        return this.parent;
    }

    public MobyDataType getDataType() {
        return this.dataType;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String newValue) {
        this.id = newValue;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String newValue) {
        this.namespace = newValue;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object newValue) {
        this.value = newValue == null || "".equals(newValue.toString()) ? "" : newValue;
    }

    public TableCellRenderer getValueRenderer(JTable table, Object value) {
        return defaultRenderer;
    }

    public TableCellEditor getValueEditor(JTable table) {
        return this.defaultEditor;
    }

    public Object fixValue(Object value) {
        this.setValue(value);
        return this.getValue();
    }

    public void setCDATAFlag(Object value) {
        this.storeValueAsCDATA = "".equals(value.toString()) ? false : (value instanceof Boolean ? (Boolean)value : UUtils.is((String)value.toString()));
    }

    public Object getCDATAFlag() {
        return "";
    }

    public TableCellRenderer getCDATARenderer(JTable table) {
        return defaultRenderer;
    }

    public TableCellEditor getCDATAEditor(JTable table) {
        return this.defaultEditor;
    }

    public TableCellRenderer getButtonRenderer(int column) {
        if (this.isHAS()) {
            switch (column) {
                case 0: {
                    return new AddButtonRenderer();
                }
                case 1: {
                    return new CloneButtonRenderer();
                }
                case 2: {
                    return new RemoveButtonRenderer();
                }
            }
            return defaultRenderer;
        }
        return defaultRenderer;
    }

    public TableCellEditor getButtonEditor(int column) {
        if (this.isHAS()) {
            switch (column) {
                case 0: {
                    return new AddButtonEditor();
                }
                case 1: {
                    return new CloneButtonEditor();
                }
                case 2: {
                    return new RemoveButtonEditor();
                }
            }
            return this.defaultEditor;
        }
        return this.defaultEditor;
    }

    protected synchronized void loadChildren() {
        if (this.children != null) {
            return;
        }
        Vector v = new Vector();
        MobyDataType currentType = this.dataType;
        this.addChildren(v, currentType);
        String parentName = currentType.getParentName();
        while (!"".equals(parentName) && (currentType = (MobyDataType)this.dtTable.get(parentName)) != null) {
            this.addChildren(v, currentType);
            parentName = currentType.getParentName();
        }
        this.children = new DataTypeNode[v.size()];
        v.copyInto(this.children);
    }

    protected void addChildren(Vector v, MobyDataType dataType) {
        MobyRelationship[] chils = dataType.getChildren();
        for (int i = 0; i < chils.length; ++i) {
            MobyDataType type = (MobyDataType)this.dtTable.get(chils[i].getDataTypeName());
            if (type == null) continue;
            v.addElement(DataTypeNode.createNode(type, chils[i].getName(), chils[i].getRelationshipType(), this, this.dtTable, this.model));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int indexOfChild(DataTypeNode childNode) {
        this.loadChildren();
        DataTypeNode[] dataTypeNodeArray = this.children;
        synchronized (this.children) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ArrayUtils.indexOf((Object[])this.children, (Object)childNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChild(DataTypeNode childNode, int index) {
        this.loadChildren();
        DataTypeNode[] dataTypeNodeArray = this.children;
        synchronized (this.children) {
            this.children = (DataTypeNode[])ArrayUtils.add((Object[])this.children, (int)index, (Object)childNode);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeChild(DataTypeNode childNode) {
        this.loadChildren();
        DataTypeNode[] dataTypeNodeArray = this.children;
        synchronized (this.children) {
            this.children = (DataTypeNode[])ArrayUtils.removeElement((Object[])this.children, (Object)childNode);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DataTypeNode cloneNode() {
        DataTypeNode cloned = DataTypeNode.createNode(this.dataType, this.memberName, this.memberRel, this.parent, this.dtTable, this.model);
        cloned.id = this.id;
        cloned.namespace = this.namespace;
        cloned.value = this.value;
        cloned.storeValueAsCDATA = this.storeValueAsCDATA;
        if (this.children == null) return cloned;
        DataTypeNode[] dataTypeNodeArray = this.children;
        synchronized (this.children) {
            cloned.children = new DataTypeNode[this.children.length];
            for (int i = 0; i < this.children.length; ++i) {
                cloned.children[i] = this.children[i].cloneNode();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return cloned;
        }
    }

    protected DataTypeNode[] getPathToRoot(DataTypeNode aNode, int depth) {
        DataTypeNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new DataTypeNode[depth];
        } else {
            retNodes = this.getPathToRoot(aNode.getParentNode(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    public static DataTypeNode createNode(MobyDataType dataType, String memberName, int memberRel, DataTypeNode parent, HashMap dtTable, DataTypeModel model) {
        String dtName = dataType.getName();
        if (dtName.equals("String")) {
            DataTypeNode dataTypeNode = new DataTypeNode();
            dataTypeNode.getClass();
            return dataTypeNode.new DataTypeNodeForString(dataType, memberName, memberRel, parent, dtTable, model);
        }
        if (dtName.equals("Boolean")) {
            DataTypeNode dataTypeNode = new DataTypeNode();
            dataTypeNode.getClass();
            return dataTypeNode.new DataTypeNodeForBoolean(dataType, memberName, memberRel, parent, dtTable, model);
        }
        if (dtName.equals("Integer")) {
            DataTypeNode dataTypeNode = new DataTypeNode();
            dataTypeNode.getClass();
            return dataTypeNode.new DataTypeNodeForInteger(dataType, memberName, memberRel, parent, dtTable, model);
        }
        if (dtName.equals("Float")) {
            DataTypeNode dataTypeNode = new DataTypeNode();
            dataTypeNode.getClass();
            return dataTypeNode.new DataTypeNodeForFloat(dataType, memberName, memberRel, parent, dtTable, model);
        }
        if (dtName.equals("DateTime")) {
            DataTypeNode dataTypeNode = new DataTypeNode();
            dataTypeNode.getClass();
            return dataTypeNode.new DataTypeNodeForDateTime(dataType, memberName, memberRel, parent, dtTable, model);
        }
        return new DataTypeNode(dataType, memberName, memberRel, parent, dtTable, model);
    }

    public int getChildCount() {
        this.loadChildren();
        return this.children.length;
    }

    public Object getChild(int i) {
        this.loadChildren();
        try {
            return this.children[i];
        }
        catch (Exception e) {
            return null;
        }
    }

    public DataTypeNode[] getChildren() {
        this.loadChildren();
        return this.children;
    }

    class DataTypeNodeForDateTime
    extends DataTypeNode {
        public DataTypeNodeForDateTime(MobyDataType dataType, String memberName, int memberRel, DataTypeNode parent, HashMap dtTable, DataTypeModel model) {
            super(dataType, memberName, memberRel, parent, dtTable, model);
        }

        @Override
        public TableCellEditor getValueEditor(JTable table) {
            return new DateTimeChooserEditor();
        }
    }

    class DataTypeNodeForFloat
    extends DataTypeNode {
        public DataTypeNodeForFloat(MobyDataType dataType, String memberName, int memberRel, DataTypeNode parent, HashMap dtTable, DataTypeModel model) {
            super(dataType, memberName, memberRel, parent, dtTable, model);
        }

        @Override
        public TableCellRenderer getValueRenderer(JTable table, Object value) {
            if (value == null || "".equals(value.toString())) {
                return defaultRenderer;
            }
            if (this.renderer == null) {
                this.renderer = table.getDefaultRenderer(Double.class);
            }
            return this.renderer;
        }

        @Override
        public TableCellEditor getValueEditor(JTable table) {
            return table.getDefaultEditor(Double.class);
        }

        @Override
        public void setValue(Object newValue) {
            if (newValue == null) {
                this.value = "";
            } else if (newValue instanceof Double) {
                this.value = newValue;
            } else {
                try {
                    this.value = new Double(newValue.toString());
                }
                catch (NumberFormatException e) {
                    this.value = "";
                }
            }
        }
    }

    class DataTypeNodeForInteger
    extends DataTypeNode {
        public DataTypeNodeForInteger(MobyDataType dataType, String memberName, int memberRel, DataTypeNode parent, HashMap dtTable, DataTypeModel model) {
            super(dataType, memberName, memberRel, parent, dtTable, model);
        }

        @Override
        public TableCellRenderer getValueRenderer(JTable table, Object value) {
            if (value == null || "".equals(value.toString())) {
                return defaultRenderer;
            }
            if (this.renderer == null) {
                this.renderer = table.getDefaultRenderer(Integer.class);
            }
            return this.renderer;
        }

        @Override
        public TableCellEditor getValueEditor(JTable table) {
            return table.getDefaultEditor(Integer.class);
        }

        @Override
        public void setValue(Object newValue) {
            if (newValue == null) {
                this.value = "";
            } else if (newValue instanceof Integer) {
                this.value = newValue;
            } else {
                try {
                    this.value = new Integer(newValue.toString());
                }
                catch (NumberFormatException e) {
                    this.value = "";
                }
            }
        }
    }

    class DataTypeNodeForBoolean
    extends DataTypeNode {
        public DataTypeNodeForBoolean(MobyDataType dataType, String memberName, int memberRel, DataTypeNode parent, HashMap dtTable, DataTypeModel model) {
            super(dataType, memberName, memberRel, parent, dtTable, model);
        }

        @Override
        public TableCellRenderer getValueRenderer(JTable table, Object value) {
            if (this.renderer == null) {
                this.renderer = table.getDefaultRenderer(Boolean.class);
            }
            return this.renderer;
        }

        @Override
        public TableCellEditor getValueEditor(JTable table) {
            return table.getDefaultEditor(Boolean.class);
        }

        @Override
        public void setValue(Object newValue) {
            this.value = newValue == null || "".equals(newValue.toString()) ? new Boolean(false) : (newValue instanceof Boolean ? newValue : new Boolean(UUtils.is((String)newValue.toString())));
        }
    }

    class DataTypeNodeForString
    extends DataTypeNode {
        public DataTypeNodeForString(MobyDataType dataType, String memberName, int memberRel, DataTypeNode parent, HashMap dtTable, DataTypeModel model) {
            super(dataType, memberName, memberRel, parent, dtTable, model);
        }

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public TableCellRenderer getCDATARenderer(JTable table) {
            if (this.rendererCDATA == null) {
                this.rendererCDATA = table.getDefaultRenderer(Boolean.class);
            }
            return this.rendererCDATA;
        }

        @Override
        public TableCellEditor getCDATAEditor(JTable table) {
            return table.getDefaultEditor(Boolean.class);
        }

        @Override
        public Object getCDATAFlag() {
            return new Boolean(this.storeValueAsCDATA);
        }

        @Override
        public TableCellRenderer getButtonRenderer(int column) {
            if (column == 7) {
                return new MoreLinesButtonRenderer();
            }
            return super.getButtonRenderer(column);
        }

        @Override
        public TableCellEditor getButtonEditor(int column) {
            if (column == 7) {
                return new MoreLinesButtonEditor();
            }
            return super.getButtonEditor(column);
        }
    }

    class RemoveButtonEditor
    extends ColumnButtonEditor {
        RemoveButtonEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return new RemoveButton(this);
        }
    }

    class CloneButtonEditor
    extends ColumnButtonEditor {
        CloneButtonEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return new CloneButton(this);
        }
    }

    class AddButtonEditor
    extends ColumnButtonEditor {
        AddButtonEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return new AddButton(this);
        }
    }

    class MoreLinesButtonEditor
    extends ColumnButtonEditor {
        MoreLinesButtonEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return new MoreLinesButton(this);
        }
    }

    abstract class ColumnButtonEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        ColumnButtonEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }

    class RemoveButtonRenderer
    extends RemoveButton
    implements TableCellRenderer {
        public RemoveButtonRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this;
        }
    }

    class CloneButtonRenderer
    extends CloneButton
    implements TableCellRenderer {
        public CloneButtonRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this;
        }
    }

    class AddButtonRenderer
    extends AddButton
    implements TableCellRenderer {
        public AddButtonRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this;
        }
    }

    class MoreLinesButtonRenderer
    extends MoreLinesButton
    implements TableCellRenderer {
        public MoreLinesButtonRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this;
        }
    }

    class RemoveButton
    extends ColumnButton {
        public RemoveButton() {
            this(null);
        }

        public RemoveButton(AbstractCellEditor editor) {
            super(editor);
            this.setIcon(DataTypeTreeTable.removeIcon);
            this.setToolTipText("Click here to remove this HAS member (unless it is the last one)");
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataTypeNode.this.getParentNode().removeChild(DataTypeNode.this);
                    DataTypeNode.this.model.fireTreeStructureChanged(DataTypeNode.this, DataTypeNode.this.getPathToRoot(DataTypeNode.this.getParentNode(), 0), null, null);
                    RemoveButton.this.editor.stopCellEditing();
                }
            });
        }
    }

    class CloneButton
    extends ColumnButton {
        public CloneButton() {
            this(null);
        }

        public CloneButton(AbstractCellEditor editor) {
            super(editor);
            this.setIcon(DataTypeTreeTable.cloneIcon);
            this.setToolTipText("Click to add a new HAS member by duplicating the one from this row");
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataTypeNode.this.parent.addChild(DataTypeNode.this.cloneNode(), DataTypeNode.this.parent.indexOfChild(DataTypeNode.this) + 1);
                    Object[] path = DataTypeNode.this.getPathToRoot(DataTypeNode.this.getParentNode(), 0);
                    DataTypeNode.this.model.fireTreeStructureChanged(DataTypeNode.this, path, null, null);
                    CloneButton.this.editor.stopCellEditing();
                }
            });
        }
    }

    class AddButton
    extends ColumnButton {
        public AddButton() {
            this(null);
        }

        public AddButton(AbstractCellEditor editor) {
            super(editor);
            this.setIcon(DataTypeTreeTable.addIcon);
            this.setToolTipText("Click to add a new empty HAS member");
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataTypeNode.this.parent.addChild(DataTypeNode.createNode(DataTypeNode.this.dataType, DataTypeNode.this.memberName, DataTypeNode.this.memberRel, DataTypeNode.this.parent, DataTypeNode.this.dtTable, DataTypeNode.this.model), DataTypeNode.this.parent.indexOfChild(DataTypeNode.this) + 1);
                    Object[] path = DataTypeNode.this.getPathToRoot(DataTypeNode.this.getParentNode(), 0);
                    DataTypeNode.this.model.fireTreeStructureChanged(DataTypeNode.this, path, null, null);
                    AddButton.this.editor.stopCellEditing();
                }
            });
        }
    }

    class MoreLinesButton
    extends ColumnButton {
        JTextArea editArea;
        JPanel editPanel;
        String[] buttons;

        public MoreLinesButton() {
            this(null);
        }

        public MoreLinesButton(AbstractCellEditor editor) {
            super(editor);
            this.setIcon(DataTypeTreeTable.tAreaIcon);
            this.setToolTipText("Click here to enter a value containing more lines");
            if (editor != null) {
                this.editArea = new JTextArea(10, 40);
                this.editPanel = new JPanel();
                this.editPanel.add(new JScrollPane(this.editArea));
                this.buttons = new String[]{"Done", "Clear", "Cancel"};
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Object currentValue = DataTypeNode.this.getValue();
                        if (currentValue != null) {
                            MoreLinesButton.this.editArea.setText(currentValue.toString());
                        }
                        int selected = JOptionPane.showOptionDialog(MoreLinesButton.this, MoreLinesButton.this.editPanel, "Enter/Edit multi-line data...", 0, -1, null, MoreLinesButton.this.buttons, null);
                        String newValue = null;
                        if (selected == 0) {
                            newValue = MoreLinesButton.this.editArea.getText();
                        } else if (selected == 1) {
                            newValue = "";
                        }
                        if (newValue != null) {
                            DataTypeNode.this.setValue(newValue);
                            Object[] path = DataTypeNode.this.getPathToRoot(DataTypeNode.this.getParentNode(), 0);
                            if (path != null) {
                                DataTypeNode.this.model.fireTreeStructureChanged(DataTypeNode.this, path, null, null);
                            }
                        }
                        MoreLinesButton.this.editor.stopCellEditing();
                    }
                });
            }
        }
    }

    class ColumnButton
    extends JButton {
        protected AbstractCellEditor editor;

        public ColumnButton(AbstractCellEditor editor) {
            this.setText("");
            this.setFocusPainted(false);
            this.editor = editor;
        }
    }
}

