/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard.data;

import java.util.HashMap;
import org.biomoby.service.dashboard.data.DataTypeNode;
import org.biomoby.service.dashboard.treetable.AbstractTreeTableModel;
import org.biomoby.service.dashboard.treetable.TreeTableModel;
import org.biomoby.shared.MobyDataType;

public class DataTypeModel
extends AbstractTreeTableModel {
    public static final int COLUMN_ADD = 0;
    public static final int COLUMN_CLONE = 1;
    public static final int COLUMN_REMOVE = 2;
    public static final int COLUMN_TREE = 3;
    public static final int COLUMN_ID = 4;
    public static final int COLUMN_NS = 5;
    public static final int COLUMN_VALUE = 6;
    public static final int COLUMN_TAREA = 7;
    public static final int COLUMN_CDATA = 8;
    protected static String[] cNames = new String[]{"", "", "", "Data type", "Id", "Namespace", "Value", "", "XML"};
    protected static Class[] cTypes = new Class[]{String.class, String.class, String.class, TreeTableModel.class, String.class, String.class, String.class, String.class, String.class};
    protected static String[] cToolTips = new String[]{"Click to add a new empty HAS member", "Click to add a new HAS member by duplicating an existing one", "Click to remove a HAS member", "A tree representing a Biomoby data type", "Biomoby identifier can be assigned to every level of a data type", "Biomoby namespace can be assigned to every level of a data type", "Only primitive data types can carry a value - enter it", "Allow entering multiple lines into the value field", "Check the box if you wish to create value wrapped as a CDATA XML element"};
    HashMap dtTable = new HashMap();
    MobyDataType rootType;

    public DataTypeModel(MobyDataType rootType, MobyDataType[] dataTypes) {
        super(null);
        this.rootType = rootType;
        for (int i = 0; i < dataTypes.length; ++i) {
            this.dtTable.put(dataTypes[i].getName(), dataTypes[i]);
        }
    }

    public String getColumnToolTip(int column) {
        return cToolTips[column];
    }

    @Override
    public void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        super.fireTreeStructureChanged(source, path, childIndices, children);
    }

    @Override
    public void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        super.fireTreeNodesRemoved(source, path, childIndices, children);
    }

    @Override
    public Object getRoot() {
        if (this.root == null) {
            this.root = DataTypeNode.createNode(this.rootType, null, -1, null, this.dtTable, this);
        }
        return this.root;
    }

    @Override
    public int getChildCount(Object node) {
        return ((DataTypeNode)node).getChildCount();
    }

    @Override
    public Object getChild(Object node, int i) {
        return ((DataTypeNode)node).getChild(i);
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((DataTypeNode)node).isLeaf();
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        switch (column) {
            case 0: {
                return ((DataTypeNode)node).isHAS();
            }
            case 1: {
                return ((DataTypeNode)node).isHAS();
            }
            case 2: {
                return ((DataTypeNode)node).isHAS();
            }
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
            case 6: {
                return ((DataTypeNode)node).isPrimitive();
            }
            case 7: {
                return ((DataTypeNode)node).isString();
            }
            case 8: {
                return ((DataTypeNode)node).isString();
            }
        }
        return false;
    }

    @Override
    public int getColumnCount() {
        return cNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return cNames[column];
    }

    @Override
    public Class getColumnClass(int column) {
        return cTypes[column];
    }

    @Override
    public Object getValueAt(Object node, int column) {
        DataTypeNode dtNode = (DataTypeNode)node;
        try {
            switch (column) {
                case 3: {
                    return dtNode.toString();
                }
                case 4: {
                    return dtNode.getId();
                }
                case 5: {
                    return dtNode.getNamespace();
                }
                case 6: {
                    return dtNode.getValue() == null ? "" : dtNode.getValue();
                }
                case 8: {
                    return dtNode.getCDATAFlag();
                }
            }
        }
        catch (Exception se) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, Object node, int column) {
        if (aValue == null) {
            return;
        }
        DataTypeNode dtNode = (DataTypeNode)node;
        String newValue = aValue.toString();
        try {
            switch (column) {
                case 3: {
                    return;
                }
                case 4: {
                    dtNode.setId(newValue);
                    return;
                }
                case 5: {
                    dtNode.setNamespace(newValue);
                    return;
                }
                case 6: {
                    dtNode.setValue(newValue);
                    return;
                }
                case 8: {
                    dtNode.setCDATAFlag(newValue);
                    return;
                }
            }
        }
        catch (Exception se) {
            // empty catch block
        }
    }
}

