/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard.chooser;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.biomoby.service.dashboard.chooser.DateTimeChooser;
import org.biomoby.shared.datatypes.MobyDateTime;

public class DateTimeChooserEditor
extends AbstractCellEditor
implements TableCellEditor {
    private JButton delegate = new JButton();

    public DateTimeChooserEditor() {
        this.delegate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Date initialDate = null;
                try {
                    String value = (String)DateTimeChooserEditor.this.getCellEditorValue();
                    initialDate = DateUtils.parseDate((String)value, (String[])MobyDateTime.ALLOWED_FORMATS);
                }
                catch (Exception e) {
                    // empty catch block
                }
                DateTimeChooser chooser = new DateTimeChooser(initialDate);
                chooser.setPreviewPanel(new PreviewPanel(chooser));
                Date date = DateTimeChooser.showDialog((Component)DateTimeChooserEditor.this.delegate, "Date-Time Chooser", chooser);
                if (date == null) {
                    DateTimeChooserEditor.this.delegate.setText("");
                } else {
                    DateTimeChooserEditor.this.delegate.setText(DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd'T'HH:mm:ssZ"));
                }
                DateTimeChooserEditor.this.fireEditingStopped();
            }
        });
    }

    @Override
    public Object getCellEditorValue() {
        return this.delegate.getText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value == null) {
            this.delegate.setText("");
        } else {
            this.delegate.setText(value.toString());
        }
        return this.delegate;
    }

    class PreviewPanel
    extends JPanel
    implements ChangeListener {
        private JLabel preview = new JLabel("");
        private DateTimeChooser chooser;

        public PreviewPanel(DateTimeChooser chooser) {
            this.chooser = chooser;
            this.preview.setText(this.formatDate());
            chooser.addChangeListener(this);
            this.add(this.preview);
        }

        protected String formatDate() {
            Date date = this.chooser.getDate();
            return DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd'T'HH:mm:ssZ");
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            this.preview.setText(this.formatDate());
        }
    }
}

