/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard.chooser;

import com.toedter.calendar.JCalendar;
import com.toedter.components.JSpinField;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.tulsoft.tools.gui.SwingUtils;

public class DateTimeChooser
extends JPanel
implements PropertyChangeListener {
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList lList = new EventListenerList();
    protected Date initialDate = null;
    protected JCalendar calendar;
    protected JSpinField hours;
    protected JSpinField mins;
    protected JSpinField secs;
    protected JPanel previewPanel;
    protected static final Insets BREATH_BOTTOM = new Insets(0, 0, 10, 0);

    public DateTimeChooser() {
        this((Date)null);
    }

    public DateTimeChooser(Date initialDate) {
        this.initialDate = initialDate;
        this.createItself();
    }

    protected void createItself() {
        this.setLayout(new GridBagLayout());
        JButton now = new JButton("Set to now");
        now.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateTimeChooser.this.setDate(new Date());
            }
        });
        JButton zero = new JButton("Clear time");
        zero.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateTimeChooser.this.hours.setValue(0);
                DateTimeChooser.this.mins.setValue(0);
                DateTimeChooser.this.secs.setValue(0);
            }
        });
        JPanel buttons = new JPanel();
        buttons.add(now);
        buttons.add(zero);
        this.calendar = new JCalendar();
        this.calendar.setWeekOfYearVisible(false);
        this.calendar.addPropertyChangeListener((PropertyChangeListener)this);
        this.calendar.getYearChooser().addPropertyChangeListener((PropertyChangeListener)this);
        JLabel hoursLabel = new JLabel("Hours: ");
        this.hours = new JSpinField(0, 23);
        this.hours.adjustWidthToMaximumValue();
        this.hours.addPropertyChangeListener((PropertyChangeListener)this);
        JLabel minsLabel = new JLabel(" Mins: ");
        this.mins = new JSpinField(0, 59);
        this.mins.adjustWidthToMaximumValue();
        this.mins.addPropertyChangeListener((PropertyChangeListener)this);
        JLabel secsLabel = new JLabel(" Secs: ");
        this.secs = new JSpinField(0, 59);
        this.secs.adjustWidthToMaximumValue();
        this.secs.addPropertyChangeListener((PropertyChangeListener)this);
        this.setDate(this.initialDate == null ? new Date() : this.initialDate);
        SwingUtils.addComponent((JComponent)this, (Component)this.calendar, (int)0, (int)0, (int)6, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)this, (Component)hoursLabel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_BOTTOM);
        SwingUtils.addComponent((JComponent)this, (Component)this.hours, (int)1, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_BOTTOM);
        SwingUtils.addComponent((JComponent)this, (Component)minsLabel, (int)2, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_BOTTOM);
        SwingUtils.addComponent((JComponent)this, (Component)this.mins, (int)3, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_BOTTOM);
        SwingUtils.addComponent((JComponent)this, (Component)secsLabel, (int)4, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_BOTTOM);
        SwingUtils.addComponent((JComponent)this, (Component)this.secs, (int)5, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_BOTTOM);
        SwingUtils.addComponent((JComponent)this, (Component)buttons, (int)0, (int)2, (int)6, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (Insets)BREATH_BOTTOM);
    }

    public Date getDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.calendar.getDate());
        cal.set(11, this.hours.getValue());
        cal.set(12, this.mins.getValue());
        cal.set(13, this.secs.getValue());
        return cal.getTime();
    }

    public void setDate(Date newDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(newDate);
        this.calendar.setDate(newDate);
        this.hours.setValue(cal.get(11));
        this.mins.setValue(cal.get(12));
        this.secs.setValue(cal.get(13));
    }

    public Date getInitialDate() {
        return this.initialDate;
    }

    public JPanel getPreviewPanel() {
        return this.previewPanel;
    }

    public void setPreviewPanel(JPanel preview) {
        if (this.previewPanel != null) {
            this.remove(this.previewPanel);
        }
        this.previewPanel = preview;
        if (this.previewPanel != null) {
            SwingUtils.addComponent((JComponent)this, (Component)this.previewPanel, (int)0, (int)10, (int)10, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        }
    }

    public static Date showDialog(Component parent, String title, Date initialDate) {
        return DateTimeChooser.showDialog(parent, title, new DateTimeChooser(initialDate));
    }

    public static Date showDialog(Component parent, String title, DateTimeChooser chooser) {
        Object[] buttons = new String[]{"OK", "Empty", "Cancel"};
        int selected = JOptionPane.showOptionDialog(parent, chooser, title, 0, -1, null, buttons, null);
        if (selected == 0) {
            return chooser.getDate();
        }
        if (selected == 1) {
            return null;
        }
        return chooser.getInitialDate();
    }

    public void addChangeListener(ChangeListener listener) {
        this.lList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.lList.remove(ChangeListener.class, listener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.lList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.lList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fireStateChanged();
    }
}

