/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biomoby.service.dashboard.AbstractPanel;
import org.biomoby.service.dashboard.PropertyChannel;
import org.biomoby.service.dashboard.RegistryModel;
import org.biomoby.service.dashboard.SwingWorker;
import org.biomoby.service.dashboard.TableSorter;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyPrimaryData;
import org.biomoby.shared.MobyPrimaryDataSet;
import org.biomoby.shared.MobySecondaryData;
import org.biomoby.shared.MobyService;
import org.biomoby.shared.event.NotificationEvent;
import org.biomoby.shared.event.NotificationListener;
import org.tulsoft.tools.gui.SwingUtils;

public class StatisticsPanel
extends AbstractPanel
implements NotificationListener {
    private static Log log = LogFactory.getLog(StatisticsPanel.class);
    protected static final String SERVICES_ACCESS_ERROR = "An error happened when accessing a list of available services.\n\n";
    protected static final int S_NUMBER_OF_COLS = 8;
    protected static final int S_COL_AUTHORITY = 0;
    protected static final int S_COL_SERVICE_NAME = 1;
    protected static final int S_COL_COUNT_PRIM_INP = 2;
    protected static final int S_COL_COUNT_SEC_INP = 3;
    protected static final int S_COL_PARAM_TYPES = 4;
    protected static final int S_COL_COUNT_OUT = 5;
    protected static final int S_COL_IS_INP_COLL = 6;
    protected static final int S_COL_IS_OUT_COLL = 7;
    RegistryModel registryModel;
    JTable table;
    ServiceStatisticsModel ssModel;

    public StatisticsPanel() {
        this.panelIconFileName = "images/smallStat.gif";
    }

    @Override
    public JComponent getComponent(PropertyChannel aPropertyChannel) {
        this.setPropertyChannel(aPropertyChannel);
        this.registryModel = this.createRegistryModel();
        this.registryModel.addNotificationListener(this);
        if (this.pComponent != null) {
            return this.pComponent;
        }
        this.pComponent = new JPanel(new GridBagLayout(), true);
        this.ssModel = new ServiceStatisticsModel();
        TableSorter sorter = new TableSorter(this.ssModel);
        this.table = new JTable(sorter){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int modelIndex = this.columnModel.getColumn(index).getModelIndex();
                        return ((ServiceStatisticsModel)((TableSorter)this.table.getModel()).getTableModel()).getColumnToolTip(modelIndex);
                    }
                };
            }
        };
        sorter.setTableHeader(this.table.getTableHeader());
        this.table.setShowHorizontalLines(false);
        this.updateServiceStatistics(null);
        JScrollPane scroll = new JScrollPane(this.table);
        SwingUtils.addComponent((JComponent)this.pComponent, (Component)scroll, (int)0, (int)0, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        return this.pComponent;
    }

    @Override
    public String getName() {
        return "Registry Statistics";
    }

    @Override
    public String getDescription() {
        return "A panel showing some basic statistics about the contents of a Biomoby registry.";
    }

    @Override
    public boolean loadOnlyOnDemand() {
        return true;
    }

    public void notified(NotificationEvent event) {
        switch (event.getType()) {
            case 15: 
            case 23: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)event.toString());
                }
                this.ssModel.setData(new Object[][]{{"Loading...", "", new Integer(0), new Integer(0), "", new Integer(0), "", ""}});
                this.ssModel.fireTableDataChanged();
                break;
            }
            case 31: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)event.toString());
                }
                MobyService[] updatedServices = (MobyService[])event.getDetails();
                this.updateServiceStatistics(updatedServices);
            }
        }
    }

    private void initColumnSizes(JTable table) {
        ServiceStatisticsModel model = (ServiceStatisticsModel)((TableSorter)table.getModel()).getTableModel();
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int cellWidth = 0;
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            column = table.getColumnModel().getColumn(i);
            comp = headerRenderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, 0, 0);
            headerWidth = comp.getPreferredSize().width;
            comp = table.getDefaultRenderer(model.getColumnClass(i)).getTableCellRendererComponent(table, model.getLongValue(i), false, false, 0, i);
            cellWidth = comp.getPreferredSize().width;
            column.setPreferredWidth(Math.max(headerWidth, cellWidth));
        }
    }

    protected synchronized void updateServiceStatistics(final MobyService[] newServices) {
        SwingWorker worker = new SwingWorker(){
            MobyException exception = null;
            Object[][] rows = null;

            @Override
            public Object construct() {
                try {
                    MobyService[] services = newServices == null ? StatisticsPanel.this.registryModel.getServices(StatisticsPanel.this) : newServices;
                    this.rows = new Object[services.length][8];
                    for (int i = 0; i < services.length; ++i) {
                        int j;
                        MobyService service = services[i];
                        this.rows[i][0] = service.getAuthority();
                        this.rows[i][1] = service.getName();
                        MobyPrimaryData[] pInputs = service.getPrimaryInputs();
                        MobySecondaryData[] sInputs = service.getSecondaryInputs();
                        MobyPrimaryData[] outputs = service.getPrimaryOutputs();
                        this.rows[i][2] = new Integer(pInputs.length);
                        this.rows[i][3] = new Integer(sInputs.length);
                        StringBuffer buf = new StringBuffer();
                        HashSet<String> set = new HashSet<String>();
                        for (int j2 = 0; j2 < sInputs.length; ++j2) {
                            String abbrev = sInputs[j2].getDataType().substring(0, 1);
                            if (set.contains(abbrev)) continue;
                            buf.append(abbrev);
                            set.add(abbrev);
                        }
                        this.rows[i][4] = buf.toString();
                        this.rows[i][5] = new Integer(outputs.length);
                        boolean found = false;
                        for (j = 0; j < pInputs.length; ++j) {
                            if (!(pInputs[j] instanceof MobyPrimaryDataSet)) continue;
                            found = true;
                            break;
                        }
                        this.rows[i][6] = found ? " yes " : "";
                        found = false;
                        for (j = 0; j < outputs.length; ++j) {
                            if (!(outputs[j] instanceof MobyPrimaryDataSet)) continue;
                            found = true;
                            break;
                        }
                        this.rows[i][7] = found ? " yes " : "";
                    }
                }
                catch (MobyException e) {
                    this.exception = e;
                }
                return this.rows;
            }

            @Override
            public void finished() {
                if (this.exception != null) {
                    AbstractPanel.error(StatisticsPanel.SERVICES_ACCESS_ERROR, (Exception)((Object)this.exception));
                    StatisticsPanel.this.ssModel.setData(new Object[0][]);
                } else {
                    StatisticsPanel.this.ssModel.setData(this.rows);
                }
                StatisticsPanel.this.initColumnSizes(StatisticsPanel.this.table);
                StatisticsPanel.this.ssModel.fireTableDataChanged();
            }
        };
        worker.start();
    }

    class ServiceStatisticsModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"Authority", "Service name", "# Prims", "# Secs", "Params", "# Outs", "Inp Coll", "Out Coll"};
        private String[] cToolTips = new String[]{"Service authority", "Service name", "Number of primary inputs", "Maximum number of secondary inputs (parameters)", "Types of parameters (S=String, I=Integer, F=Float, B=Boolean, D=DateTime)", "Number of outputs", "Is any of the primary inputs of this service a collection?", "Is any of the outputs of this service a collection?"};
        private Object[] longValues = new Object[]{"xxxxxxxxxxxxxxxxxxxxx", "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", new Integer(1), new Integer(1), "XXXXX", new Integer(1), "  xxx  ", "  xxx  "};
        private Object[][] data = new Object[0][];

        ServiceStatisticsModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            try {
                return this.data[row][col];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public String getColumnToolTip(int column) {
            return this.cToolTips[column];
        }

        public Object getLongValue(int column) {
            return this.longValues[column];
        }

        protected void setData(Object[][] data) {
            this.data = data;
        }
    }
}

