/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biomoby.service.dashboard.AbstractPanel;
import org.biomoby.service.dashboard.CommonConsole;
import org.biomoby.service.dashboard.CommonNode;
import org.biomoby.service.dashboard.DashboardConfig;
import org.biomoby.service.dashboard.GraphColours;
import org.biomoby.service.dashboard.PropertyChannel;
import org.biomoby.service.dashboard.RegistryModel;
import org.biomoby.service.dashboard.ResultsPanel;
import org.biomoby.service.dashboard.ServiceCallerModel;
import org.biomoby.service.dashboard.ServicesBoard;
import org.biomoby.service.dashboard.ServicesTree;
import org.biomoby.service.dashboard.SwingWorker;
import org.biomoby.service.dashboard.data.DataContainer;
import org.biomoby.service.dashboard.data.ServiceInputPanel;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyService;
import org.tulsoft.shared.UUtils;
import org.tulsoft.tools.gui.AwtUtils;
import org.tulsoft.tools.gui.JFileChooserWithHistory;
import org.tulsoft.tools.gui.JTextFieldWithHistory;
import org.tulsoft.tools.gui.SwingUtils;

public class SimpleClientPanel
extends AbstractPanel {
    private static Log log = LogFactory.getLog(SimpleClientPanel.class);
    protected static final String P_S_TITLE_COLOR = "simpleclient.service.title.color";
    protected static final String P_S_EDIT_BGCOLOR = "simpleclient.service.edit.bgcolor";
    protected static final String INIT_SELECT = "<html><center><font color='red'>Start by selecting a service<br>that you wish to call.</font></center>";
    protected static final String CALLER_ERROR = "Sorry, an error happened when calling a service.\n\n";
    protected static final Insets BREATH_UP = new Insets(6, 6, 0, 6);
    protected static final Insets BREATH_DOWN = new Insets(0, 6, 6, 6);
    RegistryModel registryModel;
    ServiceCallerModel callerModel;
    JLabel selService;
    CommonConsole input;
    JFileChooserWithHistory outFile;
    JFileChooserWithHistory inFile;
    JButton runButton;
    JButton stopButton;
    JCheckBox iShowXML;
    JCheckBox iFromFile;
    JTextFieldWithHistory className;
    JTextFieldWithHistory endpoint;
    JPanel dataTablesPanel;
    ServiceInputPanel inputDataTables;
    MySwingWorker runWorker;
    ResultsPanel results;
    JComponent resultsComp;
    JSplitPane resSplit;
    boolean selectionAllowed = false;
    protected static Icon runIcon;
    protected static Icon runIconDis;
    protected static Icon stopIcon;
    protected static Icon stopIconDis;
    protected static Icon addDataIcon;
    protected static Icon addDataIconDis;
    private ActionListener howToListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String howTo = e.getActionCommand();
            SimpleClientPanel.this.setPrefValue("howToCallService", howTo);
            SimpleClientPanel.this.propertyChannel.put("howToCallService", howTo);
            SimpleClientPanel.this.endpoint.setEnabled(howTo.equals("service-new-endpoint"));
            SimpleClientPanel.this.className.setEnabled(howTo.equals("local-class"));
        }
    };

    public SimpleClientPanel() {
        this.panelIconFileName = "images/debug.gif";
    }

    @Override
    protected void loadIcons() {
        super.loadIcons();
        if (runIcon == null) {
            runIcon = SimpleClientPanel.loadIcon("images/smallRun.gif");
        }
        if (runIconDis == null) {
            runIconDis = SimpleClientPanel.loadIcon("images/smallRun_dis.gif");
        }
        if (stopIcon == null) {
            stopIcon = SimpleClientPanel.loadIcon("images/smallCancel.gif");
        }
        if (stopIconDis == null) {
            stopIconDis = SimpleClientPanel.loadIcon("images/smallCancel_dis.gif");
        }
        if (addDataIcon == null) {
            addDataIcon = SimpleClientPanel.loadIcon("images/smallAnnotate.gif");
        }
        if (addDataIconDis == null) {
            addDataIconDis = SimpleClientPanel.loadIcon("images/smallAnnonate_dis.gif");
        }
    }

    @Override
    public JComponent getComponent(PropertyChannel aPropertyChannel) {
        this.setPropertyChannel(aPropertyChannel);
        this.registryModel = this.createRegistryModel();
        this.callerModel = new ServiceCallerModel();
        this.callerModel.setPropertyChannel(aPropertyChannel);
        if (this.pComponent != null) {
            return this.pComponent;
        }
        this.pComponent = new JPanel(new GridBagLayout(), true);
        this.results = new ResultsPanel();
        this.resultsComp = this.results.getComponent(aPropertyChannel);
        this.propertyChannel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("detachViewers".equals(e.getPropertyName())) {
                    MobyService srv = (MobyService)SimpleClientPanel.this.propertyChannel.get("dp-sc-service");
                    String title = srv == null ? "Service results" : srv.getName() + " at " + new Date();
                    JComponent current = SimpleClientPanel.this.results.getComponent(SimpleClientPanel.this.propertyChannel);
                    SimpleClientPanel.this.results.adjustForDetachement();
                    JFrame newFrame = SwingUtils.createSoftMainFrame((JComponent)current, (String)title);
                    Dimension dim = current.getPreferredSize();
                    SwingUtils.showMainFrameRelativeTo((Component)SimpleClientPanel.this.pComponent, (JFrame)newFrame, (int)((int)dim.getWidth()), (int)((int)dim.getHeight()));
                    SimpleClientPanel.this.results = new ResultsPanel();
                    SimpleClientPanel.this.resultsComp = SimpleClientPanel.this.results.getComponent(SimpleClientPanel.this.propertyChannel);
                    SimpleClientPanel.this.resSplit.setBottomComponent(SimpleClientPanel.this.resultsComp);
                }
            }
        });
        JPanel controls = this.getControlPanel();
        JPanel inputData = this.getInputPanel();
        this.updateInputDataPanel(INIT_SELECT);
        JPanel sBoard = new JPanel(new GridBagLayout());
        ServicesBoard servicesBoard = new ServicesBoard(this.registryModel, null, this.propertyChannel, new CustomServicesTree(this.registryModel, null));
        log.debug((Object)"Services tree update started");
        servicesBoard.updateTree(1);
        SwingUtils.addComponent((JComponent)sBoard, (Component)servicesBoard, (int)0, (int)2, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        this.resSplit = this.vSplit(this.hSplit(controls, sBoard, 0.5), this.resultsComp, 0.1);
        JSplitPane split = this.hSplit(this.resSplit, inputData, 0.5);
        SwingUtils.addComponent((JComponent)this.pComponent, (Component)split, (int)0, (int)0, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        String lastServiceName = this.getPrefValue("dp-sc-service-name", "");
        if (!"".equals(lastServiceName)) {
            this.selectService(lastServiceName);
        }
        return this.pComponent;
    }

    protected JPanel getControlPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        this.selService = new JLabel();
        this.selService.setFont(FAT_BORDER_FONT);
        this.selService.setForeground(GraphColours.getColour(DashboardConfig.getString(P_S_TITLE_COLOR, null), Color.blue));
        JPanel howTo = SimpleClientPanel.createTitledPanel("Service invocation");
        this.endpoint = this.createText(null, "serviceEndpoint", "serviceEndpoint");
        this.className = this.createText(null, "serviceImplClass", "serviceImplClass");
        ButtonGroup group = new ButtonGroup();
        JRadioButton htEndpoint = this.createHowToButton("Use service's usual endpoint", "service-endpoint");
        group.add(htEndpoint);
        JRadioButton htNone = this.createHowToButton("No real call, just show/echo input", "no-call");
        htNone.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enabled;
                boolean bl = enabled = e.getStateChange() == 1;
                if (enabled) {
                    SimpleClientPanel.this.runButton.setText(" Show Input ");
                } else if (SimpleClientPanel.this.propertyChannel.getBoolean("sendEmptyInputAsPing", false)) {
                    SimpleClientPanel.this.runButton.setText(" Ping Service ");
                } else {
                    SimpleClientPanel.this.runButton.setText(" Call Service ");
                }
            }
        });
        group.add(htNone);
        JRadioButton htRegistry = this.createHowToButton("Ask registry where service is, and call it", "as-registered");
        group.add(htRegistry);
        JRadioButton htNewURL = this.createHowToButton("Use this endpoint", "service-new-endpoint");
        group.add(htNewURL);
        JRadioButton htLocal = this.createHowToButton("Use this local class", "local-class");
        group.add(htLocal);
        boolean usingPing = this.getPrefValue("sendEmptyInputAsPing", false);
        boolean usingAsBytes = this.getPrefValue("sendInputAsBytes", false);
        String runLabel = " Call Service ";
        if (this.propertyChannel.getString("howToCallService").equals("no-call")) {
            runLabel = " Show Input ";
        } else if (usingPing) {
            runLabel = " Ping Service ";
        }
        this.runButton = SimpleClientPanel.createButton(runLabel, "Invoke selected service", 67, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MobyService srv = (MobyService)SimpleClientPanel.this.propertyChannel.get("dp-sc-service");
                if (srv != null) {
                    if (SimpleClientPanel.this.propertyChannel.getBoolean("service-authentication", false)) {
                        SimpleClientPanel.this.askForAuthentication();
                    } else {
                        SimpleClientPanel.this.propertyChannel.remove("service-authentication-user");
                        SimpleClientPanel.this.propertyChannel.remove("service-authentication-passwd");
                    }
                    SimpleClientPanel.this.runWorker = new MySwingWorker(srv);
                    SimpleClientPanel.this.runWorker.start();
                }
            }
        });
        this.runButton.setIcon(runIcon);
        this.runButton.setDisabledIcon(runIconDis);
        this.runButton.setEnabled(false);
        this.stopButton = SimpleClientPanel.createButton(" Stop service ", "Cancel connection to a running service", 83, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimpleClientPanel.this.runWorker != null) {
                    SimpleClientPanel.this.runWorker.cancel();
                }
                SimpleClientPanel.this.serviceFinished();
            }
        });
        this.stopButton.setIcon(stopIcon);
        this.stopButton.setDisabledIcon(stopIconDis);
        this.stopButton.setEnabled(false);
        JPanel buttonPanel = SimpleClientPanel.createButtonPanel(new JButton[]{this.runButton, this.stopButton});
        JCheckBox asPing = SimpleClientPanel.createCheckBox("'Ping' this service", usingPing, -1, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enabled = e.getStateChange() == 1;
                SimpleClientPanel.this.setPropertySelect(enabled, "sendEmptyInputAsPing");
                SimpleClientPanel.this.setPrefValue("sendEmptyInputAsPing", enabled);
                SimpleClientPanel.this.propertyChannel.put("sendEmptyInputAsPing", new Boolean(enabled).toString());
                if (enabled) {
                    if (SimpleClientPanel.this.propertyChannel.getString("howToCallService").equals("no-call")) {
                        SimpleClientPanel.this.runButton.setText(" Show Input ");
                    } else {
                        SimpleClientPanel.this.runButton.setText(" Ping Service ");
                    }
                } else if (SimpleClientPanel.this.propertyChannel.getString("howToCallService").equals("no-call")) {
                    SimpleClientPanel.this.runButton.setText(" Show Input ");
                } else {
                    SimpleClientPanel.this.runButton.setText(" Call Service ");
                }
            }
        });
        this.setPropertySelect(usingPing, "sendEmptyInputAsPing");
        asPing.setToolTipText("A Moby 'Ping' is used to determine if the service is responsive and if it responds in an API-compliant manner.");
        Font font = asPing.getFont();
        asPing.setFont(font.deriveFont(Math.max(1.0f, font.getSize2D() - 1.0f)));
        JCheckBox asBytes = SimpleClientPanel.createCheckBox("Send data to service as a byte array", usingAsBytes, -1, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enabled = e.getStateChange() == 1;
                SimpleClientPanel.this.setPropertySelect(enabled, "sendInputAsBytes");
                SimpleClientPanel.this.setPrefValue("sendInputAsBytes", enabled);
                SimpleClientPanel.this.propertyChannel.put("sendInputAsBytes", new Boolean(enabled).toString());
            }
        });
        this.setPropertySelect(usingAsBytes, "sendInputAsBytes");
        asBytes.setToolTipText("It should not have any effect on result; it is for debugging");
        font = asBytes.getFont();
        asBytes.setFont(font.deriveFont(Math.max(1.0f, font.getSize2D() - 1.0f)));
        JCheckBox authenticationBox = SimpleClientPanel.createCheckBox("Use a user/password for service authentication", false, -1, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SimpleClientPanel.this.propertyChannel.put("service-authentication", (Object)(e.getStateChange() == 1 ? 1 : 0));
            }
        });
        authenticationBox.setToolTipText("If the service requires authentication.A dialog will open if you call the service to enter the authentication.");
        font = authenticationBox.getFont();
        authenticationBox.setFont(font.deriveFont(Math.max(1.0f, font.getSize2D() - 1.0f)));
        SwingUtils.addComponent((JComponent)howTo, (Component)htEndpoint, (int)0, (int)0, (int)2, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)howTo, (Component)htNewURL, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)howTo, (Component)this.endpoint, (int)1, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)howTo, (Component)htRegistry, (int)0, (int)2, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)howTo, (Component)htLocal, (int)0, (int)3, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)howTo, (Component)this.className, (int)1, (int)3, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)howTo, (Component)htNone, (int)0, (int)4, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)howTo, (Component)asPing, (int)0, (int)5, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)howTo, (Component)asBytes, (int)0, (int)6, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)howTo, (Component)authenticationBox, (int)0, (int)7, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        Component glue = Box.createVerticalGlue();
        SwingUtils.addComponent((JComponent)p, (Component)this.selService, (int)0, (int)0, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)howTo, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)buttonPanel, (int)0, (int)2, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)p, (Component)glue, (int)0, (int)3, (int)1, (int)1, (int)3, (int)18, (double)0.0, (double)1.0);
        return p;
    }

    private void askForAuthentication() {
        final JDialog dialog = new JDialog(new JFrame(), "Authentication", true);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Insets insets = new Insets(4, 4, 4, 4);
        JLabel label = new JLabel("Please enter your username and password !");
        SwingUtils.addComponent((JComponent)panel, (Component)label, (int)0, (int)0, (int)2, (int)1, (int)2, (int)10, (double)1.0, (double)0.0, (Insets)insets);
        label = new JLabel("User: ");
        SwingUtils.addComponent((JComponent)panel, (Component)label, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0, (Insets)insets);
        final JTextField userField = new JTextField(this.propertyChannel.getString("service-authentication-user"), 20);
        SwingUtils.addComponent((JComponent)panel, (Component)userField, (int)1, (int)1, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0, (Insets)insets);
        label = new JLabel("Password: ");
        SwingUtils.addComponent((JComponent)panel, (Component)label, (int)0, (int)2, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0, (Insets)insets);
        final JPasswordField passwordField = new JPasswordField(this.propertyChannel.getString("service-authentication-passwd"), 20);
        SwingUtils.addComponent((JComponent)panel, (Component)passwordField, (int)1, (int)2, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0, (Insets)insets);
        JButton button = new JButton("Enter...");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleClientPanel.this.propertyChannel.put("service-authentication-user", userField.getText());
                SimpleClientPanel.this.propertyChannel.put("service-authentication-passwd", new String(passwordField.getPassword()));
                dialog.setVisible(false);
            }
        });
        SwingUtils.addComponent((JComponent)panel, (Component)button, (int)0, (int)3, (int)2, (int)1, (int)2, (int)10, (double)0.0, (double)0.0, (Insets)insets);
        dialog.setContentPane(panel);
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    protected void setPropertySelect(boolean enabled, String property) {
        this.setPrefValue(property, enabled);
        this.propertyChannel.put(property, new Boolean(enabled).toString());
    }

    private JRadioButton createHowToButton(String title, String howTo) {
        JRadioButton radio = new JRadioButton(title);
        radio.setActionCommand(howTo);
        radio.addActionListener(this.howToListener);
        String initHowTo = this.getPrefValue("howToCallService", "no-call");
        if (howTo.equals(initHowTo)) {
            radio.setSelected(true);
            radio.setEnabled(true);
            this.propertyChannel.put("howToCallService", howTo);
        }
        this.endpoint.setEnabled(initHowTo.equals("service-new-endpoint"));
        this.className.setEnabled(initHowTo.equals("local-class"));
        return radio;
    }

    private JCheckBox createDataBox(String title, final String preferenceKey, boolean defaultValue) {
        boolean initValue = this.getPrefValue(preferenceKey, defaultValue);
        this.propertyChannel.put(preferenceKey, new Boolean(initValue).toString());
        return SimpleClientPanel.createCheckBox(title, initValue, -1, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enabled = e.getStateChange() == 1;
                SimpleClientPanel.this.setPrefValue(preferenceKey, enabled);
                SimpleClientPanel.this.propertyChannel.put(preferenceKey, new Boolean(enabled).toString());
                SimpleClientPanel.this.inFile.setEnabled(SimpleClientPanel.this.iFromFile.isSelected());
            }
        });
    }

    protected JPanel getInputPanel() {
        JPanel inputData = new JPanel(new GridBagLayout());
        inputData.setBorder(SimpleClientPanel.createFatBorder("Service Input Data", GraphColours.getColour("cadetblue", Color.blue)));
        JPanel upper = new JPanel(new GridBagLayout());
        this.dataTablesPanel = new JPanel(new GridBagLayout());
        this.iFromFile = this.createDataBox("Take an input from this XML file", "sc-inputFromFile", false);
        this.inFile = this.createFileSelector("Select input XML for calling a service", "Select", null, "sc-inputFile", "sc-inputFile");
        this.inFile.setEnabled(this.iFromFile.isSelected());
        this.iShowXML = this.createDataBox("Show input as XML", "showInputAsXML", true);
        SwingUtils.addComponent((JComponent)upper, (Component)this.dataTablesPanel, (int)0, (int)0, (int)2, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        SwingUtils.addComponent((JComponent)upper, (Component)this.iFromFile, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)upper, (Component)this.inFile, (int)1, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)upper, (Component)this.iShowXML, (int)0, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        this.input = new EditableConsole();
        this.input.setAppendMode(false);
        this.input.setVerboseMode(false);
        JSplitPane split = this.vSplit(upper, this.input, 0.5);
        SwingUtils.addComponent((JComponent)inputData, (Component)split, (int)0, (int)0, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        return inputData;
    }

    protected void updateInputDataPanel(String info) {
        this.dataTablesPanel.removeAll();
        AwtUtils.redisplay((Component)this.dataTablesPanel);
        JLabel text = new JLabel(info);
        SwingUtils.addComponent((JComponent)this.dataTablesPanel, (Component)text, (int)0, (int)0, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0);
        this.dataTablesPanel.validate();
    }

    protected void updateInputDataPanel(MobyService service, MobyDataType[] dataTypes) {
        this.dataTablesPanel.removeAll();
        this.inputDataTables = new ServiceInputPanel(service, dataTypes);
        SwingUtils.addComponent((JComponent)this.dataTablesPanel, (Component)this.inputDataTables, (int)0, (int)0, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        this.dataTablesPanel.validate();
    }

    protected MobyDataType findDataType(String dataTypeToBeFound, MobyDataType[] dataTypes) {
        for (int i = 0; i < dataTypes.length; ++i) {
            if (!dataTypeToBeFound.equals(dataTypes[i].getName())) continue;
            return dataTypes[i];
        }
        log.error((Object)("Strange, data type '" + dataTypeToBeFound + "' was not found in " + dataTypes.length + " data types."));
        return null;
    }

    protected void serviceFinished() {
        this.runButton.setEnabled(true);
        this.stopButton.setEnabled(false);
    }

    protected void selectService(final String serviceName) {
        final SimpleClientPanel source = this;
        SwingWorker worker = new SwingWorker(){
            MobyService service;
            MobyDataType[] dataTypes;

            @Override
            public Object construct() {
                try {
                    this.service = SimpleClientPanel.this.registryModel.getService(serviceName);
                    this.dataTypes = SimpleClientPanel.this.registryModel.getDataTypes(source);
                }
                catch (MobyException e) {
                    AbstractPanel.error("An error happened when accessing a list of available services.\n\nCheck please values in text fields (in Registry Browser)\nspecifying registry endpoint and namespace, and in the\none specifying directory used as a local cache. Then\nright-click in the data types area and select 'Reload'.\n\n", (Exception)((Object)e));
                }
                return this.service;
            }

            @Override
            public void finished() {
                if (this.service == null) {
                    SimpleClientPanel.this.deselectService();
                } else {
                    SimpleClientPanel.this.updateInputDataPanel(this.service, this.dataTypes);
                    SimpleClientPanel.this.selService.setText(this.service.getName());
                    SimpleClientPanel.this.propertyChannel.put("dp-sc-service", this.service);
                    SimpleClientPanel.this.runButton.setEnabled(true);
                }
            }
        };
        worker.start();
    }

    protected void deselectService() {
        this.selService.setText("");
        this.updateInputDataPanel(INIT_SELECT);
        this.propertyChannel.remove("dp-sc-service");
        this.runButton.setEnabled(false);
    }

    @Override
    public String getName() {
        return "Simple Client";
    }

    @Override
    public String getDescription() {
        return "A panel allowing to create input data and to call an arbitrary Biomoby service. Its purpose is mostly for the service developers to test their new services.";
    }

    protected class CustomServicesTree
    extends ServicesTree {
        public CustomServicesTree(RegistryModel model, CommonConsole console) {
            super(model, console);
        }

        @Override
        protected void createPopups(String title) {
            super.createPopups(title);
            this.removeFromPopups("ac-reload");
            this.removeSeparatorAfter("ac-collapse");
        }

        @Override
        protected void selected(DefaultMutableTreeNode node) {
            if (node == null) {
                SimpleClientPanel.this.deselectService();
                return;
            }
            SimpleClientPanel.this.updateInputDataPanel("Loading...");
            SimpleClientPanel.this.selService.setText("");
            CommonNode nodeObject = (CommonNode)node.getUserObject();
            String currentServiceName = nodeObject.getValue();
            SimpleClientPanel.this.selectService(currentServiceName);
            SimpleClientPanel.this.setPrefValue("dp-sc-service-name", currentServiceName);
        }
    }

    class MySwingWorker
    extends SwingWorker {
        MobyException exception = null;
        DataContainer data = new DataContainer();
        boolean wasCancelled = false;
        MobyService service;

        public MySwingWorker(MobyService service) {
            this.service = service;
            this.data.setMetadata(SimpleClientPanel.this.propertyChannel);
        }

        public void cancel() {
            this.wasCancelled = true;
            SimpleClientPanel.this.propertyChannel.fire("status-msg", "Service invocation cancelled.");
        }

        @Override
        public Object construct() {
            try {
                SimpleClientPanel.this.runButton.setEnabled(false);
                SimpleClientPanel.this.propertyChannel.fire("status-msg", "Calling service " + this.service.getName() + "...");
                if (SimpleClientPanel.this.propertyChannel.getBoolean("sc-inputFromFile", false)) {
                    String inputFile = SimpleClientPanel.this.propertyChannel.getString("sc-inputFile");
                    if (UUtils.isEmpty((String)inputFile)) {
                        throw new MobyException("No input XML file given.");
                    }
                    this.data.setDataFromFile(new File(inputFile));
                } else {
                    this.data.setData(SimpleClientPanel.this.inputDataTables.toXML());
                }
                if ("no-call".equals(SimpleClientPanel.this.propertyChannel.getString("howToCallService")) || SimpleClientPanel.this.propertyChannel.getBoolean("showInputAsXML", false)) {
                    SimpleClientPanel.this.input.setText((String)this.data.getData());
                }
                if (SimpleClientPanel.this.propertyChannel.getString("sendEmptyInputAsPing").toLowerCase().equals("true")) {
                    String emptyMsg = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<moby:MOBY xmlns:moby=\"http://www.biomoby.org/moby\">\n  <moby:mobyContent />\n</moby:MOBY>";
                    this.data.setData(emptyMsg);
                    SimpleClientPanel.this.input.setText(emptyMsg);
                }
                SimpleClientPanel.this.stopButton.setEnabled(true);
                SimpleClientPanel.this.callerModel.runIt(this.data);
            }
            catch (MobyException e) {
                this.exception = e;
            }
            catch (Error e) {
                this.exception = new MobyException(e.toString());
            }
            return null;
        }

        @Override
        public void finished() {
            if (this.wasCancelled) {
                return;
            }
            if (this.exception == null) {
                if (SimpleClientPanel.this.propertyChannel.getString("sendEmptyInputAsPing").toLowerCase().equals("true")) {
                    SimpleClientPanel.this.propertyChannel.fire("status-msg", this.service.getName() + " isAlive.");
                } else {
                    SimpleClientPanel.this.propertyChannel.fire("status-msg", "Service invocation finished.");
                }
                if (!"no-call".equals(SimpleClientPanel.this.propertyChannel.getString("howToCallService"))) {
                    SimpleClientPanel.this.results.updateComponent(this.data);
                }
            } else {
                if (SimpleClientPanel.this.propertyChannel.getString("sendEmptyInputAsPing").toLowerCase().equals("true")) {
                    SimpleClientPanel.this.propertyChannel.fire("status-msg", this.service.getName() + " is dead.");
                    SimpleClientPanel.this.results.removeResults();
                } else {
                    SimpleClientPanel.this.propertyChannel.fire("status-msg", "Service invocation failed.");
                    AbstractPanel.error(SimpleClientPanel.CALLER_ERROR, (Exception)((Object)this.exception));
                }
                this.exception.printStackTrace();
            }
            SimpleClientPanel.this.serviceFinished();
        }
    }

    class EditableConsole
    extends CommonConsole {
        public EditableConsole() {
            this.textArea.setEditable(true);
            this.textArea.setBackground(GraphColours.getColour(DashboardConfig.getString(SimpleClientPanel.P_S_EDIT_BGCOLOR, null), this.textArea.getBackground()));
        }
    }
}

