/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.DemuxInputStream;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Diagnostics;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;

public class SimpleAnt {
    private static Log log = LogFactory.getLog(SimpleAnt.class);
    private int msgOutputLevel = 2;
    private File buildFile = new File("build.xml");
    private static PrintStream out = System.out;
    private static PrintStream err = System.err;
    private Properties definedProps = new Properties();
    private Vector<BuildListener> listeners = new Vector(1);
    private boolean allowInput = false;
    private InputHandler inputHandler = new DefaultInputHandler();

    public void setAllowInput(boolean enabled) {
        this.allowInput = enabled;
    }

    public void setMsgOutputLevel(int level) {
        this.msgOutputLevel = level;
    }

    public synchronized void addBuildListener(BuildListener listener) {
        this.listeners.addElement(listener);
    }

    public synchronized void removeBuildListener(BuildListener listener) {
        this.listeners.removeElement(listener);
    }

    public void startAnt(String[] newTargets, Properties additionalUserProperties) throws BuildException {
        Diagnostics.validateVersion();
        Vector<String> targets = new Vector<String>(newTargets.length);
        for (int i = 0; i < newTargets.length; ++i) {
            targets.addElement(newTargets[i]);
        }
        if (!this.buildFile.exists()) {
            throw new BuildException("Buildfile: " + this.buildFile + " does not exist!");
        }
        if (this.buildFile.isDirectory()) {
            throw new BuildException("Buildfile: " + this.buildFile + " is a dir!");
        }
        if (additionalUserProperties != null) {
            Enumeration<Object> e = additionalUserProperties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String property = additionalUserProperties.getProperty(key);
                this.definedProps.put(key, property);
            }
        }
        this.runBuild(targets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBuild(Vector<String> targets) throws BuildException {
        Project project = new Project();
        Throwable error = null;
        if (this.listeners.size() == 0) {
            DefaultLogger logger = new DefaultLogger();
            logger.setMessageOutputLevel(this.msgOutputLevel);
            logger.setOutputPrintStream(out);
            logger.setErrorPrintStream(err);
            this.addBuildListener((BuildListener)logger);
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            BuildListener listener = this.listeners.elementAt(i);
            if (listener instanceof BuildLogger) {
                ((BuildLogger)listener).setMessageOutputLevel(this.msgOutputLevel);
            }
            project.setProjectReference((Object)listener);
            project.addBuildListener(listener);
        }
        try {
            if (this.inputHandler == null) {
                this.inputHandler = new DefaultInputHandler();
            }
            project.setProjectReference((Object)this.inputHandler);
            project.setInputHandler(this.inputHandler);
            PrintStream _err = System.err;
            PrintStream _out = System.out;
            InputStream _in = System.in;
            try {
                if (this.allowInput) {
                    project.setDefaultInputStream(System.in);
                }
                System.setIn((InputStream)new DemuxInputStream(project));
                System.setOut(new PrintStream((OutputStream)new DemuxOutputStream(project, false)));
                System.setErr(new PrintStream((OutputStream)new DemuxOutputStream(project, true)));
                project.fireBuildStarted();
                project.init();
                project.setUserProperty("ant.version", Main.getAntVersion());
                Enumeration<Object> e = this.definedProps.keys();
                while (e.hasMoreElements()) {
                    String arg = (String)e.nextElement();
                    String value = (String)this.definedProps.get(arg);
                    project.setUserProperty(arg, value);
                }
                project.setUserProperty("ant.file", this.buildFile.getAbsolutePath());
                project.setKeepGoingMode(false);
                ProjectHelper.configureProject((Project)project, (File)this.buildFile);
                if (targets.size() == 0 && project.getDefaultTarget() != null) {
                    targets.addElement(project.getDefaultTarget());
                }
                Target theTarget = new Target();
                Enumeration<String> en = targets.elements();
                while (en.hasMoreElements()) {
                    theTarget.addDependency(en.nextElement());
                }
                project.addTarget("__the__target__", theTarget);
                project.executeTarget("__the__target__");
            }
            finally {
                System.setOut(_out);
                System.setErr(_err);
                System.setIn(_in);
            }
        }
        catch (BuildException e) {
            error = e;
            throw e;
        }
        catch (Throwable e) {
            error = e;
            throw new BuildException("Running Ant failed.", e);
        }
        finally {
            if (error != null) {
                log.error((Object)error.toString());
            }
            project.fireBuildFinished(error);
        }
    }
}

