/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biomoby.service.dashboard.CommonConsole;
import org.biomoby.service.dashboard.CommonNode;
import org.biomoby.service.dashboard.CommonTree;
import org.biomoby.service.dashboard.RegistryModel;
import org.biomoby.service.dashboard.SwingWorker;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyPrimaryData;
import org.biomoby.shared.MobyService;
import org.biomoby.shared.MobyServiceType;

public class ServicesTree
extends CommonTree {
    private static Log log = LogFactory.getLog(ServicesTree.class);
    protected static final String AC_TSORT = "ac-tsort";
    protected static final String AC_ISORT = "ac-isort";
    protected static final String AC_OSORT = "ac-osort";
    RegistryModel registryModel;
    CommonConsole console;
    protected static final String SERVICES_ACCESS_ERROR = "An error happened when accessing a list of available services.\n\nCheck please values in text fields (in Registry Browser)\nspecifying registry endpoint and namespace, and in the\none specifying directory used as a local cache. Then\nright-click in the data types area and select 'Reload'.\n\n";

    public ServicesTree(RegistryModel registryModel, CommonConsole console) {
        super("Services");
        this.registryModel = registryModel;
        this.console = console;
        this.createPopups("Services Menu");
        this.setLeafIcon(sLeafIcon);
    }

    @Override
    protected void createPopups(String title) {
        super.createPopups(title);
        this.addSortingItems();
        this.popup.add(ServicesTree.createMenuItem(new AbstractAction("Sort by service types"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServicesTree.this.lastSorted = 11;
                ServicesTree.this.update(11, null);
            }
        }, AC_TSORT, smallTIcon, smallTIconDis));
        this.popup.add(ServicesTree.createMenuItem(new AbstractAction("Sort by input data types"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServicesTree.this.lastSorted = 12;
                ServicesTree.this.update(12, null);
            }
        }, AC_ISORT, smallIIcon, smallIIconDis));
        this.popup.add(ServicesTree.createMenuItem(new AbstractAction("Sort by output data types"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServicesTree.this.lastSorted = 13;
                ServicesTree.this.update(13, null);
            }
        }, AC_OSORT, smallOIcon, smallOIconDis));
    }

    @Override
    public void update(int howSorted, Object newData) {
        if (howSorted < 0) {
            howSorted = this.lastSorted;
        }
        this.lastSorted = howSorted;
        this.setEnabledPopup(false);
        final ServicesTree source = this;
        final int sorted = howSorted;
        final MobyService[] newServices = newData == null ? null : (MobyService[])newData;
        SwingWorker worker = new SwingWorker(){
            MobyException updateException = null;
            MobyService[] services = null;
            MobyServiceType[] serviceTypes = null;
            MobyDataType[] dataTypes = null;

            @Override
            public Object construct() {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Tree " + ServicesTree.this.treeId + " update request. Sorted: " + sorted + ", Data: " + newServices));
                    }
                    this.services = newServices == null ? ServicesTree.this.registryModel.getServices(source) : newServices;
                    if (sorted == 11) {
                        this.serviceTypes = ServicesTree.this.registryModel.getServiceTypes(source);
                    } else if (sorted == 12 || sorted == 13) {
                        this.dataTypes = ServicesTree.this.registryModel.getDataTypes(source);
                    }
                }
                catch (MobyException e) {
                    this.updateException = e;
                }
                return this.services;
            }

            @Override
            public void finished() {
                if (this.updateException != null) {
                    CommonTree.error(ServicesTree.SERVICES_ACCESS_ERROR, (Exception)((Object)this.updateException));
                }
                if (this.services != null) {
                    if (sorted == 1) {
                        ServicesTree.this.onUpdateServicesTreeByAuth(this.services);
                    } else if (sorted == 11 && this.serviceTypes != null) {
                        ServicesTree.this.onUpdateServicesTreeByType(this.services, this.serviceTypes);
                    } else if (sorted == 12 && this.dataTypes != null) {
                        ServicesTree.this.onUpdateServicesTreeByData(this.services, this.dataTypes, 12);
                    } else if (sorted == 13 && this.dataTypes != null) {
                        ServicesTree.this.onUpdateServicesTreeByData(this.services, this.dataTypes, 13);
                    } else {
                        ServicesTree.this.onUpdateServicesTree(this.services);
                    }
                    if (this.services.length > 0) {
                        ServicesTree.this.setEnabledPopup(true);
                    }
                }
            }
        };
        worker.start();
    }

    void onUpdateServicesTree(MobyService[] theServices) {
        Object[] services = this.copy(theServices);
        Arrays.sort(services);
        DefaultTreeModel tModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tModel.getRoot();
        root.removeAllChildren();
        HashMap<String, DefaultMutableTreeNode> nodes = new HashMap<String, DefaultMutableTreeNode>(services.length);
        for (int i = 0; i < services.length; ++i) {
            String startingWith;
            DefaultMutableTreeNode parentNode;
            String thisName = services[i].getUniqueName();
            DefaultMutableTreeNode thisNode = (DefaultMutableTreeNode)nodes.get(thisName);
            if (thisNode == null) {
                thisNode = new DefaultMutableTreeNode(new CommonNode(services[i].getName(), thisName, 14));
                nodes.put(thisName, thisNode);
            }
            if ((parentNode = (DefaultMutableTreeNode)nodes.get(startingWith = thisName.substring(0, 1).toUpperCase())) == null) {
                parentNode = new DefaultMutableTreeNode(new CommonNode(startingWith));
                nodes.put(startingWith, parentNode);
                root.add(parentNode);
            }
            parentNode.add(thisNode);
        }
        tModel.reload();
    }

    void onUpdateServicesTreeByAuth(MobyService[] theServices) {
        MobyService[] services = this.copy(theServices);
        Arrays.sort(services, MobyService.getAuthorityComparator());
        DefaultTreeModel tModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tModel.getRoot();
        root.removeAllChildren();
        HashMap<String, DefaultMutableTreeNode> nodes = new HashMap<String, DefaultMutableTreeNode>(services.length);
        for (int i = 0; i < services.length; ++i) {
            DefaultMutableTreeNode authNode;
            String authority;
            String thisName = services[i].getUniqueName();
            DefaultMutableTreeNode thisNode = (DefaultMutableTreeNode)nodes.get(thisName);
            if (thisNode == null) {
                thisNode = new DefaultMutableTreeNode(new CommonNode(services[i].getName(), thisName, 14));
                nodes.put(thisName, thisNode);
            }
            if (StringUtils.isBlank((String)(authority = services[i].getAuthority()))) {
                authority = "<unknown>";
            }
            if ((authNode = (DefaultMutableTreeNode)nodes.get(authority)) == null) {
                authNode = new DefaultMutableTreeNode(new CommonNode(authority, 15));
                nodes.put(authority, authNode);
                root.add(authNode);
            }
            authNode.add(thisNode);
        }
        tModel.reload();
    }

    void onUpdateServicesTreeByType(MobyService[] theServices, MobyServiceType[] serviceTypes) {
        DefaultMutableTreeNode node;
        int i;
        Object[] services = this.copy(theServices);
        Arrays.sort(services);
        DefaultTreeModel tModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tModel.getRoot();
        root.removeAllChildren();
        HashMap<String, DefaultMutableTreeNode> nodes = new HashMap<String, DefaultMutableTreeNode>(serviceTypes.length);
        for (i = 0; i < serviceTypes.length; ++i) {
            String[] parents;
            String thisName = serviceTypes[i].getName();
            DefaultMutableTreeNode thisNode = (DefaultMutableTreeNode)nodes.get(thisName);
            if (thisNode == null) {
                thisNode = new DefaultMutableTreeNode(new CommonNode(thisName, 13));
                nodes.put(thisName, thisNode);
            }
            if ((parents = serviceTypes[i].getParentNames()).length == 0) {
                root.add(thisNode);
                continue;
            }
            String parentName = parents[0];
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)nodes.get(parentName);
            if (parentNode == null) {
                parentNode = new DefaultMutableTreeNode(new CommonNode(parentName, 13));
                nodes.put(parentName, parentNode);
            }
            parentNode.add(thisNode);
        }
        for (i = 0; i < services.length; ++i) {
            String type = services[i].getType();
            if (StringUtils.isBlank((String)type)) continue;
            String thisName = services[i].getUniqueName();
            DefaultMutableTreeNode thisNode = new DefaultMutableTreeNode(new CommonNode(services[i].getName(), thisName, 14));
            DefaultMutableTreeNode typeNode = (DefaultMutableTreeNode)nodes.get(type);
            if (typeNode == null) {
                typeNode = new DefaultMutableTreeNode(new CommonNode(type, 13));
                nodes.put(type, typeNode);
                root.add(typeNode);
            }
            typeNode.add(thisNode);
        }
        Vector<DefaultMutableTreeNode> leaves = new Vector<DefaultMutableTreeNode>();
        Enumeration<TreeNode> en = root.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            node = (DefaultMutableTreeNode)en.nextElement();
            if (!node.isLeaf() || ((CommonNode)node.getUserObject()).getType() != 13) continue;
            leaves.addElement(node);
        }
        en = leaves.elements();
        while (en.hasMoreElements()) {
            node = (DefaultMutableTreeNode)en.nextElement();
            node.removeFromParent();
        }
        tModel.reload();
    }

    void onUpdateServicesTreeByData(MobyService[] theServices, MobyDataType[] dataTypes, int whatData) {
        DefaultMutableTreeNode node;
        int i;
        Object[] services = this.copy(theServices);
        Arrays.sort(services);
        DefaultTreeModel tModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tModel.getRoot();
        root.removeAllChildren();
        HashMap<String, DefaultMutableTreeNode> nodes = new HashMap<String, DefaultMutableTreeNode>(dataTypes.length);
        for (i = 0; i < dataTypes.length; ++i) {
            String[] parents;
            String thisName = dataTypes[i].getName();
            DefaultMutableTreeNode thisNode = (DefaultMutableTreeNode)nodes.get(thisName);
            if (thisNode == null) {
                thisNode = new DefaultMutableTreeNode(new CommonNode(thisName, 11));
                nodes.put(thisName, thisNode);
            }
            if ((parents = dataTypes[i].getParentNames()).length == 0) {
                root.add(thisNode);
                continue;
            }
            String parentName = parents[0];
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)nodes.get(parentName);
            if (parentNode == null) {
                parentNode = new DefaultMutableTreeNode(new CommonNode(parentName, 11));
                nodes.put(parentName, parentNode);
            }
            parentNode.add(thisNode);
        }
        for (i = 0; i < services.length; ++i) {
            MobyPrimaryData[] data = whatData == 12 ? services[i].getPrimaryInputs() : services[i].getPrimaryOutputs();
            if (data == null || data.length == 0) continue;
            String thisName = services[i].getUniqueName();
            DefaultMutableTreeNode thisNode = new DefaultMutableTreeNode(new CommonNode(services[i].getName(), thisName, 14));
            for (int j = 0; j < data.length; ++j) {
                MobyPrimaryData datum = data[j];
                MobyDataType dataType = datum.getDataType();
                if (dataType == null) continue;
                String dataName = dataType.getName();
                DefaultMutableTreeNode dataNode = (DefaultMutableTreeNode)nodes.get(dataName);
                if (dataNode == null) {
                    dataNode = new DefaultMutableTreeNode(new CommonNode(dataName, 11));
                    nodes.put(dataName, dataNode);
                    root.add(dataNode);
                }
                dataNode.add(thisNode);
            }
        }
        Vector<DefaultMutableTreeNode> leaves = new Vector<DefaultMutableTreeNode>();
        Enumeration<TreeNode> en = root.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            node = (DefaultMutableTreeNode)en.nextElement();
            if (!node.isLeaf() || ((CommonNode)node.getUserObject()).getType() != 11) continue;
            leaves.addElement(node);
        }
        en = leaves.elements();
        while (en.hasMoreElements()) {
            node = (DefaultMutableTreeNode)en.nextElement();
            node.removeFromParent();
        }
        tModel.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MobyService[] copy(MobyService[] s) {
        MobyService[] mobyServiceArray = s;
        synchronized (s) {
            MobyService[] result = new MobyService[s.length];
            System.arraycopy(s, 0, result, 0, s.length);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    @Override
    protected void reload() {
        if (this.lastSorted > 9) {
            this.lastSorted = 0;
        }
        this.update(this.lastSorted, null);
    }

    @Override
    protected void search(String searchText) {
        final String regex = searchText;
        SwingWorker worker = new SwingWorker(){
            Set<String> found = new HashSet<String>();

            @Override
            public Object construct() {
                try {
                    if (StringUtils.isNotBlank((String)regex)) {
                        this.found = ServicesTree.this.registryModel.findInServices(regex);
                    }
                }
                catch (MobyException e) {
                    CommonTree.error(ServicesTree.SERVICES_ACCESS_ERROR, (Exception)((Object)e));
                }
                return this.found;
            }

            @Override
            public void finished() {
                if (this.found != null) {
                    ServicesTree.this.highlightAndJumpTo(this.found);
                }
            }
        };
        worker.start();
    }

    @Override
    protected void selected(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        final CommonNode nodeObject = (CommonNode)node.getUserObject();
        SwingWorker worker = new SwingWorker(){
            MobyService service;

            @Override
            public Object construct() {
                try {
                    this.service = ServicesTree.this.registryModel.getService(nodeObject.getValue());
                }
                catch (MobyException e) {
                    CommonTree.error(ServicesTree.SERVICES_ACCESS_ERROR, (Exception)((Object)e));
                }
                return this.service;
            }

            @Override
            public void finished() {
                if (this.service != null) {
                    ServicesTree.this.propertyChannel.fire("dp-s-selected", this.service);
                    if (ServicesTree.this.console != null) {
                        ServicesTree.this.console.setText(this.service.toString());
                    }
                }
            }
        };
        worker.start();
    }
}

